/*******************************************************************************
 * Copyright (c) 2010, 2011 Association for Decentralized Information Management in
 * Industry THTH ry.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *     VTT Technical Research Centre of Finland - initial API and implementation
 *******************************************************************************/
package org.simantics.browsing.ui.model.images;

import java.util.Collections;
import java.util.Map;

import org.eclipse.jface.resource.ImageDescriptor;
import org.simantics.db.ReadGraph;

/**
 * Constant image rule gives a fixed image to a node.
 * @author Hannu Niemistö
 */
public class ConstantImageRule implements ImageRule {
    ImageDescriptor image;
    String column;

    public ConstantImageRule(ImageDescriptor image, String column) {    
        this.image = image;
        this.column = column;
    }

    @Override
    public boolean isCompatible(Class<?> contentType) {
        return true;
    }

    @Override
    public Map<String, ImageDescriptor> getImage(ReadGraph graph, Object content) {
        return Collections.singletonMap(column, image);
    }
}
