/*******************************************************************************
 * Copyright (c) 2007, 2010 Association for Decentralized Information Management
 * in Industry THTH ry.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *     VTT Technical Research Centre of Finland - initial API and implementation
 *******************************************************************************/
package org.simantics.browsing.ui.graph.impl.contribution;

import java.util.Collection;
import java.util.function.Consumer;

import org.simantics.browsing.ui.BuiltinKeys;
import org.simantics.browsing.ui.BuiltinKeys.ViewpointContributionKey;
import org.simantics.browsing.ui.DataSource;
import org.simantics.browsing.ui.NodeContext;
import org.simantics.browsing.ui.PrimitiveQueryUpdater;
import org.simantics.browsing.ui.Tester;
import org.simantics.browsing.ui.common.NodeContextUtil;
import org.simantics.db.AsyncReadGraph;
import org.simantics.db.ReadGraph;
import org.simantics.db.common.request.ReadRequest;
import org.simantics.db.exception.DatabaseException;
import org.simantics.utils.ui.ErrorLogger;

/**
 * Implement {@link #children(AsyncReadGraph)} and {@link #hasChildren(AsyncReadGraph)}.
 * 
 * @author Tuukka Lehtonen
 */
abstract public class CallbackViewpointContributionImpl extends ContributionStub {

    /**
     * @param graph
     * @param context
     * @return a collection of contributions, must not be <code>null</code>
     * @throws DatabaseException
     */
    abstract public void children(ReadGraph graph, NodeContext context, Consumer<Collection<?>> callback) throws DatabaseException;

    public CallbackViewpointContributionImpl(PrimitiveQueryUpdater updater,
            NodeContext context, ViewpointContributionKey key) {

        assert updater != null;
        assert context != null;
        assert key != null;

        this.updater = updater;
        this.context = context;
        this.key = key;

    }

    final protected PrimitiveQueryUpdater       updater;
    final private NodeContext                context;
    final private BuiltinKeys.ViewpointContributionKey    key;

    public NodeContext getContext() {
        return context;
    }

    @Override
    public Collection<NodeContext> getContribution() {

        //System.out.println("LazyViewpoint2@" + System.identityHashCode(this) + " getChildren() = " + children.length);

        if (children == org.simantics.browsing.ui.content.ViewpointContribution.PENDING_CONTRIBUTION) {
            DataSource<AsyncReadGraph> source = updater.getDataSource(AsyncReadGraph.class);
            if (source != null) {
                source.schedule(graph -> {
                    ReadRequest childQuery = new ReadRequest() {

                        @Override
                        public void run(ReadGraph graph) throws DatabaseException {
                            try {
                                children(graph, context,
                                        result -> replaceChildrenResult(NodeContextUtil.toContextCollectionWithInput(CallbackViewpointContributionImpl.this, result)));
                            } catch (DatabaseException e) {
                                throw e;
                            } catch (Throwable t) {
                                ErrorLogger.defaultLogError("LazyContributionImpl.childQuery produced unexpected exception.", t);
                            }
                        }

                        @Override
                        public String toString() {
                            return "LazyContributionImpl[" + System.identityHashCode(CallbackViewpointContributionImpl.this) + "].childQuery";
                        }

                    };

                    graph.asyncRequest(childQuery);
                });
            }
        }

        //System.out.println("LazyViewpoint.getChildren returns " + children);

        return children;

    }

    protected void replaceChildrenResult(Collection<NodeContext> result) {
        setChildren(updater, result);
        updater.scheduleReplace(context, key, this);
    }

    /**
     * @param <T>
     * @param clazz
     * @return input of the specified class
     * @throws ClassCastException if the input class does not match the
     *         specified class
     * @throws NullPointerException if the input is null
     */
    @SuppressWarnings("unchecked")
    protected <T> T getInput(Class<T> clazz) throws ClassCastException {
        Object o = context.getConstant(BuiltinKeys.INPUT);
        if (o == null)
            throw new NullPointerException("null input");
//        return clazz.cast(o);
        return (T) o;
    }

    /**
     * @param <T>
     * @param clazz
     * @return <code>null</code> if input is <code>null</code> or if the class does not match
     */
    @SuppressWarnings("unchecked")
    protected <T> T tryGetInput(Class<T> clazz) {
        Object o = context.getConstant(BuiltinKeys.INPUT);
        if (o != null && clazz.isInstance(o))
//            return clazz.cast(o);
            return (T) o;
        return null;
    }

    @Override
    public Tester getNodeContextTester() {
        return null;
    }

}
