/*******************************************************************************
 * Copyright (c) 2007, 2010 Association for Decentralized Information Management
 * in Industry THTH ry.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *     VTT Technical Research Centre of Finland - initial API and implementation
 *******************************************************************************/
package org.simantics.browsing.ui.common.processors;

import org.simantics.browsing.ui.BuiltinKeys;
import org.simantics.browsing.ui.NodeContext;
import org.simantics.browsing.ui.PrimitiveQueryProcessor;

/**
 * A primitive query processor (see {@link PrimitiveQueryProcessor}) interface
 * for externally controlling the results of
 * {@link BuiltinKeys#SHOW_MAX_CHILDREN} queries.
 * 
 * @author Tuukka Lehtonen
 */
public interface ShowMaxChildrenProcessor {

    /**
     * Set internal processor showAllChildren status without notifying the graph
     * explorer query cache of changes.
     * 
     * @param context the context to mark
     * @param maxChildren the new max child count or 0 to make this processor
     *        return <code>null</code> when queried
     * @return <code>true</code> if the node's expanded state was changed,
     *         <code>false</code> otherwise
     */
    boolean setShowMaxChildren(NodeContext context, int maxChildren);

    /**
     * Replace the current processor showAllChildren status and notify the graph
     * explorer query cache of changes.
     * 
     * @param context the context to mark
     * @param maxChildren the new max child count or 0 to make this processor
     *        return <code>null</code> when queried
     * @return <code>true</code> if the node's expanded state was changed,
     *         <code>false</code> otherwise
     */
    boolean replaceShowMaxChildren(NodeContext context, int maxChildren);

}
