/*******************************************************************************
 * Copyright (c) 2007, 2010 Association for Decentralized Information Management
 * in Industry THTH ry.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *     VTT Technical Research Centre of Finland - initial API and implementation
 *******************************************************************************/
package org.simantics.browsing.ui.common.processors;

import java.util.Collection;

import org.simantics.browsing.ui.BuiltinKeys;
import org.simantics.browsing.ui.NodeContext;
import org.simantics.browsing.ui.NodeQueryManager;
import org.simantics.browsing.ui.NodeContext.QueryKey;
import org.simantics.browsing.ui.content.Viewpoint;
import org.simantics.browsing.ui.content.ViewpointFactory;

public class DefaultSelectedViewpointProcessor extends AbstractNodeQueryProcessor<Viewpoint> {

    @Override
    public QueryKey<Viewpoint> getIdentifier() {
        return BuiltinKeys.SELECTED_VIEWPOINT;
    }

    @Override
    public Viewpoint query(NodeQueryManager manager, NodeContext context) {
        Collection<ViewpointFactory> factories = manager.query(context, BuiltinKeys.VIEWPOINT_FACTORIES);
        if (factories.isEmpty())
            return null;

        ViewpointFactory selectedFactory = manager.query(context, new BuiltinKeys.SelectedViewpointFactoryKey(factories));
        if (selectedFactory == null)
            return null;

        return manager.query(context, new BuiltinKeys.ViewpointKey(selectedFactory));
    }

    @Override
    public String toString() {
        return "SelectedViewpointProcessor";
    }

}