/*******************************************************************************
 * Copyright (c) 2007, 2010 Association for Decentralized Information Management
 * in Industry THTH ry.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *     VTT Technical Research Centre of Finland - initial API and implementation
 *******************************************************************************/
package org.simantics.browsing.ui.common.processors;

import java.util.Collection;

import org.simantics.browsing.ui.BuiltinKeys;
import org.simantics.browsing.ui.NodeContext;
import org.simantics.browsing.ui.NodeQueryManager;
import org.simantics.browsing.ui.NodeContext.QueryKey;
import org.simantics.browsing.ui.common.labelers.ToStringLabeler;
import org.simantics.browsing.ui.content.Labeler;
import org.simantics.browsing.ui.content.LabelerFactory;

public class DefaultSelectedLabelerProcessor extends AbstractNodeQueryProcessor<Labeler> {

    @Override
    public QueryKey<Labeler> getIdentifier() {
        return BuiltinKeys.SELECTED_LABELER;
    }

    @Override
    public Labeler query(NodeQueryManager manager, NodeContext context) {
        
        Collection<LabelerFactory> labelers = manager.query(context, BuiltinKeys.LABELER_FACTORIES);
        if(labelers.isEmpty())
            return new ToStringLabeler(context);

        // TODO: use SelectedLabelerFactory query instead of this educated choice
        LabelerFactory factory = labelers.iterator().next();

        return manager.query(context, new BuiltinKeys.LabelerKey(factory));
        
    }

    @Override
    public String toString() {
        return "SelectedLabelerProcessor";
    }

}