/*******************************************************************************
 * Copyright (c) 2007, 2010 Association for Decentralized Information Management
 * in Industry THTH ry.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *     VTT Technical Research Centre of Finland - initial API and implementation
 *******************************************************************************/
package org.simantics.browsing.ui.common.labelers;

import java.util.Arrays;
import java.util.Map;

import org.simantics.browsing.ui.content.Labeler;

public class LabelerContent {

	public static LabelerContent NO_CONTENT = new LabelerContent(0, Labeler.NO_LABELS);

	public final int                 category;
    public final Map<String, String> labels;
    
    public LabelerContent(int category, Map<String, String> labels) {
        this.category = category;
        this.labels = labels;
    }
    
    @Override
    public String toString() {
        return "LabelerContent[" + Arrays.toString(labels.values().toArray()) + "]";
    }
    
    @Override
    public int hashCode() {
    	return category + 31 * labels.hashCode();
    }
    
    @Override
    public boolean equals(Object object) {
    	
        if (this == object)
            return true;
        else if (object == null)
            return false;
        else if (!(object instanceof LabelerContent))
            return false;

        LabelerContent lc = (LabelerContent)object;
        return category == lc.category && labels.equals(lc.labels);
        
    }
    
}
