/*******************************************************************************
 * Copyright (c) 2007, 2010 Association for Decentralized Information Management
 * in Industry THTH ry.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *     VTT Technical Research Centre of Finland - initial API and implementation
 *******************************************************************************/
package org.simantics.application.arguments;

public interface IArgumentValidator<T> {

    /**
     * Validates the given argument. Returns an error message to display if the
     * new text is invalid. Returns <code>null</code> if there is no error.
     * Note that the empty string is not treated the same as <code>null</code>;
     * it indicates an error state but with no message to display.
     * 
     * @param newText the text to check for validity
     * 
     * @return an error message or <code>null</code> if no error
     */
    public String isValid(T newText);

}
