/*******************************************************************************
 * Copyright (c) 2013 Association for Decentralized Information Management in
 * Industry THTH ry.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *     Semantum Oy - initial API and implementation
 *******************************************************************************/
package org.simantics.annotation.ui.modelBrowser2.model;

import org.simantics.annotation.ontology.AnnotationResource;
import org.simantics.browsing.ui.model.tests.Test;
import org.simantics.databoard.Bindings;
import org.simantics.db.ReadGraph;
import org.simantics.db.Resource;
import org.simantics.db.exception.DatabaseException;
import org.simantics.layer0.Layer0;

/**
 * @author Tuukka Lehtonen
 * @since 1.48.0
 */
public enum IsUserAnnotationTest implements Test {

	INSTANCE;

	public static IsUserAnnotationTest get() {
		return INSTANCE;
	}

	@Override
	public boolean isCompatible(Class<?> contentType) {
		return Resource.class.equals(contentType);
	}

	@Override
	public boolean test(ReadGraph graph, Object content) throws DatabaseException {
		AnnotationResource ANNO = AnnotationResource.getInstance(graph);
		Resource r = (Resource) content;
		// Optimization: Instead of using ReadGraph.getPossibleType, just
		// use getObjects with L0.InstanceOf which should be much faster.
		// This assumes no inheritance hierarchy in the annotation types.
		Layer0 L0 = graph.l0();
		for (Resource type : graph.getObjects(r, L0.InstanceOf)) {
			Boolean systemAnnotation = graph.getPossibleRelatedValue(type, ANNO.AnnotationType_systemAnnotation, Bindings.BOOLEAN);
			if (Boolean.TRUE.equals(systemAnnotation))
				return false;
		}
		return true;

		//Resource type = graph.getPossibleType(r, ANNO.Annotation);
		//Boolean systemAnnotation = graph.getPossibleRelatedValue(type, ANNO.AnnotationType_systemAnnotation, Bindings.BOOLEAN);
		//return !Boolean.TRUE.equals(systemAnnotation);
	}

}
