/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.acorn;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Map;
import org.rocksdb.RocksDB;
import org.rocksdb.RocksDBException;
import org.rocksdb.RocksIterator;
import org.simantics.acorn.AcornKeyRocks;
import org.simantics.db.IO;

public class RocksIO
implements IO {
    private RocksDB db;
    private byte[] path;
    private int writePosition = 0;

    public RocksIO(RocksDB db, AcornKeyRocks path) {
        this.db = db;
        this.path = path.keyBytes();
    }

    public synchronized int saveBytes(byte[] bytes, int length, boolean overwrite) throws IOException {
        try {
            if (overwrite) {
                this.writePosition = 0;
                if (length != bytes.length) {
                    this.db.put(this.path, Arrays.copyOf(bytes, length));
                } else {
                    this.db.put(this.path, bytes);
                }
            } else {
                String key = String.valueOf(new String(this.path)) + "." + this.writePosition;
                if (length != bytes.length) {
                    this.db.put(key.getBytes(), Arrays.copyOf(bytes, length));
                } else {
                    this.db.put(key.getBytes(), bytes);
                }
            }
            int result = this.writePosition;
            this.writePosition += length;
            return result;
        }
        catch (RocksDBException e) {
            e.printStackTrace();
            return 0;
        }
    }

    public synchronized byte[] readFully() throws RocksDBException {
        RocksIterator it = this.db.newIterator();
        it.seek(this.path);
        String prefix = new String(this.path);
        ArrayList<Map.Entry<Integer, byte[]>> data = new ArrayList<Map.Entry<Integer, byte[]>>();
        int subPos = prefix.length() + 1;
        int count = 0;
        while (it.isValid()) {
            String key = new String(it.key());
            if (!key.startsWith(prefix)) break;
            int n = 0;
            if (key.length() > subPos) {
                n = Integer.parseInt(key.substring(subPos));
            }
            byte[] bytes = it.value();
            data.add(Map.entry(n, bytes));
            count += bytes.length;
            it.next();
        }
        if (data.size() == 0) {
            return null;
        }
        if (data.size() == 1) {
            return (byte[])((Map.Entry)data.iterator().next()).getValue();
        }
        byte[] result = new byte[count];
        for (Map.Entry entry : data) {
            byte[] part = (byte[])entry.getValue();
            System.arraycopy(part, 0, result, (Integer)entry.getKey(), part.length);
        }
        return result;
    }

    public synchronized byte[] readBytes(long offset, int length) throws IOException {
        try {
            byte[] bs = this.readFully();
            if (bs == null) {
                throw new IOException("No data");
            }
            if (bs.length == length) {
                return bs;
            }
            byte[] result = new byte[length];
            System.arraycopy(bs, (int)offset, result, 0, length);
            return result;
        }
        catch (RocksDBException e) {
            throw new IOException(e);
        }
    }

    public synchronized long length() throws IOException {
        RocksIterator it = this.db.newIterator();
        it.seek(this.path);
        String prefix = new String(this.path);
        int count = 0;
        while (it.isValid()) {
            String key = new String(it.key());
            if (!key.startsWith(prefix)) break;
            byte[] bytes = it.value();
            count += bytes.length;
            it.next();
        }
        return count;
    }
}

