/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.acorn;

import java.io.File;
import java.io.IOException;
import java.nio.file.FileVisitOption;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.stream.Stream;
import org.simantics.acorn.AcornKey;
import org.simantics.acorn.AcornKeyFile;
import org.simantics.acorn.FileIO;
import org.simantics.acorn.MainState;
import org.simantics.acorn.Store;
import org.simantics.db.IO;
import org.simantics.utils.FileUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FileStore
implements Store {
    static final Logger LOGGER = LoggerFactory.getLogger(FileStore.class);
    private final Path dbFolder;

    public FileStore(Path dbFolder) throws IOException {
        this.dbFolder = dbFolder;
    }

    public Path root() {
        return this.dbFolder;
    }

    public Path keyPath(AcornKey key) {
        return ((AcornKeyFile)key).path();
    }

    @Override
    public void ensureExists() throws IOException {
        Files.createDirectories(this.dbFolder, new FileAttribute[0]);
    }

    public IO getIO(AcornKey key) {
        return new FileIO(this.keyPath(key));
    }

    public void dispose() {
    }

    @Override
    public AcornKey rootKey(String name) {
        return new AcornKeyFile(this, null, name);
    }

    @Override
    public Stream<AcornKey> directories() throws IOException {
        return Files.walk(this.dbFolder, 1, new FileVisitOption[0]).filter(path -> Files.isDirectory(path, new LinkOption[0])).map(f -> this.rootKey(f.getFileName().toString()));
    }

    @Override
    public void tryPurgeDirectory(AcornKey key, MainState mainState) {
        int ordinal;
        Path f = this.keyPath(key);
        LOGGER.info("purge deletes " + f);
        String currentDir = f.getFileName().toString();
        if (currentDir.endsWith("db")) {
            return;
        }
        if (currentDir.endsWith("_baseline")) {
            currentDir = currentDir.replace("_baseline", "");
        }
        if ((ordinal = Integer.parseInt(currentDir)) < mainState.headDir - 1) {
            LOGGER.info("purge deletes " + f);
            FileUtils.deleteDir((File)f.toFile());
        }
    }
}

