package org.simantics.acorn;

import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.Path;
import java.util.stream.Stream;

import org.simantics.db.IO;
import org.simantics.utils.FileUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FileStore implements Store {

	final static Logger LOGGER = LoggerFactory.getLogger(FileStore.class); 

	final private Path dbFolder;

	public FileStore(Path dbFolder) throws IOException {
		this.dbFolder = dbFolder;
	}

	public Path root() {
		return dbFolder;
	}
	
	public Path keyPath(AcornKey key) {
		return ((AcornKeyFile)key).path();
	}

	@Override
	public void ensureExists() throws IOException {
		Files.createDirectories(dbFolder);
	}
	
	public IO getIO(AcornKey key) {
		return new FileIO(keyPath(key));
	}

	@Override
	public void dispose() {
	}

	public AcornKey rootKey(String name) {
		return new AcornKeyFile(this, null, name);
	}

	@Override
	public Stream<AcornKey> directories() throws IOException {
		return Files.walk(dbFolder, 1).filter(Files::isDirectory).map(f -> rootKey(f.getFileName().toString()));
	}

	@Override
	public void tryPurgeDirectory(AcornKey key, MainState mainState) {

		Path f = keyPath(key);

		LOGGER.info("purge deletes " + f);

		String currentDir = f.getFileName().toString();
		if(currentDir.endsWith("db"))
			return;

		if(currentDir.endsWith("_baseline"))
			currentDir = currentDir.replace("_baseline", "");

		int ordinal = Integer.parseInt(currentDir);
		if(ordinal < mainState.headDir - 1) {
			LOGGER.info("purge deletes " + f);
			FileUtils.deleteDir(f.toFile());
		}

	}

}
