/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.r.scl.variable;

import gnu.trove.map.hash.THashMap;
import gnu.trove.procedure.TObjectProcedure;
import gnu.trove.set.hash.THashSet;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import java.util.concurrent.atomic.AtomicBoolean;
import org.rosuda.REngine.REXP;
import org.rosuda.REngine.REXPList;
import org.rosuda.REngine.REXPMismatchException;
import org.rosuda.REngine.REngineException;
import org.rosuda.REngine.RList;
import org.rosuda.REngine.Rserve.RserveException;
import org.simantics.databoard.Datatypes;
import org.simantics.databoard.binding.Binding;
import org.simantics.databoard.binding.error.BindingException;
import org.simantics.databoard.type.Datatype;
import org.simantics.r.scl.RSession;
import org.simantics.r.scl.variable.RAttributeNode;
import org.simantics.r.scl.variable.RDataboardConversion;
import org.simantics.r.scl.variable.RGlobalVariableNode;
import org.simantics.r.scl.variable.RListItemNode;
import org.simantics.r.scl.variable.RListLengthNode;
import org.simantics.r.scl.variable.RNamedItemNode;
import org.simantics.r.scl.variable.RVariableNode;
import org.simantics.simulator.variable.Realm;
import org.simantics.simulator.variable.exceptions.NodeManagerException;
import org.simantics.simulator.variable.exceptions.NotInRealmException;
import org.simantics.simulator.variable.impl.AbstractNodeManager;
import org.simantics.utils.datastructures.Pair;

public class RNodeManager
extends AbstractNodeManager<RVariableNode>
implements RVariableNode {
    public static final String LENGTH_PROPERTY_NAME = "length";
    public static final String ATTRIBUTE_NAME_PREFIX = "a-";
    public static final String INDEXED_ITEM_NAME_PREFIX = "i-";
    public static final String NAMED_ITEM_NAME_PREFIX = "n-";
    RSession realm;
    THashMap<RVariableNode, List<RVariableNode>> propertyCache = new THashMap();
    THashMap<Pair<RVariableNode, String>, RVariableNode> nodeCache = new THashMap();
    THashMap<RVariableNode, THashSet<Runnable>> listeners = new THashMap();
    List<RVariableNode> globals;
    AtomicBoolean fireNodeListenersScheduled = new AtomicBoolean(false);
    Runnable fireNodeListeners = new Runnable(){

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            RNodeManager.this.fireNodeListenersScheduled.set(false);
            TObjectProcedure<Runnable> procedure = new TObjectProcedure<Runnable>(){

                public boolean execute(Runnable object) {
                    object.run();
                    return true;
                }
            };
            THashMap<RVariableNode, THashSet<Runnable>> tHashMap = RNodeManager.this.listeners;
            synchronized (tHashMap) {
                RNodeManager.this.listeners.forEachValue((TObjectProcedure)new TObjectProcedure<THashSet<Runnable>>((TObjectProcedure)procedure){
                    private final /* synthetic */ TObjectProcedure val$procedure;
                    {
                        this.val$procedure = tObjectProcedure;
                    }

                    public boolean execute(THashSet<Runnable> object) {
                        object.forEach(this.val$procedure);
                        return true;
                    }
                });
            }
        }
    };
    Runnable clearValueCache = new Runnable(){

        @Override
        public void run() {
            RNodeManager.this.nodeCache.clear();
            RNodeManager.this.propertyCache.clear();
            RNodeManager.this.globals = null;
        }
    };
    static final Set<String> COMPONENT_CLASS = Collections.singleton("http://www.simantics.org/Structural-1.2/Component");

    public RNodeManager(RSession realm) {
        this.realm = realm;
    }

    public Realm getRealm() {
        return this.realm;
    }

    public String getName(RVariableNode node) {
        return node.getName();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addNodeListener(RVariableNode node, Runnable listener) {
        THashMap<RVariableNode, THashSet<Runnable>> tHashMap = this.listeners;
        synchronized (tHashMap) {
            THashSet l = (THashSet)this.listeners.get((Object)node);
            if (l == null) {
                l = new THashSet();
                this.listeners.put((Object)node, (Object)l);
            }
            l.add((Object)listener);
        }
        if (this.realm.getThread() == Thread.currentThread()) {
            listener.run();
        } else {
            this.realm.asyncExec(listener);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeNodeListener(RVariableNode node, Runnable listener) {
        THashMap<RVariableNode, THashSet<Runnable>> tHashMap = this.listeners;
        synchronized (tHashMap) {
            THashSet l = (THashSet)this.listeners.get((Object)node);
            if (l != null) {
                l.remove((Object)listener);
                if (l.isEmpty()) {
                    this.listeners.remove((Object)node);
                }
            }
        }
    }

    public void fireNodeListeners() {
        if (!this.fireNodeListenersScheduled.getAndSet(true)) {
            this.realm.asyncExec(this.fireNodeListeners);
        }
    }

    public void fireNodeListenersSync() {
        try {
            this.realm.syncExec(this.fireNodeListeners);
        }
        catch (InterruptedException e) {
            e.printStackTrace();
        }
    }

    public void refreshVariables() {
        this.realm.asyncExec(this.clearValueCache);
        this.fireNodeListeners();
    }

    public void refreshVariablesSync() {
        try {
            this.realm.syncExec(this.clearValueCache);
        }
        catch (InterruptedException e) {
            e.printStackTrace();
        }
        this.fireNodeListenersSync();
    }

    public RVariableNode getNode(String path) throws NodeManagerException {
        this.checkThreadAccess();
        throw new UnsupportedOperationException();
    }

    public RVariableNode getChild(RVariableNode node, String name) throws NodeManagerException {
        this.checkThreadAccess();
        return null;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public RVariableNode getProperty(RVariableNode node, String name) throws NodeManagerException {
        this.checkThreadAccess();
        RVariableNode prop = (RVariableNode)this.nodeCache.get((Object)new Pair((Object)node, (Object)name));
        if (prop != null) {
            return prop;
        }
        if (node == this) {
            prop = new RGlobalVariableNode(this, name);
        } else {
            if (node instanceof RListLengthNode) {
                return null;
            }
            if (name.equals(LENGTH_PROPERTY_NAME)) {
                prop = new RListLengthNode(node);
            } else if (name.startsWith(NAMED_ITEM_NAME_PREFIX)) {
                prop = new RNamedItemNode(node, name.substring(NAMED_ITEM_NAME_PREFIX.length()));
            } else if (name.startsWith(ATTRIBUTE_NAME_PREFIX)) {
                prop = new RAttributeNode(node, name.substring(ATTRIBUTE_NAME_PREFIX.length()));
            } else {
                if (!name.startsWith(INDEXED_ITEM_NAME_PREFIX)) return null;
                try {
                    int index = Integer.parseInt(name.substring(INDEXED_ITEM_NAME_PREFIX.length()));
                    if (index >= 0) {
                        prop = new RListItemNode(node, index);
                    }
                }
                catch (NumberFormatException e) {
                    return null;
                }
            }
        }
        this.nodeCache.put((Object)new Pair((Object)node, (Object)name), (Object)prop);
        return prop;
    }

    public List<RVariableNode> getChildren(RVariableNode node) throws NodeManagerException {
        this.checkThreadAccess();
        return Collections.emptyList();
    }

    public List<RVariableNode> getProperties(RVariableNode node) throws NodeManagerException {
        RList list;
        this.checkThreadAccess();
        if (node == this) {
            if (this.globals != null) {
                return this.globals;
            }
            try {
                REXP result = this.realm.getConnection().eval("ls()");
                if (result.isString()) {
                    String[] names = result.asStrings();
                    this.globals = new ArrayList<RVariableNode>(names.length);
                    String[] stringArray = names;
                    int n = names.length;
                    int n2 = 0;
                    while (n2 < n) {
                        String n3 = stringArray[n2];
                        RGlobalVariableNode child = new RGlobalVariableNode(this, n3);
                        this.globals.add(child);
                        this.nodeCache.put((Object)new Pair((Object)this, (Object)n3), (Object)child);
                        ++n2;
                    }
                    return this.globals;
                }
                throw new NodeManagerException("ls() returned invalid result!");
            }
            catch (RserveException e) {
                throw new NodeManagerException((Throwable)e);
            }
            catch (REXPMismatchException e) {
                throw new NodeManagerException((Throwable)e);
            }
        }
        if (node instanceof RListLengthNode) {
            return Collections.emptyList();
        }
        ArrayList<RVariableNode> props = (ArrayList<RVariableNode>)this.propertyCache.get((Object)node);
        if (props != null) {
            return props;
        }
        props = new ArrayList<RVariableNode>();
        REXP value = node.getValue();
        if (value == null) {
            return Collections.emptyList();
        }
        REXPList attrs = value._attr();
        if (attrs != null) {
            list = attrs.asList();
            int i = 0;
            while (i < list.size()) {
                props.add(new RAttributeNode(node, list.keyAt(i)));
                ++i;
            }
        }
        if (value.isList()) {
            try {
                list = value.asList();
                String[] keys = list.keys();
                int i = 0;
                while (i < list.size()) {
                    props.add(new RListItemNode(node, i));
                    if (keys != null && keys[i] != null) {
                        props.add(new RNamedItemNode(node, keys[i]));
                    }
                    ++i;
                }
            }
            catch (REXPMismatchException rEXPMismatchException) {
                // empty catch block
            }
        }
        try {
            int length = value.length();
            if (length >= 0) {
                props.add(new RListLengthNode(node));
            }
        }
        catch (REXPMismatchException length) {
            // empty catch block
        }
        this.propertyCache.put((Object)node, props);
        for (RVariableNode n : props) {
            this.nodeCache.put((Object)new Pair((Object)node, (Object)n.getName()), (Object)n);
        }
        return props;
    }

    public Datatype getDatatype(RVariableNode node) throws NodeManagerException {
        this.checkThreadAccess();
        if (node == this) {
            return null;
        }
        if (node instanceof RListLengthNode) {
            return Datatypes.INTEGER;
        }
        REXP value = node.getValue();
        try {
            return RDataboardConversion.getDatatype(value);
        }
        catch (BindingException e) {
            throw new NodeManagerException((Throwable)e);
        }
    }

    public Object getValue(RVariableNode node, Binding binding) throws NodeManagerException, BindingException {
        this.checkThreadAccess();
        if (node == this) {
            return null;
        }
        REXP value = node.getValue();
        if (binding == null || binding.isInstance((Object)value)) {
            return value;
        }
        return RDataboardConversion.fromREXP(value, binding);
    }

    public void setValue(RVariableNode node, Object value, Binding binding) throws NodeManagerException, BindingException {
        this.checkThreadAccess();
        if (node.getParent() != this) {
            throw new NodeManagerException("Assignment only allowed on top-level nodes");
        }
        String name = node.getName();
        REXP rexp = RDataboardConversion.toREXP(value, binding);
        try {
            this.realm.getConnection().assign(name, rexp);
            this.refreshVariables();
        }
        catch (RserveException e) {
            throw new NodeManagerException((Throwable)e);
        }
    }

    public Set<String> getClassifications(RVariableNode node) throws NodeManagerException {
        this.checkThreadAccess();
        if (node.equals(this)) {
            return COMPONENT_CLASS;
        }
        return Collections.emptySet();
    }

    private void checkThreadAccess() throws NodeManagerException {
        if (Thread.currentThread() != this.realm.getThread()) {
            throw new NotInRealmException();
        }
    }

    public String getPropertyURI(RVariableNode parent, RVariableNode property) {
        return "http://www.simantics.org/R-1.0/Session/hasValue";
    }

    @Override
    public String getName() {
        return this.realm.getId();
    }

    @Override
    public RVariableNode getParent() {
        return null;
    }

    @Override
    public REXP getValue() {
        return null;
    }

    public REXP getGlobalValue(String name) {
        try {
            return this.realm.getConnection().get(name, null, true);
        }
        catch (REngineException e) {
            return null;
        }
    }
}

