/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.r.scl;

import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Semaphore;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.TimeUnit;
import org.rosuda.REngine.Rserve.RConnection;
import org.rosuda.REngine.Rserve.RserveException;
import org.simantics.r.scl.RSessionManager;
import org.simantics.r.scl.variable.RNodeManager;
import org.simantics.scl.runtime.SCLContext;
import org.simantics.scl.runtime.function.Function;
import org.simantics.scl.runtime.tuple.Tuple0;
import org.simantics.simulator.variable.NodeManager;
import org.simantics.simulator.variable.Realm;

public class RSession
implements Realm {
    public static final String R = "r";
    RConnection connection;
    String id;
    Thread executorThread;
    ExecutorService executor = Executors.newSingleThreadExecutor(new ThreadFactory(){

        @Override
        public Thread newThread(Runnable r) {
            RSession.this.executorThread = new Thread(r);
            return RSession.this.executorThread;
        }
    });
    Semaphore beginSyncExec = new Semaphore(0);
    Semaphore endSyncExec = new Semaphore(0);
    RNodeManager nodeManager;
    Runnable scheduleSyncExec = new Runnable(){

        @Override
        public void run() {
            RSession.this.beginSyncExec.release();
            try {
                RSession.this.endSyncExec.acquire();
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        }
    };

    RSession(RConnection connection, String id) {
        this.connection = connection;
        this.id = id;
        this.nodeManager = new RNodeManager(this);
    }

    public String getId() {
        return this.id;
    }

    public RConnection getConnection() {
        return this.connection;
    }

    public Thread getThread() {
        return this.executorThread;
    }

    public Object syncExec(Function fun) throws RserveException, InterruptedException {
        this.executor.execute(this.scheduleSyncExec);
        SCLContext context = SCLContext.getCurrent();
        RConnection oldConnection = (RConnection)context.put((Object)R, (Object)this.connection);
        try {
            this.beginSyncExec.acquire();
            Thread oldThread = this.executorThread;
            this.executorThread = Thread.currentThread();
            try {
                Object object = fun.apply((Object)Tuple0.INSTANCE);
                this.executorThread = oldThread;
                this.endSyncExec.release();
                return object;
            }
            catch (Throwable throwable) {
                this.executorThread = oldThread;
                this.endSyncExec.release();
                throw throwable;
            }
        }
        finally {
            context.put((Object)R, (Object)oldConnection);
        }
    }

    public void asyncExec(final Function fun) {
        this.executor.execute(new Runnable(){

            @Override
            public void run() {
                SCLContext context = SCLContext.getCurrent();
                context.put((Object)RSession.R, (Object)RSession.this.connection);
                fun.apply((Object)Tuple0.INSTANCE);
            }
        });
    }

    public void syncExec(Runnable runnable) throws InterruptedException {
        this.executor.execute(this.scheduleSyncExec);
        this.beginSyncExec.acquire();
        Thread oldThread = this.executorThread;
        this.executorThread = Thread.currentThread();
        try {
            runnable.run();
        }
        finally {
            this.executorThread = oldThread;
            this.endSyncExec.release();
        }
    }

    public void asyncExec(Runnable runnable) {
        this.executor.execute(runnable);
    }

    public void refreshVariables() {
        this.nodeManager.refreshVariables();
    }

    public void refreshVariablesSync() {
        this.nodeManager.refreshVariablesSync();
    }

    public void close() {
        RSessionManager.CONNECTIONS.remove(this.id);
        this.executor.shutdown();
        try {
            this.executor.awaitTermination(500L, TimeUnit.MILLISECONDS);
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
        this.connection.close();
    }

    public NodeManager getNodeManager() {
        return this.nodeManager;
    }
}

