/*
 * Decompiled with CFR 0.152.
 */
package org.rosuda.REngine.Rserve.protocol;

import java.io.UnsupportedEncodingException;
import java.util.Vector;
import org.rosuda.REngine.REXP;
import org.rosuda.REngine.REXPDouble;
import org.rosuda.REngine.REXPExpressionVector;
import org.rosuda.REngine.REXPFactor;
import org.rosuda.REngine.REXPGenericVector;
import org.rosuda.REngine.REXPInteger;
import org.rosuda.REngine.REXPLanguage;
import org.rosuda.REngine.REXPList;
import org.rosuda.REngine.REXPLogical;
import org.rosuda.REngine.REXPMismatchException;
import org.rosuda.REngine.REXPNull;
import org.rosuda.REngine.REXPRaw;
import org.rosuda.REngine.REXPS4;
import org.rosuda.REngine.REXPString;
import org.rosuda.REngine.REXPSymbol;
import org.rosuda.REngine.REXPUnknown;
import org.rosuda.REngine.RList;
import org.rosuda.REngine.Rserve.RConnection;
import org.rosuda.REngine.Rserve.protocol.RTalk;

public class REXPFactory {
    public static final int XT_NULL = 0;
    public static final int XT_INT = 1;
    public static final int XT_DOUBLE = 2;
    public static final int XT_STR = 3;
    public static final int XT_LANG = 4;
    public static final int XT_SYM = 5;
    public static final int XT_BOOL = 6;
    public static final int XT_S4 = 7;
    public static final int XT_VECTOR = 16;
    public static final int XT_LIST = 17;
    public static final int XT_CLOS = 18;
    public static final int XT_SYMNAME = 19;
    public static final int XT_LIST_NOTAG = 20;
    public static final int XT_LIST_TAG = 21;
    public static final int XT_LANG_NOTAG = 22;
    public static final int XT_LANG_TAG = 23;
    public static final int XT_VECTOR_EXP = 26;
    public static final int XT_VECTOR_STR = 27;
    public static final int XT_ARRAY_INT = 32;
    public static final int XT_ARRAY_DOUBLE = 33;
    public static final int XT_ARRAY_STR = 34;
    public static final int XT_ARRAY_BOOL_UA = 35;
    public static final int XT_ARRAY_BOOL = 36;
    public static final int XT_RAW = 37;
    public static final int XT_ARRAY_CPLX = 38;
    public static final int XT_UNKNOWN = 48;
    public static final int XT_FACTOR = 127;
    private static final int XT_HAS_ATTR = 128;
    int type;
    REXPFactory attr;
    REXP cont;
    RList rootList;

    public REXP getREXP() {
        return this.cont;
    }

    public REXPList getAttr() {
        return this.attr == null ? null : (REXPList)this.attr.cont;
    }

    public REXPFactory() {
    }

    public REXPFactory(REXP r) throws REXPMismatchException {
        if (r == null) {
            r = new REXPNull();
        }
        REXPList a = r._attr();
        this.cont = r;
        if (a != null) {
            this.attr = new REXPFactory(a);
        }
        if (r instanceof REXPNull) {
            this.type = 0;
        } else if (r instanceof REXPList) {
            RList l = r.asList();
            int n = this.type = l.isNamed() ? 21 : 20;
            if (r instanceof REXPLanguage) {
                this.type = this.type == 21 ? 23 : 22;
            }
        } else if (r instanceof REXPGenericVector) {
            this.type = 16;
        } else if (r instanceof REXPS4) {
            this.type = 7;
        } else if (r instanceof REXPInteger) {
            this.type = 32;
        } else if (r instanceof REXPDouble) {
            this.type = 33;
        } else if (r instanceof REXPString) {
            this.type = 34;
        } else if (r instanceof REXPSymbol) {
            this.type = 19;
        } else if (r instanceof REXPRaw) {
            this.type = 37;
        } else if (r instanceof REXPLogical) {
            this.type = 36;
        } else {
            System.err.println("*** REXPFactory unable to interpret " + r);
        }
    }

    public int parseREXP(byte[] buf, int o) throws REXPMismatchException {
        int xl = RTalk.getLen(buf, o);
        boolean hasAtt = (buf[o] & 0x80) != 0;
        boolean isLong = (buf[o] & 0x40) != 0;
        int xt = buf[o] & 0x3F;
        if (isLong) {
            o += 4;
        }
        int eox = (o += 4) + xl;
        this.type = xt;
        this.attr = new REXPFactory();
        this.cont = null;
        if (hasAtt) {
            o = this.attr.parseREXP(buf, o);
        }
        if (xt == 0) {
            this.cont = new REXPNull(this.getAttr());
            return o;
        }
        if (xt == 2) {
            long lr = RTalk.getLong(buf, o);
            double[] d = new double[]{Double.longBitsToDouble(lr)};
            if ((o += 8) != eox) {
                System.err.println("Warning: double SEXP size mismatch\n");
                o = eox;
            }
            this.cont = new REXPDouble(d, this.getAttr());
            return o;
        }
        if (xt == 33) {
            int as = (eox - o) / 8;
            int i = 0;
            double[] d = new double[as];
            while (o < eox) {
                d[i] = Double.longBitsToDouble(RTalk.getLong(buf, o));
                o += 8;
                ++i;
            }
            if (o != eox) {
                System.err.println("Warning: double array SEXP size mismatch\n");
                o = eox;
            }
            this.cont = new REXPDouble(d, this.getAttr());
            return o;
        }
        if (xt == 6) {
            byte[] b = new byte[]{buf[o]};
            if (b[0] != 0 && b[0] != 1) {
                b[0] = -128;
            }
            this.cont = new REXPLogical(b, this.getAttr());
            if (++o != eox) {
                if (eox != o + 3) {
                    System.err.println("Warning: bool SEXP size mismatch\n");
                }
                o = eox;
            }
            return o;
        }
        if (xt == 35) {
            int as = eox - o;
            boolean i = false;
            byte[] d = new byte[as];
            System.arraycopy(buf, o, d, 0, eox - o);
            o = eox;
            int j = 0;
            while (j < d.length) {
                if (d[j] != 0 && d[j] != 1) {
                    d[j] = -128;
                }
                ++j;
            }
            this.cont = new REXPLogical(d, this.getAttr());
            return o;
        }
        if (xt == 36) {
            int as = RTalk.getInt(buf, o);
            byte[] d = new byte[as];
            System.arraycopy(buf, o += 4, d, 0, as);
            int j = 0;
            while (j < d.length) {
                if (d[j] != 0 && d[j] != 1) {
                    d[j] = -128;
                }
                ++j;
            }
            o = eox;
            this.cont = new REXPLogical(d, this.getAttr());
            return o;
        }
        if (xt == 1) {
            int[] i = new int[]{RTalk.getInt(buf, o)};
            this.cont = new REXPInteger(i, this.getAttr());
            if ((o += 4) != eox) {
                System.err.println("Warning: int SEXP size mismatch\n");
                o = eox;
            }
            return o;
        }
        if (xt == 32) {
            int as = (eox - o) / 4;
            int i = 0;
            int[] d = new int[as];
            while (o < eox) {
                d[i] = RTalk.getInt(buf, o);
                o += 4;
                ++i;
            }
            if (o != eox) {
                System.err.println("Warning: int array SEXP size mismatch\n");
                o = eox;
            }
            this.cont = null;
            try {
                if (this.getAttr() != null) {
                    REXP ca = this.getAttr().asList().at("class");
                    REXP ls = this.getAttr().asList().at("levels");
                    if (ca != null && ls != null && ca.asString().equals("factor")) {
                        this.cont = new REXPFactor(d, ls.asStrings(), this.getAttr());
                        xt = 127;
                    }
                }
            }
            catch (Exception ca) {
                // empty catch block
            }
            if (this.cont == null) {
                this.cont = new REXPInteger(d, this.getAttr());
            }
            return o;
        }
        if (xt == 37) {
            int as = RTalk.getInt(buf, o);
            byte[] d = new byte[as];
            System.arraycopy(buf, o += 4, d, 0, as);
            o = eox;
            this.cont = new REXPRaw(d, this.getAttr());
            return o;
        }
        if (xt == 20 || xt == 21 || xt == 22 || xt == 23) {
            REXPFactory lc = new REXPFactory();
            REXPFactory nf = new REXPFactory();
            RList l = new RList();
            while (o < eox) {
                String name = null;
                o = lc.parseREXP(buf, o);
                if (xt == 21 || xt == 23) {
                    o = nf.parseREXP(buf, o);
                    if (nf.cont.isSymbol() || nf.cont.isString()) {
                        name = nf.cont.asString();
                    }
                }
                if (name == null) {
                    l.add(lc.cont);
                    continue;
                }
                l.put(name, lc.cont);
            }
            REXP rEXP = this.cont = xt == 22 || xt == 23 ? new REXPLanguage(l, this.getAttr()) : new REXPList(l, this.getAttr());
            if (o != eox) {
                System.err.println("Warning: int list SEXP size mismatch\n");
                o = eox;
            }
            return o;
        }
        if (xt == 17 || xt == 4) {
            boolean isRoot = false;
            if (this.rootList == null) {
                this.rootList = new RList();
                isRoot = true;
            }
            REXPFactory headf = new REXPFactory();
            REXPFactory tagf = new REXPFactory();
            o = headf.parseREXP(buf, o);
            int elIndex = this.rootList.size();
            this.rootList.add(headf.cont);
            o = this.parseREXP(buf, o);
            if (o < eox) {
                o = tagf.parseREXP(buf, o);
                if (tagf.cont != null && (tagf.cont.isString() || tagf.cont.isSymbol())) {
                    this.rootList.setKeyAt(elIndex, tagf.cont.asString());
                }
            }
            if (isRoot) {
                this.cont = xt == 17 ? new REXPList(this.rootList, this.getAttr()) : new REXPLanguage(this.rootList, this.getAttr());
                this.rootList = null;
            }
            return o;
        }
        if (xt == 16 || xt == 26) {
            Vector<REXP> v = new Vector<REXP>();
            while (o < eox) {
                REXPFactory xx = new REXPFactory();
                o = xx.parseREXP(buf, o);
                v.addElement(xx.cont);
            }
            if (o != eox) {
                System.err.println("Warning: int vector SEXP size mismatch\n");
                o = eox;
            }
            if (this.getAttr() != null && this.getAttr().asList().at("names") != null) {
                RList l;
                REXP nam = this.getAttr().asList().at("names");
                String[] names = null;
                if (nam.isString()) {
                    names = nam.asStrings();
                } else if (nam.isVector()) {
                    l = nam.asList();
                    Object[] oa = l.toArray();
                    names = new String[oa.length];
                    int i = 0;
                    while (i < oa.length) {
                        names[i] = ((REXP)oa[i]).asString();
                        ++i;
                    }
                }
                l = new RList(v, names);
                this.cont = xt == 26 ? new REXPExpressionVector(l, this.getAttr()) : new REXPGenericVector(l, this.getAttr());
            } else {
                this.cont = xt == 26 ? new REXPExpressionVector(new RList(v), this.getAttr()) : new REXPGenericVector(new RList(v), this.getAttr());
            }
            return o;
        }
        if (xt == 34) {
            int c = 0;
            int i = o;
            while (i < eox) {
                if (buf[i++] != 0) continue;
                ++c;
            }
            String[] s = new String[c];
            if (c > 0) {
                c = 0;
                i = o;
                while (o < eox) {
                    if (buf[o] == 0) {
                        try {
                            s[c] = buf[i] == -1 ? (buf[i + 1] == 0 ? null : new String(buf, i + 1, o - i - 1, RConnection.transferCharset)) : new String(buf, i, o - i, RConnection.transferCharset);
                        }
                        catch (UnsupportedEncodingException ex) {
                            s[c] = "";
                        }
                        ++c;
                        i = o + 1;
                    }
                    ++o;
                }
            }
            this.cont = new REXPString(s, this.getAttr());
            return o;
        }
        if (xt == 27) {
            Vector<String> v = new Vector<String>();
            while (o < eox) {
                REXPFactory xx = new REXPFactory();
                o = xx.parseREXP(buf, o);
                v.addElement(xx.cont.asString());
            }
            if (o != eox) {
                System.err.println("Warning: int vector SEXP size mismatch\n");
                o = eox;
            }
            String[] sa = new String[v.size()];
            int i = 0;
            while (i < sa.length) {
                sa[i] = (String)v.get(i);
                ++i;
            }
            this.cont = new REXPString(sa, this.getAttr());
            return o;
        }
        if (xt == 3 || xt == 19) {
            int i = o;
            while (buf[i] != 0 && i < eox) {
                ++i;
            }
            try {
                this.cont = xt == 3 ? new REXPString(new String[]{new String(buf, o, i - o, RConnection.transferCharset)}, this.getAttr()) : new REXPSymbol(new String(buf, o, i - o, RConnection.transferCharset));
            }
            catch (Exception e) {
                System.err.println("unable to convert string\n");
                this.cont = null;
            }
            o = eox;
            return o;
        }
        if (xt == 5) {
            REXPFactory sym = new REXPFactory();
            o = sym.parseREXP(buf, o);
            this.cont = new REXPSymbol(sym.getREXP().asString());
            o = eox;
            return o;
        }
        if (xt == 18) {
            o = eox;
            return o;
        }
        if (xt == 48) {
            this.cont = new REXPUnknown(RTalk.getInt(buf, o), this.getAttr());
            o = eox;
            return o;
        }
        if (xt == 7) {
            this.cont = new REXPS4(this.getAttr());
            o = eox;
            return o;
        }
        this.cont = null;
        o = eox;
        System.err.println("unhandled type: " + xt);
        return o;
    }

    public int getBinaryLength() throws REXPMismatchException {
        int l = 0;
        int rxt = this.type;
        if (this.type == 17 || this.type == 21 || this.type == 20) {
            int n = rxt = this.cont.asList() != null && this.cont.asList().isNamed() ? 21 : 20;
        }
        if (this.type == 27) {
            rxt = 34;
        }
        boolean hasAttr = false;
        REXPList a = this.getAttr();
        RList al = null;
        if (a != null) {
            al = a.asList();
        }
        if (al != null && al.size() > 0) {
            hasAttr = true;
        }
        if (hasAttr) {
            l += this.attr.getBinaryLength();
        }
        switch (rxt) {
            case 0: 
            case 7: {
                break;
            }
            case 1: {
                l += 4;
                break;
            }
            case 2: {
                l += 8;
                break;
            }
            case 37: {
                if (((l += 4 + this.cont.asBytes().length) & 3) <= 0) break;
                l = l - (l & 3) + 4;
                break;
            }
            case 3: 
            case 19: {
                if (((l += this.cont == null ? 1 : this.cont.asString().length() + 1) & 3) <= 0) break;
                l = l - (l & 3) + 4;
                break;
            }
            case 32: {
                l += this.cont.asIntegers().length * 4;
                break;
            }
            case 33: {
                l += this.cont.asDoubles().length * 8;
                break;
            }
            case 38: {
                l += this.cont.asDoubles().length * 8;
                break;
            }
            case 36: {
                if (((l += this.cont.asBytes().length + 4) & 3) <= 0) break;
                l = l - (l & 3) + 4;
                break;
            }
            case 16: 
            case 17: 
            case 20: 
            case 21: 
            case 22: 
            case 23: {
                RList lst = this.cont.asList();
                int i = 0;
                while (i < lst.size()) {
                    REXP x = lst.at(i);
                    l += x == null ? 4 : new REXPFactory(x).getBinaryLength();
                    if (rxt == 21) {
                        int pl = l;
                        String s = lst.keyAt(i);
                        l += 4;
                        if (((l += s == null ? 1 : s.length() + 1) & 3) > 0) {
                            l = l - (l & 3) + 4;
                        }
                    }
                    ++i;
                }
                if ((l & 3) <= 0) break;
                l = l - (l & 3) + 4;
                break;
            }
            case 34: {
                String[] sa = this.cont.asStrings();
                int i = 0;
                while (i < sa.length) {
                    if (sa[i] != null) {
                        try {
                            byte[] b = sa[i].getBytes(RConnection.transferCharset);
                            if (b.length > 0) {
                                if (b[0] == -1) {
                                    ++l;
                                }
                                l += b.length;
                            }
                            b = null;
                        }
                        catch (UnsupportedEncodingException unsupportedEncodingException) {}
                    } else {
                        ++l;
                    }
                    ++l;
                    ++i;
                }
                if ((l & 3) <= 0) break;
                l = l - (l & 3) + 4;
            }
        }
        if (l > 0xFFFFF0) {
            l += 4;
        }
        return l + 4;
    }

    public int getBinaryRepresentation(byte[] buf, int off) throws REXPMismatchException {
        int myl = this.getBinaryLength();
        boolean isLarge = myl > 0xFFFFF0;
        boolean hasAttr = false;
        REXPList a = this.getAttr();
        RList al = null;
        if (a != null) {
            al = a.asList();
        }
        if (al != null && al.size() > 0) {
            hasAttr = true;
        }
        int rxt = this.type;
        int ooff = off;
        if (this.type == 27) {
            rxt = 34;
        }
        if (this.type == 17 || this.type == 21 || this.type == 20) {
            rxt = this.cont.asList() != null && this.cont.asList().isNamed() ? 21 : 20;
        }
        RTalk.setHdr(rxt | (hasAttr ? 128 : 0), myl - (isLarge ? 8 : 4), buf, off);
        off += isLarge ? 8 : 4;
        if (hasAttr) {
            off = this.attr.getBinaryRepresentation(buf, off);
        }
        switch (rxt) {
            case 0: 
            case 7: {
                break;
            }
            case 1: {
                RTalk.setInt(this.cont.asInteger(), buf, off);
                break;
            }
            case 2: {
                RTalk.setLong(Double.doubleToRawLongBits(this.cont.asDouble()), buf, off);
                break;
            }
            case 32: {
                int[] ia = this.cont.asIntegers();
                int i = 0;
                int io = off;
                while (i < ia.length) {
                    RTalk.setInt(ia[i++], buf, io);
                    io += 4;
                }
                break;
            }
            case 36: {
                byte[] ba = this.cont.asBytes();
                int io = off;
                RTalk.setInt(ba.length, buf, io);
                io += 4;
                if (ba.length <= 0) break;
                int i = 0;
                while (i < ba.length) {
                    buf[io++] = (byte)(ba[i] == -128 ? 2 : (ba[i] == 0 ? 0 : 1));
                    ++i;
                }
                while ((io & 3) != 0) {
                    buf[io++] = 3;
                }
                break;
            }
            case 33: {
                double[] da = this.cont.asDoubles();
                int i = 0;
                int io = off;
                while (i < da.length) {
                    RTalk.setLong(Double.doubleToRawLongBits(da[i++]), buf, io);
                    io += 8;
                }
                break;
            }
            case 37: {
                byte[] by = this.cont.asBytes();
                RTalk.setInt(by.length, buf, off);
                System.arraycopy(by, 0, buf, off += 4, by.length);
                break;
            }
            case 34: {
                String[] sa = this.cont.asStrings();
                int i = 0;
                int io = off;
                while (i < sa.length) {
                    if (sa[i] != null) {
                        try {
                            byte[] b = sa[i].getBytes(RConnection.transferCharset);
                            if (b.length > 0) {
                                if (b[0] == -1) {
                                    buf[io++] = -1;
                                }
                                System.arraycopy(b, 0, buf, io, b.length);
                                io += b.length;
                            }
                            b = null;
                        }
                        catch (UnsupportedEncodingException b) {}
                    } else {
                        buf[io++] = -1;
                    }
                    buf[io++] = 0;
                    ++i;
                }
                i = io - off;
                while ((i & 3) != 0) {
                    buf[io++] = 1;
                    ++i;
                }
                break;
            }
            case 16: 
            case 17: 
            case 20: 
            case 21: 
            case 22: 
            case 23: 
            case 26: {
                int io = off;
                RList lst = this.cont.asList();
                if (lst == null) break;
                int i = 0;
                while (i < lst.size()) {
                    REXP x = lst.at(i);
                    if (x == null) {
                        x = new REXPNull();
                    }
                    io = new REXPFactory(x).getBinaryRepresentation(buf, io);
                    if (rxt == 21 || rxt == 23) {
                        io = new REXPFactory(new REXPSymbol(lst.keyAt(i))).getBinaryRepresentation(buf, io);
                    }
                    ++i;
                }
                break;
            }
            case 3: 
            case 19: {
                REXPFactory.getStringBinaryRepresentation(buf, off, this.cont.asString());
            }
        }
        return ooff + myl;
    }

    public static int getStringBinaryRepresentation(byte[] buf, int off, String s) {
        if (s == null) {
            s = "";
        }
        int io = off;
        try {
            byte[] b = s.getBytes(RConnection.transferCharset);
            System.arraycopy(b, 0, buf, io, b.length);
            io += b.length;
            b = null;
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            // empty catch block
        }
        buf[io++] = 0;
        while ((io & 3) != 0) {
            buf[io++] = 0;
        }
        return io;
    }

    public static String xtName(int xt) {
        if (xt == 0) {
            return "NULL";
        }
        if (xt == 1) {
            return "INT";
        }
        if (xt == 3) {
            return "STRING";
        }
        if (xt == 2) {
            return "REAL";
        }
        if (xt == 6) {
            return "BOOL";
        }
        if (xt == 32) {
            return "INT*";
        }
        if (xt == 34) {
            return "STRING*";
        }
        if (xt == 33) {
            return "REAL*";
        }
        if (xt == 36) {
            return "BOOL*";
        }
        if (xt == 38) {
            return "COMPLEX*";
        }
        if (xt == 5) {
            return "SYMBOL";
        }
        if (xt == 19) {
            return "SYMNAME";
        }
        if (xt == 4) {
            return "LANG";
        }
        if (xt == 17) {
            return "LIST";
        }
        if (xt == 21) {
            return "LIST+T";
        }
        if (xt == 20) {
            return "LIST/T";
        }
        if (xt == 23) {
            return "LANG+T";
        }
        if (xt == 22) {
            return "LANG/T";
        }
        if (xt == 18) {
            return "CLOS";
        }
        if (xt == 37) {
            return "RAW";
        }
        if (xt == 7) {
            return "S4";
        }
        if (xt == 16) {
            return "VECTOR";
        }
        if (xt == 27) {
            return "STRING[]";
        }
        if (xt == 26) {
            return "EXPR[]";
        }
        if (xt == 127) {
            return "FACTOR";
        }
        if (xt == 48) {
            return "UNKNOWN";
        }
        return "<unknown " + xt + ">";
    }
}

