/*
 * Decompiled with CFR 0.152.
 */
package org.rosuda.REngine;

import org.rosuda.REngine.REXPList;
import org.rosuda.REngine.REXPVector;

public class REXPDouble
extends REXPVector {
    public double[] payload;
    public static final double NA = Double.longBitsToDouble(9218868437227407266L);
    static final long NA_bits = Double.doubleToRawLongBits(Double.longBitsToDouble(9218868437227407266L));

    public static boolean isNA(double value) {
        return (Double.doubleToRawLongBits(value) & 0xFFF7FFFFFFFFFFFFL) == (NA_bits & 0xFFF7FFFFFFFFFFFFL);
    }

    public REXPDouble(double load) {
        this.payload = new double[]{load};
    }

    public REXPDouble(double[] load) {
        this.payload = load == null ? new double[]{} : load;
    }

    public REXPDouble(double[] load, REXPList attr) {
        super(attr);
        this.payload = load == null ? new double[]{} : load;
    }

    @Override
    public int length() {
        return this.payload.length;
    }

    @Override
    public Object asNativeJavaObject() {
        return this.payload;
    }

    @Override
    public boolean isNumeric() {
        return true;
    }

    @Override
    public double[] asDoubles() {
        return this.payload;
    }

    @Override
    public int[] asIntegers() {
        int[] a = new int[this.payload.length];
        int i = 0;
        while (i < this.payload.length) {
            a[i] = (int)this.payload[i];
            ++i;
        }
        return a;
    }

    @Override
    public String[] asStrings() {
        String[] s = new String[this.payload.length];
        int i = 0;
        while (i < this.payload.length) {
            s[i] = "" + this.payload[i];
            ++i;
        }
        return s;
    }

    @Override
    public boolean[] isNA() {
        boolean[] a = new boolean[this.payload.length];
        int i = 0;
        while (i < a.length) {
            a[i] = REXPDouble.isNA(this.payload[i]);
            ++i;
        }
        return a;
    }

    @Override
    public String toDebugString() {
        StringBuffer sb = new StringBuffer(String.valueOf(super.toDebugString()) + "{");
        int i = 0;
        while (i < this.payload.length && i < maxDebugItems) {
            if (i > 0) {
                sb.append(",");
            }
            sb.append(this.payload[i]);
            ++i;
        }
        if (i < this.payload.length) {
            sb.append(",..");
        }
        return String.valueOf(sb.toString()) + "}";
    }
}

