/*
 * Decompiled with CFR 0.152.
 */
package org.rosuda.REngine;

import org.rosuda.REngine.REXPDouble;
import org.rosuda.REngine.REXPGenericVector;
import org.rosuda.REngine.REXPInteger;
import org.rosuda.REngine.REXPList;
import org.rosuda.REngine.REXPMismatchException;
import org.rosuda.REngine.REXPString;
import org.rosuda.REngine.REXPVector;
import org.rosuda.REngine.RFactor;
import org.rosuda.REngine.RList;

public class REXP {
    public REXPList attr;
    public static int maxDebugItems = 32;

    public REXP() {
    }

    public REXP(REXPList attr) {
        this.attr = attr;
    }

    public boolean isString() {
        return false;
    }

    public boolean isNumeric() {
        return false;
    }

    public boolean isInteger() {
        return false;
    }

    public boolean isNull() {
        return false;
    }

    public boolean isFactor() {
        return false;
    }

    public boolean isList() {
        return false;
    }

    public boolean isPairList() {
        return false;
    }

    public boolean isLogical() {
        return false;
    }

    public boolean isEnvironment() {
        return false;
    }

    public boolean isLanguage() {
        return false;
    }

    public boolean isExpression() {
        return false;
    }

    public boolean isSymbol() {
        return false;
    }

    public boolean isVector() {
        return false;
    }

    public boolean isRaw() {
        return false;
    }

    public boolean isComplex() {
        return false;
    }

    public boolean isRecursive() {
        return false;
    }

    public boolean isReference() {
        return false;
    }

    public String[] asStrings() throws REXPMismatchException {
        throw new REXPMismatchException(this, "String");
    }

    public int[] asIntegers() throws REXPMismatchException {
        throw new REXPMismatchException(this, "int");
    }

    public double[] asDoubles() throws REXPMismatchException {
        throw new REXPMismatchException(this, "double");
    }

    public byte[] asBytes() throws REXPMismatchException {
        throw new REXPMismatchException(this, "byte");
    }

    public RList asList() throws REXPMismatchException {
        throw new REXPMismatchException(this, "list");
    }

    public RFactor asFactor() throws REXPMismatchException {
        throw new REXPMismatchException(this, "factor");
    }

    public Object asNativeJavaObject() throws REXPMismatchException {
        throw new REXPMismatchException(this, "native Java Object");
    }

    public int length() throws REXPMismatchException {
        throw new REXPMismatchException(this, "vector");
    }

    public boolean[] isNA() throws REXPMismatchException {
        throw new REXPMismatchException(this, "vector");
    }

    public int asInteger() throws REXPMismatchException {
        int[] i = this.asIntegers();
        return i[0];
    }

    public double asDouble() throws REXPMismatchException {
        double[] d = this.asDoubles();
        return d[0];
    }

    public String asString() throws REXPMismatchException {
        String[] s = this.asStrings();
        return s[0];
    }

    public REXP getAttribute(String name) {
        REXPList a = this._attr();
        if (a == null || !a.isList()) {
            return null;
        }
        return a.asList().at(name);
    }

    public boolean hasAttribute(String name) {
        REXPList a = this._attr();
        return a != null && a.isList() && a.asList().at(name) != null;
    }

    public int[] dim() {
        try {
            return this.hasAttribute("dim") ? this._attr().asList().at("dim").asIntegers() : null;
        }
        catch (REXPMismatchException rEXPMismatchException) {
            return null;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public boolean inherits(String klass) {
        if (!this.hasAttribute("class")) {
            return false;
        }
        try {
            String[] c = this.getAttribute("class").asStrings();
            if (c == null) return false;
            int i = 0;
            while (true) {
                if (i >= c.length) {
                    return false;
                }
                if (c[i] != null && c[i].equals(klass)) {
                    return true;
                }
                ++i;
            }
        }
        catch (REXPMismatchException rEXPMismatchException) {
            // empty catch block
        }
        return false;
    }

    public REXPList _attr() {
        return this.attr;
    }

    public String toString() {
        return String.valueOf(super.toString()) + (this.attr != null ? "+" : "");
    }

    public String toDebugString() {
        return this.attr != null ? "<" + this.attr.toDebugString() + ">" + super.toString() : super.toString();
    }

    public double[][] asDoubleMatrix() throws REXPMismatchException {
        double[] ct = this.asDoubles();
        REXP dim = this.getAttribute("dim");
        if (dim == null) {
            throw new REXPMismatchException(this, "matrix (dim attribute missing)");
        }
        int[] ds = dim.asIntegers();
        if (ds.length != 2) {
            throw new REXPMismatchException(this, "matrix (wrong dimensionality)");
        }
        int m = ds[0];
        int n = ds[1];
        double[][] r = new double[m][n];
        int k = 0;
        int i = 0;
        while (i < n) {
            int j = 0;
            while (j < m) {
                r[j][i] = ct[k++];
                ++j;
            }
            ++i;
        }
        return r;
    }

    public static REXP createDoubleMatrix(double[][] matrix) {
        double[] a;
        int m = 0;
        int n = 0;
        if (matrix != null && matrix.length != 0 && matrix[0].length != 0) {
            m = matrix.length;
            n = matrix[0].length;
            a = new double[m * n];
            int k = 0;
            int j = 0;
            while (j < n) {
                int i = 0;
                while (i < m) {
                    a[k++] = matrix[i][j];
                    ++i;
                }
                ++j;
            }
        } else {
            a = new double[]{};
        }
        return new REXPDouble(a, new REXPList(new RList(new REXP[]{new REXPInteger(new int[]{m, n})}, new String[]{"dim"})));
    }

    public static REXP createDataFrame(RList l) throws REXPMismatchException {
        if (l == null || l.size() < 1) {
            throw new REXPMismatchException(new REXPList(l), "data frame (must have dim>0)");
        }
        if (!(l.at(0) instanceof REXPVector)) {
            throw new REXPMismatchException(new REXPList(l), "data frame (contents must be vectors)");
        }
        REXPVector fe = (REXPVector)l.at(0);
        return new REXPGenericVector(l, new REXPList(new RList(new REXP[]{new REXPString("data.frame"), new REXPString(l.keys()), new REXPInteger(new int[]{Integer.MIN_VALUE, -fe.length()})}, new String[]{"class", "names", "row.names"})));
    }
}

