/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.matlablink;

import java.io.Closeable;
import java.io.IOException;
import org.simantics.matlablink.CellArray;
import org.simantics.matlablink.CharacterArray;
import org.simantics.matlablink.DoubleArray;
import org.simantics.matlablink.MatlabArray;
import org.simantics.matlablink.StructArray;

public class Engine
implements Closeable {
    private long engineId;

    static {
        try {
            System.loadLibrary("jnimatlab");
        }
        catch (UnsatisfiedLinkError e) {
            System.out.println("Error loading jnimatlab.dll: " + e.getMessage());
        }
    }

    Engine(String workingDirectory) {
        this.engineId = Engine.openMatlabEngineImpl(workingDirectory);
    }

    public boolean isOpen() {
        return this.engineId != 0L;
    }

    @Override
    public void close() throws IOException {
        long id = this.engineId;
        this.engineId = 0L;
        Engine.closeMatlabEngineImpl(id);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public MatlabArray getMatlabArray(String variableName) {
        MatlabArray result;
        if (variableName == null || variableName.isEmpty()) {
            throw new IllegalArgumentException("Invalid Matlab variable name '" + variableName + "'");
        }
        Engine engine = this;
        synchronized (engine) {
            result = Engine.getMatlabArrayImpl(this.engineId, variableName);
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setMatlabArray(String variableName, MatlabArray value) {
        int result;
        if (value == null) {
            throw new IllegalArgumentException("Invalid Matlab array value given");
        }
        Engine engine = this;
        synchronized (engine) {
            result = Engine.setMatlabArrayImpl(this.engineId, variableName, value);
        }
        if (result != 0) {
            throw new RuntimeException("Setting Matlab variable value failed");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public DoubleArray getMatlabDoubleArray(String variableName) {
        DoubleArray result;
        if (variableName == null || variableName.isEmpty()) {
            throw new IllegalArgumentException("Invalid Matlab variable name '" + variableName + "'");
        }
        Engine engine = this;
        synchronized (engine) {
            result = Engine.getMatlabDoubleArrayImpl(this.engineId, variableName);
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setMatlabDoubleArray(String variableName, DoubleArray value) {
        int result;
        if (value == null) {
            throw new IllegalArgumentException("Invalid Matlab array value given");
        }
        Engine engine = this;
        synchronized (engine) {
            result = Engine.setMatlabDoubleArrayImpl(this.engineId, variableName, value);
        }
        if (result != 0) {
            throw new RuntimeException("Setting Matlab variable value failed");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public CellArray getMatlabCellArray(String variableName) {
        CellArray result;
        if (variableName == null || variableName.isEmpty()) {
            throw new IllegalArgumentException("Invalid Matlab variable name '" + variableName + "'");
        }
        Engine engine = this;
        synchronized (engine) {
            result = Engine.getMatlabCellArrayImpl(this.engineId, variableName);
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setMatlabCellArray(String variableName, CellArray value) {
        int result;
        if (value == null) {
            throw new IllegalArgumentException("Invalid Matlab array value given");
        }
        Engine engine = this;
        synchronized (engine) {
            result = Engine.setMatlabCellArrayImpl(this.engineId, variableName, value);
        }
        if (result != 0) {
            throw new RuntimeException("Setting Matlab variable value failed");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public CharacterArray getMatlabCharacterArray(String variableName) {
        CharacterArray result;
        if (variableName == null || variableName.isEmpty()) {
            throw new IllegalArgumentException("Invalid Matlab variable name '" + variableName + "'");
        }
        Engine engine = this;
        synchronized (engine) {
            result = Engine.getMatlabCharacterArrayImpl(this.engineId, variableName);
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setMatlabCharacterArray(String variableName, CharacterArray value) {
        int result;
        if (value == null) {
            throw new IllegalArgumentException("Invalid Matlab array value given");
        }
        Engine engine = this;
        synchronized (engine) {
            result = Engine.setMatlabCharacterArrayImpl(this.engineId, variableName, value);
        }
        if (result != 0) {
            throw new RuntimeException("Setting Matlab variable value failed");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public StructArray getMatlabStructArray(String variableName) {
        StructArray result;
        if (variableName == null || variableName.isEmpty()) {
            throw new IllegalArgumentException("Invalid Matlab variable name '" + variableName + "'");
        }
        Engine engine = this;
        synchronized (engine) {
            result = Engine.getMatlabStructArrayImpl(this.engineId, variableName);
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setMatlabStructArray(String variableName, StructArray value) {
        int result;
        if (value == null) {
            throw new IllegalArgumentException("Invalid Matlab array value given");
        }
        Engine engine = this;
        synchronized (engine) {
            result = Engine.setMatlabStructArrayImpl(this.engineId, variableName, value);
        }
        if (result != 0) {
            throw new RuntimeException("Setting Matlab variable value failed");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void evaluateMatlabExpression(String expression) {
        int result;
        Engine engine = this;
        synchronized (engine) {
            result = Engine.evaluateMatlabExpressionImpl(this.engineId, expression);
        }
        if (result != 0) {
            throw new RuntimeException("Evaluation of Matlab expression failed");
        }
    }

    private static native long openMatlabEngineImpl(String var0);

    private static native void closeMatlabEngineImpl(long var0);

    private static native int evaluateMatlabExpressionImpl(long var0, String var2);

    private static native MatlabArray getMatlabArrayImpl(long var0, String var2);

    private static native int setMatlabArrayImpl(long var0, String var2, MatlabArray var3);

    private static native DoubleArray getMatlabDoubleArrayImpl(long var0, String var2);

    private static native int setMatlabDoubleArrayImpl(long var0, String var2, DoubleArray var3);

    private static native CellArray getMatlabCellArrayImpl(long var0, String var2);

    private static native int setMatlabCellArrayImpl(long var0, String var2, CellArray var3);

    private static native CharacterArray getMatlabCharacterArrayImpl(long var0, String var2);

    private static native int setMatlabCharacterArrayImpl(long var0, String var2, CharacterArray var3);

    private static native StructArray getMatlabStructArrayImpl(long var0, String var2);

    private static native int setMatlabStructArrayImpl(long var0, String var2, StructArray var3);
}

