/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.xml.sax.base;

import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamWriter;
import org.simantics.db.ReadGraph;
import org.simantics.db.Resource;
import org.simantics.db.exception.DatabaseException;
import org.simantics.xml.sax.base.WriterElement;
import org.simantics.xml.sax.base.XMLElementNamedChildWriter;
import org.simantics.xml.sax.base.XMLElementWriter;
import org.simantics.xml.sax.ontology.XMLResource;

public abstract class XMLElementNamedChildWriterBase
implements XMLElementNamedChildWriter {
    private Map<Resource, Class<? extends XMLElementWriter>> typeWriters = new HashMap<Resource, Class<? extends XMLElementWriter>>();
    private Map<Resource, Class<? extends XMLElementWriter>> relationWriters = new HashMap<Resource, Class<? extends XMLElementWriter>>();
    private Map<Resource, Map<Resource, Class<? extends XMLElementWriter>>> relationTypeWriters = new HashMap<Resource, Map<Resource, Class<? extends XMLElementWriter>>>();
    private Set<Class<? extends XMLElementWriter>> writers = new HashSet<Class<? extends XMLElementWriter>>();

    public XMLElementNamedChildWriterBase() {
    }

    public XMLElementNamedChildWriterBase(ReadGraph graph) {
    }

    @Override
    public Resource getType(ReadGraph graph) throws DatabaseException {
        return null;
    }

    @Override
    public void start(ReadGraph graph, WriterElement instance, XMLStreamWriter writer) throws XMLStreamException {
        writer.writeStartElement(this.getElementId());
    }

    @Override
    public void characters(ReadGraph graph, WriterElement instance, XMLStreamWriter writer) throws XMLStreamException, DatabaseException {
    }

    @Override
    public void end(ReadGraph graph, WriterElement instance, XMLStreamWriter writer) throws XMLStreamException {
        writer.writeEndElement();
    }

    @Override
    public void children(ReadGraph graph, WriterElement instance, Set<Resource> sorted) throws XMLStreamException, DatabaseException {
    }

    @Override
    public Class<? extends XMLElementWriter> getWriter(ReadGraph graph, Map<Resource, XMLElementWriter> writers, WriterElement child) throws DatabaseException {
        XMLElementWriter writer;
        XMLResource XML = XMLResource.getInstance((ReadGraph)graph);
        Resource type = graph.getSingleType(child.instance, XML.Element);
        Class<XMLElementWriter> writerClass = this.typeWriters.get(type);
        if (writerClass != null) {
            return writerClass;
        }
        if (child.statement != null) {
            Map<Resource, Class<? extends XMLElementWriter>> typeWriters = this.relationTypeWriters.get(child.statement.getPredicate());
            if (typeWriters != null && (writerClass = typeWriters.get(type)) != null) {
                return writerClass;
            }
            writerClass = this.relationWriters.get(child.statement.getPredicate());
            if (writerClass != null) {
                return writerClass;
            }
        }
        if ((writer = writers.get(type)) == null) {
            return null;
        }
        writerClass = writer.getClass();
        if (this.writers.contains(writerClass)) {
            return writerClass;
        }
        for (Class<? extends XMLElementWriter> c : this.writers) {
            if (!c.isAssignableFrom(writerClass)) continue;
            return writerClass;
        }
        return null;
    }

    public void addTypeWriter(Resource type, Class<? extends XMLElementWriter> writer) {
        this.typeWriters.put(type, writer);
    }

    public void addRelationWriter(Resource relation, Class<? extends XMLElementWriter> writer) {
        this.relationWriters.put(relation, writer);
    }

    public void addRelationTypeWriter(Resource relation, Resource type, Class<? extends XMLElementWriter> writer) {
        Map<Resource, Class<? extends XMLElementWriter>> typeWriters = this.relationTypeWriters.get(relation);
        if (typeWriters == null) {
            typeWriters = new HashMap<Resource, Class<? extends XMLElementWriter>>();
            this.relationTypeWriters.put(relation, typeWriters);
        }
        typeWriters.put(type, writer);
    }

    public void addWriter(Class<? extends XMLElementWriter> writer) {
        this.writers.add(writer);
    }
}

