/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.xml.sax.base;

import java.io.File;
import org.simantics.db.Resource;
import org.simantics.db.Session;
import org.simantics.db.WriteGraph;
import org.simantics.db.WriteOnlyGraph;
import org.simantics.db.common.request.DelayedWriteRequest;
import org.simantics.db.common.request.WriteRequest;
import org.simantics.db.exception.DatabaseException;
import org.simantics.db.layer0.util.Layer0Utils;
import org.simantics.db.request.DelayedWrite;
import org.simantics.db.service.XSupport;
import org.simantics.message.ILogger;
import org.simantics.message.MessageService;
import org.simantics.xml.sax.base.XMLElementParser;
import org.simantics.xml.sax.base.XMLParser;

public abstract class AbstractImporter {
    private Session session;
    private File file;
    private ILogger logger;
    private XMLParser parser;
    private static final boolean USE_DELAYED = true;

    public AbstractImporter(Session session, File file) {
        this.session = session;
        this.file = file;
    }

    public AbstractImporter(Session session, File file, XMLParser parser) {
        this.session = session;
        this.file = file;
        this.parser = parser;
    }

    public Resource doImport() throws DatabaseException {
        return this.doImport(MessageService.getDefault());
    }

    public Resource doImport(ILogger logger) throws DatabaseException {
        this.logger = logger;
        ImportDelayedRequest req = new ImportDelayedRequest();
        this.session.syncRequest((DelayedWrite)req);
        Resource dr = req.getResult();
        XSupport xs = (XSupport)this.session.getService(XSupport.class);
        Resource result = xs.convertDelayedResourceToResource(dr);
        return result;
    }

    public File getFile() {
        return this.file;
    }

    public void configure(XMLParser parser) {
    }

    private Resource doImport(WriteGraph graph) throws DatabaseException {
        Layer0Utils.setDependenciesIndexingDisabled((WriteOnlyGraph)graph, (boolean)true);
        try {
            if (this.parser == null) {
                this.parser = new XMLParser();
                this.parser.setGraph(graph);
                this.configure(this.parser);
            } else {
                this.parser.setGraph(graph);
            }
            this.parser.parse(this.file, this.logger);
            System.out.println(String.valueOf(this.file.getAbsolutePath()) + " imported");
            Resource root = this.parser.getRoot();
            if (root == null) {
                throw new DatabaseException(String.valueOf(this.file.getAbsolutePath()) + " import failed. File is corrupted, or is not given type");
            }
            return root;
        }
        catch (DatabaseException e) {
            throw e;
        }
        catch (Exception e) {
            throw new DatabaseException((Throwable)e);
        }
    }

    public XMLElementParser getParser(String elementId) {
        return this.parser.getParser(elementId);
    }

    public void setParser(String elementId, XMLElementParser p) {
        this.parser.setParser(elementId, p);
    }

    public XMLParser getParser() {
        return this.parser;
    }

    private class ImportDelayedRequest
    extends DelayedWriteRequest {
        private Resource result;

        public void perform(WriteGraph graph) throws DatabaseException {
            this.result = AbstractImporter.this.doImport(graph);
        }

        public Resource getResult() {
            return this.result;
        }
    }

    private class ImportRequest
    extends WriteRequest {
        private Resource result;

        public void perform(WriteGraph graph) throws DatabaseException {
            Layer0Utils.addCommentMetadata((WriteOnlyGraph)graph, (String)("Import file " + AbstractImporter.this.file.getName()));
            graph.markUndoPoint();
            this.result = AbstractImporter.this.doImport(graph);
        }

        public Resource getResult() {
            return this.result;
        }
    }
}

