/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.interop.update.text;

import java.io.InputStream;
import java.io.Reader;
import java.lang.reflect.InvocationTargetException;
import java.net.URI;
import java.util.Map;
import org.eclipse.compare.CompareConfiguration;
import org.eclipse.compare.CompareEditorInput;
import org.eclipse.compare.ITypedElement;
import org.eclipse.compare.internal.BufferedResourceNode;
import org.eclipse.compare.structuremergeviewer.DiffNode;
import org.eclipse.compare.structuremergeviewer.Differencer;
import org.eclipse.compare.structuremergeviewer.IDiffContainer;
import org.eclipse.compare.structuremergeviewer.IDiffElement;
import org.eclipse.compare.structuremergeviewer.IStructureComparator;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IFileState;
import org.eclipse.core.resources.IMarker;
import org.eclipse.core.resources.IPathVariableManager;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IProjectDescription;
import org.eclipse.core.resources.IResourceProxy;
import org.eclipse.core.resources.IResourceProxyVisitor;
import org.eclipse.core.resources.IResourceVisitor;
import org.eclipse.core.resources.IWorkspace;
import org.eclipse.core.resources.ResourceAttributes;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.QualifiedName;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.content.IContentDescription;
import org.eclipse.core.runtime.jobs.ISchedulingRule;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.simantics.interop.update.text.ObjectValueComparator;
import org.simantics.interop.update.text.PropertyChangeContainer;

public class ValueCompareInput
extends CompareEditorInput {
    PropertyChangeContainer pc;
    boolean fThreeWay = false;
    private Object fRoot;
    private IStructureComparator fAncestor;
    private IStructureComparator fLeft;
    private IStructureComparator fRight;

    public ValueCompareInput(CompareConfiguration config) {
        super(config);
    }

    public Object getLeftResource() {
        if (this.fThreeWay) {
            return this.pc.getValues().third;
        }
        return this.pc.getValues().first;
    }

    public Object getRightResource() {
        return this.pc.getValues().second;
    }

    public IStructureComparator getLeft() {
        return this.fLeft;
    }

    public IStructureComparator getRight() {
        return this.fRight;
    }

    protected void storeValue(Object newValue) {
        this.pc.getChange().setCustomValue(newValue);
        this.pc.getChange().select(true);
    }

    public boolean setInput(PropertyChangeContainer pc) {
        this.pc = pc;
        boolean bl = this.fThreeWay = pc.getValues().third != null;
        if (this.fThreeWay) {
            this.fAncestor = this.getStructure(pc.getValues().first);
            this.fLeft = this.getStructure(pc.getValues().third);
            this.fRight = this.getStructure(pc.getValues().second);
        } else {
            this.fAncestor = null;
            this.fLeft = this.getStructure(pc.getValues().first);
            this.fRight = this.getStructure(pc.getValues().second);
        }
        return true;
    }

    public boolean isEnabled(ISelection s) {
        boolean threeWay;
        Object[] selection = ((IStructuredSelection)s).toArray();
        if (selection.length < 2 || selection.length > 3) {
            return false;
        }
        boolean bl = threeWay = selection.length == 3;
        if (threeWay) {
            return this.comparable(selection[0], selection[1]) && this.comparable(selection[0], selection[2]) && this.comparable(selection[1], selection[2]);
        }
        return this.comparable(selection[0], selection[1]);
    }

    void initializeCompareConfiguration() {
        CompareConfiguration cc = this.getCompareConfiguration();
        if (this.pc.getValues().first != null) {
            cc.setLeftLabel(this.buildLabel(this.pc.getValues().first));
            cc.setLeftImage(null);
        }
        if (this.pc.getValues().second != null) {
            cc.setRightLabel(this.buildLabel(this.pc.getValues().second));
            cc.setRightImage(null);
        }
        if (this.fThreeWay && this.pc.getValues().third != null) {
            cc.setAncestorLabel(this.buildLabel(this.pc.getValues().third));
            cc.setAncestorImage(null);
        }
    }

    private boolean comparable(Object c1, Object c2) {
        return this.hasStructure(c1) == this.hasStructure(c2);
    }

    private boolean hasStructure(Object input) {
        return false;
    }

    private IStructureComparator getStructure(Object input) {
        return new ObjectValueComparator(this, input);
    }

    public Object prepareInput(IProgressMonitor pm) throws InvocationTargetException {
        try {
            Differencer d = new Differencer(){

                protected Object visit(Object parent, int description, Object ancestor, Object left, Object right) {
                    return new MyDiffNode((IDiffContainer)parent, description, (ITypedElement)ancestor, (ITypedElement)left, (ITypedElement)right);
                }
            };
            Object object = this.fRoot = d.findDifferences(this.fThreeWay, pm, null, (Object)this.fAncestor, (Object)this.fLeft, (Object)this.fRight);
            return object;
        }
        finally {
            pm.done();
        }
    }

    public String getToolTipText() {
        return super.getToolTipText();
    }

    private String buildLabel(Object r) {
        if (r == this.pc.getValues().first) {
            return "Old";
        }
        if (r == this.pc.getValues().second) {
            return "Updated";
        }
        if (r == this.pc.getValues().third) {
            return "Modified";
        }
        return null;
    }

    public void saveChanges(IProgressMonitor pm) throws CoreException {
        super.saveChanges(pm);
        if (this.fRoot instanceof DiffNode) {
            try {
                ValueCompareInput.commit(pm, (DiffNode)this.fRoot);
            }
            finally {
                this.setDirty(false);
            }
        }
    }

    private static void commit(IProgressMonitor pm, DiffNode node) throws CoreException {
        IDiffElement[] children;
        ITypedElement right;
        ITypedElement left;
        if (node instanceof MyDiffNode) {
            ((MyDiffNode)node).clearDirty();
        }
        if ((left = node.getLeft()) instanceof BufferedResourceNode) {
            ((BufferedResourceNode)left).commit(pm);
        }
        if ((right = node.getRight()) instanceof BufferedResourceNode) {
            ((BufferedResourceNode)right).commit(pm);
        }
        if ((children = node.getChildren()) != null) {
            int i = 0;
            while (i < children.length) {
                IDiffElement element = children[i];
                if (element instanceof DiffNode) {
                    ValueCompareInput.commit(pm, (DiffNode)element);
                }
                ++i;
            }
        }
    }

    public Object getAdapter(Class adapter) {
        if (IFile.class.equals((Object)adapter)) {
            return new DummyFile((ObjectValueComparator)this.fLeft);
        }
        return super.getAdapter(adapter);
    }

    public boolean canRunAsJob() {
        return true;
    }

    private class DummyFile
    implements IFile {
        private ObjectValueComparator comp;

        private IStatus unsupportedStatus() {
            return new Status(4, "fi.semantum.simupedia.changemanagement", "unsupported method");
        }

        public DummyFile(ObjectValueComparator comp) {
            this.comp = comp;
        }

        public void accept(IResourceProxyVisitor visitor, int memberFlags) throws CoreException {
            throw new CoreException(this.unsupportedStatus());
        }

        public void accept(IResourceProxyVisitor visitor, int depth, int memberFlags) throws CoreException {
            throw new CoreException(this.unsupportedStatus());
        }

        public void accept(IResourceVisitor visitor) throws CoreException {
            throw new CoreException(this.unsupportedStatus());
        }

        public void accept(IResourceVisitor visitor, int depth, boolean includePhantoms) throws CoreException {
            throw new CoreException(this.unsupportedStatus());
        }

        public void accept(IResourceVisitor visitor, int depth, int memberFlags) throws CoreException {
            throw new CoreException(this.unsupportedStatus());
        }

        public void clearHistory(IProgressMonitor monitor) throws CoreException {
            throw new CoreException(this.unsupportedStatus());
        }

        public void copy(IPath destination, boolean force, IProgressMonitor monitor) throws CoreException {
            throw new CoreException(this.unsupportedStatus());
        }

        public void copy(IPath destination, int updateFlags, IProgressMonitor monitor) throws CoreException {
            throw new CoreException(this.unsupportedStatus());
        }

        public void copy(IProjectDescription description, boolean force, IProgressMonitor monitor) throws CoreException {
            throw new CoreException(this.unsupportedStatus());
        }

        public void copy(IProjectDescription description, int updateFlags, IProgressMonitor monitor) throws CoreException {
            throw new CoreException(this.unsupportedStatus());
        }

        public IMarker createMarker(String type) throws CoreException {
            throw new CoreException(this.unsupportedStatus());
        }

        public IResourceProxy createProxy() {
            return null;
        }

        public void delete(boolean force, IProgressMonitor monitor) throws CoreException {
            throw new CoreException(this.unsupportedStatus());
        }

        public void delete(int updateFlags, IProgressMonitor monitor) throws CoreException {
            throw new CoreException(this.unsupportedStatus());
        }

        public void deleteMarkers(String type, boolean includeSubtypes, int depth) throws CoreException {
            throw new CoreException(this.unsupportedStatus());
        }

        public boolean exists() {
            return true;
        }

        public IMarker findMarker(long id) throws CoreException {
            throw new CoreException(this.unsupportedStatus());
        }

        public IMarker[] findMarkers(String type, boolean includeSubtypes, int depth) throws CoreException {
            throw new CoreException(this.unsupportedStatus());
        }

        public int findMaxProblemSeverity(String type, boolean includeSubtypes, int depth) throws CoreException {
            throw new CoreException(this.unsupportedStatus());
        }

        public String getFileExtension() {
            return this.comp.getType();
        }

        public long getLocalTimeStamp() {
            return 0L;
        }

        public IPath getLocation() {
            return null;
        }

        public URI getLocationURI() {
            return null;
        }

        public IMarker getMarker(long id) {
            return null;
        }

        public long getModificationStamp() {
            return 0L;
        }

        public IPathVariableManager getPathVariableManager() {
            return null;
        }

        public IContainer getParent() {
            return null;
        }

        public Map<QualifiedName, String> getPersistentProperties() throws CoreException {
            throw new CoreException(this.unsupportedStatus());
        }

        public String getPersistentProperty(QualifiedName key) throws CoreException {
            throw new CoreException(this.unsupportedStatus());
        }

        public IProject getProject() {
            return null;
        }

        public IPath getProjectRelativePath() {
            return null;
        }

        public IPath getRawLocation() {
            return null;
        }

        public URI getRawLocationURI() {
            return null;
        }

        public ResourceAttributes getResourceAttributes() {
            return null;
        }

        public Map<QualifiedName, Object> getSessionProperties() throws CoreException {
            throw new CoreException(this.unsupportedStatus());
        }

        public Object getSessionProperty(QualifiedName key) throws CoreException {
            throw new CoreException(this.unsupportedStatus());
        }

        public int getType() {
            return 1;
        }

        public IWorkspace getWorkspace() {
            return null;
        }

        public boolean isAccessible() {
            return true;
        }

        public boolean isDerived() {
            return false;
        }

        public boolean isDerived(int options) {
            return false;
        }

        public boolean isHidden() {
            return false;
        }

        public boolean isHidden(int options) {
            return false;
        }

        public boolean isLinked() {
            return false;
        }

        public boolean isVirtual() {
            return false;
        }

        public boolean isLinked(int options) {
            return false;
        }

        public boolean isLocal(int depth) {
            return false;
        }

        public boolean isPhantom() {
            return false;
        }

        public boolean isSynchronized(int depth) {
            return true;
        }

        public boolean isTeamPrivateMember() {
            return false;
        }

        public boolean isTeamPrivateMember(int options) {
            return false;
        }

        public void move(IPath destination, boolean force, IProgressMonitor monitor) throws CoreException {
            throw new CoreException(this.unsupportedStatus());
        }

        public void move(IPath destination, int updateFlags, IProgressMonitor monitor) throws CoreException {
            throw new CoreException(this.unsupportedStatus());
        }

        public void move(IProjectDescription description, boolean force, boolean keepHistory, IProgressMonitor monitor) throws CoreException {
            throw new CoreException(this.unsupportedStatus());
        }

        public void move(IProjectDescription description, int updateFlags, IProgressMonitor monitor) throws CoreException {
            throw new CoreException(this.unsupportedStatus());
        }

        public void refreshLocal(int depth, IProgressMonitor monitor) throws CoreException {
            throw new CoreException(this.unsupportedStatus());
        }

        public void revertModificationStamp(long value) throws CoreException {
            throw new CoreException(this.unsupportedStatus());
        }

        public void setDerived(boolean isDerived) throws CoreException {
            throw new CoreException(this.unsupportedStatus());
        }

        public void setDerived(boolean isDerived, IProgressMonitor monitor) throws CoreException {
            throw new CoreException(this.unsupportedStatus());
        }

        public void setHidden(boolean isHidden) throws CoreException {
            throw new CoreException(this.unsupportedStatus());
        }

        public void setLocal(boolean flag, int depth, IProgressMonitor monitor) throws CoreException {
            throw new CoreException(this.unsupportedStatus());
        }

        public long setLocalTimeStamp(long value) throws CoreException {
            return 0L;
        }

        public void setPersistentProperty(QualifiedName key, String value) throws CoreException {
            throw new CoreException(this.unsupportedStatus());
        }

        public void setReadOnly(boolean readOnly) {
        }

        public void setResourceAttributes(ResourceAttributes attributes) throws CoreException {
            throw new CoreException(this.unsupportedStatus());
        }

        public void setSessionProperty(QualifiedName key, Object value) throws CoreException {
            throw new CoreException(this.unsupportedStatus());
        }

        public void setTeamPrivateMember(boolean isTeamPrivate) throws CoreException {
            throw new CoreException(this.unsupportedStatus());
        }

        public void touch(IProgressMonitor monitor) throws CoreException {
            throw new CoreException(this.unsupportedStatus());
        }

        public boolean contains(ISchedulingRule rule) {
            return false;
        }

        public boolean isConflicting(ISchedulingRule rule) {
            return false;
        }

        public <T> T getAdapter(Class<T> adapter) {
            return null;
        }

        public void appendContents(InputStream source, boolean force, boolean keepHistory, IProgressMonitor monitor) throws CoreException {
            throw new CoreException(this.unsupportedStatus());
        }

        public void appendContents(InputStream source, int updateFlags, IProgressMonitor monitor) throws CoreException {
            throw new CoreException(this.unsupportedStatus());
        }

        public void create(InputStream source, boolean force, IProgressMonitor monitor) throws CoreException {
            throw new CoreException(this.unsupportedStatus());
        }

        public void create(InputStream source, int updateFlags, IProgressMonitor monitor) throws CoreException {
            throw new CoreException(this.unsupportedStatus());
        }

        public void createLink(IPath localLocation, int updateFlags, IProgressMonitor monitor) throws CoreException {
            throw new CoreException(this.unsupportedStatus());
        }

        public void createLink(URI location, int updateFlags, IProgressMonitor monitor) throws CoreException {
            throw new CoreException(this.unsupportedStatus());
        }

        public void delete(boolean force, boolean keepHistory, IProgressMonitor monitor) throws CoreException {
            throw new CoreException(this.unsupportedStatus());
        }

        public String getCharset() throws CoreException {
            return "UTF-8";
        }

        public String getCharset(boolean checkImplicit) throws CoreException {
            return "UTF-8";
        }

        public String getCharsetFor(Reader reader) throws CoreException {
            return "UTF-8";
        }

        public IContentDescription getContentDescription() throws CoreException {
            return null;
        }

        public InputStream getContents() throws CoreException {
            return this.comp.getContents();
        }

        public InputStream getContents(boolean force) throws CoreException {
            return this.comp.getContents();
        }

        public int getEncoding() throws CoreException {
            return 3;
        }

        public IPath getFullPath() {
            return null;
        }

        public IFileState[] getHistory(IProgressMonitor monitor) throws CoreException {
            return null;
        }

        public String getName() {
            return this.comp.getName();
        }

        public boolean isReadOnly() {
            return false;
        }

        public void move(IPath destination, boolean force, boolean keepHistory, IProgressMonitor monitor) throws CoreException {
            throw new CoreException(this.unsupportedStatus());
        }

        public void setCharset(String newCharset) throws CoreException {
            throw new CoreException(this.unsupportedStatus());
        }

        public void setCharset(String newCharset, IProgressMonitor monitor) throws CoreException {
            throw new CoreException(this.unsupportedStatus());
        }

        public void setContents(InputStream source, boolean force, boolean keepHistory, IProgressMonitor monitor) throws CoreException {
            throw new CoreException(this.unsupportedStatus());
        }

        public void setContents(IFileState source, boolean force, boolean keepHistory, IProgressMonitor monitor) throws CoreException {
            throw new CoreException(this.unsupportedStatus());
        }

        public void setContents(InputStream source, int updateFlags, IProgressMonitor monitor) throws CoreException {
            throw new CoreException(this.unsupportedStatus());
        }

        public void setContents(IFileState source, int updateFlags, IProgressMonitor monitor) throws CoreException {
            throw new CoreException(this.unsupportedStatus());
        }
    }

    class MyDiffNode
    extends DiffNode {
        private boolean fDirty;
        private ITypedElement fLastId;
        private String fLastName;

        public MyDiffNode(IDiffContainer parent, int description, ITypedElement ancestor, ITypedElement left, ITypedElement right) {
            super(parent, description, ancestor, left, right);
            this.fDirty = false;
        }

        public void fireChange() {
            ValueCompareInput.this.setDirty(true);
            this.fDirty = true;
            super.fireChange();
        }

        void clearDirty() {
            this.fDirty = false;
        }

        public String getName() {
            if (this.fLastName == null) {
                this.fLastName = super.getName();
            }
            if (this.fDirty) {
                return String.valueOf('<') + this.fLastName + '>';
            }
            return this.fLastName;
        }

        public ITypedElement getId() {
            ITypedElement id = super.getId();
            if (id == null) {
                return this.fLastId;
            }
            this.fLastId = id;
            return id;
        }
    }
}

