/*
 * Decompiled with CFR 0.152.
 */
package vtk;

import java.io.File;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import vtk.vtkJavaGarbageCollector;
import vtk.vtkObjectBase;
import vtk.vtkRenderWindow;
import vtk.vtkSettings;
import vtk.vtkTesting;

public class vtkJavaTesting {
    public static final int FAILED = 0;
    public static final int PASSED = 1;
    public static final int NOT_RUN = 2;
    public static final int DO_INTERACTOR = 3;
    private static vtkTesting Tester = null;

    private static int LoadLib(String lib, boolean verbose) {
        block6: {
            try {
                if (verbose) {
                    System.out.println("Try to load: " + lib);
                }
                if (new File(lib).exists() || !verbose) break block6;
                System.out.println("File does not exist: " + lib);
                return 0;
            }
            catch (UnsatisfiedLinkError e) {
                if (verbose) {
                    System.out.println("Failed to load: " + lib);
                    e.printStackTrace();
                }
                return 0;
            }
        }
        Runtime.getRuntime().load(lib);
        if (verbose) {
            System.out.println("Successfully loaded: " + lib);
        }
        return 1;
    }

    private static void LoadLibrary(String path, String library, boolean verbose) {
        String lname = System.mapLibraryName(library);
        String sep = System.getProperty("file.separator");
        String libname = String.valueOf(path) + sep + lname;
        String releaselibname = String.valueOf(path) + sep + "Release" + sep + lname;
        String debuglibname = String.valueOf(path) + sep + "Debug" + sep + lname;
        if (vtkJavaTesting.LoadLib(library, verbose) != 1 && vtkJavaTesting.LoadLib(libname, verbose) != 1 && vtkJavaTesting.LoadLib(releaselibname, verbose) != 1 && vtkJavaTesting.LoadLib(debuglibname, verbose) != 1) {
            System.out.println("Problem loading appropriate library");
        }
    }

    public static void Initialize(String[] args) {
        vtkJavaTesting.Initialize(args, false);
    }

    public static void Initialize(String[] args, boolean verbose) {
        String lpath = vtkSettings.GetVTKLibraryDir();
        if (lpath != null) {
            String path_separator = System.getProperty("path.separator");
            String s = System.getProperty("java.library.path");
            s = String.valueOf(s) + path_separator + lpath;
            System.setProperty("java.library.path", s);
        }
        String[] kits = vtkSettings.GetKits();
        int cc = 0;
        while (cc < kits.length) {
            vtkJavaTesting.LoadLibrary(lpath, String.valueOf(kits[cc]) + "Java", verbose);
            ++cc;
        }
        Tester = new vtkTesting();
        cc = 0;
        while (cc < args.length) {
            Tester.AddArgument(args[cc]);
            ++cc;
        }
    }

    public static boolean IsInteractive() {
        return Tester.IsInteractiveModeSpecified() != 0;
    }

    public static void Exit(int retVal) {
        Tester = null;
        System.gc();
        vtkObjectBase.JAVA_OBJECT_MANAGER.gc(true);
        if (retVal == 0 || retVal == 2) {
            System.out.println("Test failed or was not run");
            System.exit(1);
        }
        System.out.println("Test passed");
        System.exit(0);
    }

    public static int RegressionTest(vtkRenderWindow renWin, int threshold) {
        Tester.SetRenderWindow(renWin);
        if (Tester.RegressionTest(threshold) == 1) {
            return 1;
        }
        System.out.println("Image difference: " + Tester.GetImageDifference());
        return 0;
    }

    public static void StartTimeoutExit(long time, TimeUnit unit) {
        ScheduledExecutorService killerThread = Executors.newSingleThreadScheduledExecutor();
        Runnable killer = new Runnable(){

            @Override
            public void run() {
                System.exit(0);
            }
        };
        killerThread.schedule(killer, time, unit);
    }

    public static vtkJavaGarbageCollector StartGCInEDT(long time, TimeUnit unit) {
        vtkJavaGarbageCollector gc = vtkObjectBase.JAVA_OBJECT_MANAGER.getAutoGarbageCollector();
        gc.SetScheduleTime(time, unit);
        gc.SetAutoGarbageCollection(true);
        return gc;
    }
}

