/*
 * Decompiled with CFR 0.152.
 */
package vtk.rendering.swt;

import com.jogamp.common.util.VersionNumber;
import com.jogamp.opengl.GLAutoDrawable;
import com.jogamp.opengl.GLCapabilities;
import com.jogamp.opengl.GLCapabilitiesImmutable;
import com.jogamp.opengl.GLContext;
import com.jogamp.opengl.GLProfile;
import com.jogamp.opengl.GLRunnable;
import com.jogamp.opengl.swt.GLCanvas;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.MessageBox;
import vtk.rendering.swt.vtkSwtComponent;
import vtk.rendering.swt.vtkSwtInteractorForwarderDecorator;
import vtk.vtkObject;

public class vtkInternalSwtComponent
extends GLCanvas
implements Listener {
    private vtkSwtComponent parent;
    private Boolean init;
    private String error;
    boolean disposing = false;

    public static GLCapabilities GetGLCapabilities() {
        GLCapabilities caps = new GLCapabilities(GLProfile.get((String)"GL2GL3"));
        caps.setDoubleBuffered(true);
        caps.setHardwareAccelerated(true);
        caps.setRedBits(8);
        caps.setGreenBits(8);
        caps.setBlueBits(8);
        caps.setAlphaBits(8);
        caps.setDepthBits(24);
        caps.setStencilBits(8);
        return caps;
    }

    public vtkInternalSwtComponent(vtkSwtComponent parent, Composite parentComposite) {
        super(parentComposite, 262144, (GLCapabilitiesImmutable)vtkInternalSwtComponent.GetGLCapabilities(), null);
        this.parent = parent;
        vtkSwtInteractorForwarderDecorator forwarder = (vtkSwtInteractorForwarderDecorator)this.parent.getInteractorForwarder();
        this.addMouseListener(forwarder);
        this.addKeyListener(forwarder);
        this.addMouseMoveListener(forwarder);
        this.addMouseTrackListener(forwarder);
        this.addMouseWheelListener(forwarder);
        this.addListener(9, this);
        this.addListener(21, this);
        this.addListener(12, this);
        this.addListener(11, this);
        this.IntializeRenderWindow();
    }

    protected void IntializeRenderWindow() {
        this.invoke(false, new GLRunnable(){

            public boolean run(GLAutoDrawable arg0) {
                vtkInternalSwtComponent.this.setFocus();
                vtkInternalSwtComponent.this.getContext().makeCurrent();
                GLCapabilitiesImmutable capabilities = vtkInternalSwtComponent.this.getChosenGLCapabilities();
                GLContext context = vtkInternalSwtComponent.this.getContext();
                if (capabilities == null || context == null) {
                    vtkInternalSwtComponent.this.parent.getRenderWindow().OffScreenRenderingOn();
                    vtkInternalSwtComponent.this.parent.getRenderer().DrawOff();
                    vtkInternalSwtComponent.this.init = false;
                    vtkInternalSwtComponent.this.error = "Could not get OpenGL context, is OpenGL supported?";
                    return false;
                }
                VersionNumber version = context.getGLVersionNumber();
                if (version == null || !version.hasMajor() || version.getMajor() < 3) {
                    vtkInternalSwtComponent.this.parent.getRenderWindow().OffScreenRenderingOn();
                    vtkInternalSwtComponent.this.parent.getRenderer().DrawOff();
                    vtkInternalSwtComponent.this.init = false;
                    vtkInternalSwtComponent.this.error = "System supports OpenGL " + version + ", version 3 is minimum supported.";
                    return false;
                }
                vtkInternalSwtComponent.this.parent.getRenderWindow().InitializeFromCurrentContext();
                vtkInternalSwtComponent.this.parent.getRenderWindow().DoubleBufferOff();
                vtkInternalSwtComponent.this.parent.getRenderWindow().SwapBuffersOn();
                vtkInternalSwtComponent.this.init = true;
                return false;
            }
        });
        this.swapBuffers();
        this.setAutoSwapBufferMode(false);
    }

    public boolean isInit() {
        if (this.init == null) {
            return false;
        }
        return this.init;
    }

    public void update() {
        if (!this.isInit()) {
            if (this.error != null) {
                MessageBox message = new MessageBox(this.getDisplay().getActiveShell(), 65569);
                message.setMessage(this.error);
                this.error = null;
                message.open();
            }
            return;
        }
        super.update();
        if (this.isRealized()) {
            this.parent.Render();
        }
    }

    public void dispose() {
        if (this.isDisposed()) {
            return;
        }
        if (this.disposing) {
            return;
        }
        this.disposing = true;
        this.setFocus();
        GLContext ctx = this.getContext();
        if (ctx != null && !ctx.isCurrent()) {
            ctx.makeCurrent();
        }
        this.removeListener(9, this);
        this.removeListener(21, this);
        this.removeListener(12, this);
        this.removeListener(11, this);
        if (this.parent != null) {
            this.parent.getRenderer().DrawOff();
            this.parent.Delete();
            vtkObject.JAVA_OBJECT_MANAGER.gc(false);
            this.parent = null;
        }
        if (this.getContext() != null && this.getContext().isCurrent()) {
            try {
                this.getContext().release();
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        super.dispose();
    }

    public void handleEvent(Event event) {
        switch (event.type) {
            case 9: {
                if (!this.isRealized()) break;
                this.parent.Render();
                break;
            }
            case 12: {
                this.parent.Delete();
                vtkObject.JAVA_OBJECT_MANAGER.gc(false);
                break;
            }
            case 21: {
                break;
            }
            case 11: {
                this.parent.setSize(this.getClientArea().width, this.getClientArea().height);
            }
        }
    }
}

