/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.plant3d.scenegraph;

import java.util.HashMap;
import java.util.Map;
import javax.vecmath.Quat4d;
import javax.vecmath.Vector3d;
import org.simantics.g3d.property.annotations.GetPropertyValue;
import org.simantics.objmap.graph.annotations.DynamicGraphType;
import org.simantics.objmap.graph.annotations.GetType;
import org.simantics.objmap.graph.annotations.RelatedGetObj;
import org.simantics.objmap.graph.annotations.RelatedGetValue;
import org.simantics.objmap.graph.annotations.RelatedSetObj;
import org.simantics.objmap.graph.annotations.RelatedSetValue;
import org.simantics.objmap.graph.annotations.SetType;
import org.simantics.plant3d.scenegraph.PipeRun;
import org.simantics.plant3d.scenegraph.PipelineComponent;
import org.simantics.plant3d.scenegraph.controlpoint.ControlPointFactory;
import org.simantics.plant3d.scenegraph.controlpoint.PipeControlPoint;

@DynamicGraphType(value="http://www.simantics.org/Plant3D-0.1/Nozzle")
public class Nozzle
extends PipelineComponent {
    private String type;
    private PipeControlPoint controlPoint;
    private int id = 0;
    private boolean fixed = false;

    @Override
    @GetType(value="http://www.simantics.org/Plant3D-0.1/Nozzle")
    public String getType() {
        return this.type;
    }

    @Override
    @SetType(value="http://www.simantics.org/Plant3D-0.1/Nozzle")
    public void setType(String type) throws Exception {
        this.type = type;
        this._createCP();
    }

    @RelatedGetValue(value="http://www.simantics.org/Plant3D-0.1/HasNozzleId")
    @GetPropertyValue(name="Nozzle ID", value="http://www.simantics.org/Plant3D-0.1/HasNozzleId", tabId="Default")
    public int getNozzleId() {
        return this.id;
    }

    @RelatedSetValue(value="http://www.simantics.org/Plant3D-0.1/HasNozzleId")
    public void setNozzleId(int id) {
        if (id == this.id) {
            return;
        }
        this.id = id;
        this.firePropertyChanged("http://www.simantics.org/Plant3D-0.1/HasNozzleId");
    }

    @RelatedGetValue(value="http://www.simantics.org/Plant3D-0.1/IsFixedNozzle")
    @GetPropertyValue(name="Fixed", value="http://www.simantics.org/Plant3D-0.1/IsFixedNozzle", tabId="Default")
    public boolean isFixed() {
        return this.fixed;
    }

    @RelatedSetValue(value="http://www.simantics.org/Plant3D-0.1/IsFixedNozzle")
    public void setFixed(boolean fixed) {
        if (fixed == this.fixed) {
            return;
        }
        this.fixed = fixed;
        this.firePropertyChanged("http://www.simantics.org/Plant3D-0.1/IsFixedNozzle");
    }

    private void _createCP() throws Exception {
        if (this.controlPoint != null) {
            return;
        }
        this.controlPoint = ControlPointFactory.create(this);
        this.controlPoint.setDeletable(false);
        this.controlPoint.setFixed(true);
        this.syncNext();
        this.syncPrevious();
    }

    @Override
    @RelatedSetObj(value="http://www.simantics.org/Plant3D-0.1/HasPipeRun")
    public void setPipeRun(PipeRun pipeRun) {
        if (this.getPipeRun() == pipeRun) {
            return;
        }
        super.setPipeRun(pipeRun);
        try {
            this._createCP();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        this.firePropertyChanged("http://www.simantics.org/Plant3D-0.1/HasPipeRun");
    }

    @Override
    @RelatedGetObj(value="http://www.simantics.org/Plant3D-0.1/HasPipeRun")
    public PipeRun getPipeRun() {
        return super.getPipeRun();
    }

    @Override
    public PipeControlPoint getControlPoint() {
        return this.controlPoint;
    }

    @Override
    public void setPosition(Vector3d position) {
        super.setPosition(position);
        this.updateCP();
    }

    @Override
    public void setOrientation(Quat4d orientation) {
        super.setOrientation(orientation);
        this.updateCP();
    }

    private void updateCP() {
        if (this.controlPoint == null) {
            return;
        }
        if (this.controlPoint.getPipeRun() == null) {
            return;
        }
        this.controlPoint._setWorldPosition(this.getWorldPosition());
        this.controlPoint._setWorldOrientation(this.getWorldOrientation());
    }

    @Override
    public Map<String, Object> updateParameterMap() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        PipeRun pipeRun = this.getPipeRun();
        if (pipeRun != null) {
            map.put("radius", pipeRun.getPipeDiameter() * 0.5);
        }
        return map;
    }

    @Override
    protected double[] getColor() {
        return new double[]{0.7, 0.7, 0.7};
    }

    @Override
    protected double[] getSelectedColor() {
        return new double[]{0.5, 0.0, 0.5};
    }

    public boolean isConnected() {
        PipeControlPoint pcp = this.getControlPoint();
        return pcp.getNext() != null || pcp.getPrevious() != null;
    }

    public boolean isNextConnected() {
        PipeControlPoint pcp = this.getControlPoint();
        return pcp.getNext() != null;
    }

    public boolean isPrevConnected() {
        PipeControlPoint pcp = this.getControlPoint();
        return pcp.getNext() != null;
    }
}

