/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.plant3d.scenegraph;

import java.util.HashMap;
import java.util.Map;
import javax.vecmath.Point3d;
import javax.vecmath.Tuple3d;
import javax.vecmath.Vector3d;
import org.simantics.g3d.math.MathTools;
import org.simantics.g3d.property.annotations.GetPropertyValue;
import org.simantics.g3d.property.annotations.SetPropertyValue;
import org.simantics.g3d.scenegraph.base.ParentNode;
import org.simantics.objmap.graph.annotations.DynamicGraphType;
import org.simantics.objmap.graph.annotations.GetType;
import org.simantics.objmap.graph.annotations.RelatedGetValue;
import org.simantics.objmap.graph.annotations.RelatedSetValue;
import org.simantics.objmap.graph.annotations.SetType;
import org.simantics.plant3d.scenegraph.PipeRun;
import org.simantics.plant3d.scenegraph.PipelineComponent;
import org.simantics.plant3d.scenegraph.controlpoint.ControlPointFactory;
import org.simantics.plant3d.scenegraph.controlpoint.PipeControlPoint;

@DynamicGraphType(value="http://www.simantics.org/Plant3D-0.1/InlineComponent")
public class InlineComponent
extends PipelineComponent {
    private String type;
    private PipeControlPoint controlPoint;
    private boolean componentCalculatedOffset = false;

    @Override
    @GetType(value="http://www.simantics.org/Plant3D-0.1/InlineComponent")
    public String getType() {
        return this.type;
    }

    @Override
    @SetType(value="http://www.simantics.org/Plant3D-0.1/InlineComponent")
    public void setType(String type) throws Exception {
        this.type = type;
        this.controlPoint = ControlPointFactory.create(this);
        this.syncNext();
        this.syncPrevious();
        this.syncBranch0();
    }

    @Override
    public PipeControlPoint getControlPoint() {
        return this.controlPoint;
    }

    @Override
    public void setParent(ParentNode<?> parent, String name) {
        super.setParent(parent, name);
        this.setPipeRun((PipeRun)parent);
    }

    public boolean isVariableLength() {
        return !this.controlPoint.isFixed();
    }

    public boolean isModifialble() {
        return this.controlPoint.isMod();
    }

    public boolean isSizeChange() {
        return this.controlPoint.isSizeChange();
    }

    @RelatedGetValue(value="http://www.simantics.org/Plant3D-0.1/HasRotationAngle")
    @GetPropertyValue(name="Rotation Angle", value="http://www.simantics.org/Plant3D-0.1/HasRotationAngle", tabId="Default")
    public Double getRotationAngle() {
        if (!this.controlPoint.isRotate()) {
            return null;
        }
        Double d = this.controlPoint.getRotationAngle();
        if (d == null) {
            return 0.0;
        }
        return MathTools.radToDeg((double)d);
    }

    @RelatedSetValue(value="http://www.simantics.org/Plant3D-0.1/HasRotationAngle")
    @SetPropertyValue(value="http://www.simantics.org/Plant3D-0.1/HasRotationAngle")
    public void setRotationAngle(Double angle) {
        if (!this.controlPoint.isRotate()) {
            return;
        }
        if (angle == null || Double.isInfinite(angle) || Double.isNaN(angle)) {
            return;
        }
        angle = MathTools.degToRad((double)angle);
        if (this.controlPoint.getRotationAngle() != null && Math.abs(this.controlPoint.getRotationAngle() - angle) < MathTools.NEAR_ZERO) {
            return;
        }
        this.controlPoint.setRotationAngle(angle);
        this.getControlPoint().requestUpdate();
    }

    @RelatedGetValue(value="http://www.simantics.org/Plant3D-0.1/IsReversed")
    @GetPropertyValue(name="Reverse", value="http://www.simantics.org/Plant3D-0.1/IsReversed", tabId="Default")
    public Boolean isReversed() {
        if (!this.controlPoint.isReverse()) {
            return null;
        }
        Boolean d = this.controlPoint._getReversed();
        return d;
    }

    @RelatedSetValue(value="http://www.simantics.org/Plant3D-0.1/IsReversed")
    @SetPropertyValue(value="http://www.simantics.org/Plant3D-0.1/IsReversed")
    public void setReversed(Boolean reverse) {
        if (!this.controlPoint.isReverse()) {
            return;
        }
        if (reverse == null) {
            return;
        }
        this.controlPoint.setReversed(reverse);
        this.getControlPoint().requestUpdate();
    }

    @Override
    public void updateParameters() {
        super.updateParameters();
        if (!this.isVariableLength()) {
            Map<String, Object> calculated = this.getCalculatedParameters();
            if (calculated.containsKey("offset")) {
                this.controlPoint.setOffset((Double)calculated.get("offset"));
                this.componentCalculatedOffset = true;
            } else {
                this.componentCalculatedOffset = false;
            }
            Map<String, Object> total = this.getTotalParameters();
            if (total.containsKey("length")) {
                this.controlPoint.setLength((Double)total.get("length"));
            }
            this.getControlPoint().requestUpdate();
        }
    }

    @Override
    public void setPipeRun(PipeRun pipeRun) {
        super.setPipeRun(pipeRun);
        if (this.getPipeRun() != null && this.getAlternativePipeRun() != null) {
            this.updateOffset();
        }
    }

    @Override
    public void setAlternativePipeRun(PipeRun pipeRun) {
        super.setAlternativePipeRun(pipeRun);
        if (this.getPipeRun() != null && this.getAlternativePipeRun() != null) {
            this.updateOffset();
        }
    }

    private void updateOffset() {
        if (!this.componentCalculatedOffset && this.getControlPoint().isOffset()) {
            this.getControlPoint().setOffset(this.getPipeRun().getInsideDiameter() * 0.5 - this.getAlternativePipeRun().getInsideDiameter() * 0.5);
        }
    }

    @Override
    public Map<String, Object> updateParameterMap() {
        PipeRun pipeRun;
        HashMap<String, Object> map = new HashMap<String, Object>();
        if (this.controlPoint != null) {
            if (!Double.isNaN(this.controlPoint.getLength()) && this.controlPoint.isVariableLength()) {
                map.put("length", this.controlPoint.getLength());
            }
            if (this.controlPoint.isDualInline()) {
                PipeControlPoint sub = this.controlPoint.getDualSub();
                PipeRun pipeRun2 = sub.getPipeRun();
                if (pipeRun2 != null) {
                    map.put("radius2", pipeRun2.getPipeDiameter() * 0.5);
                }
                if (this.controlPoint.isOffset() && !this.componentCalculatedOffset) {
                    if (this.getPipeRun() != null && this.getAlternativePipeRun() != null) {
                        this.updateOffset();
                    }
                    map.put("offset", this.controlPoint.getOffset());
                }
            }
        }
        if ((pipeRun = this.getPipeRun()) != null) {
            map.put("radius", pipeRun.getPipeDiameter() * 0.5);
        }
        return map;
    }

    @SetPropertyValue(value="flowlength")
    public void setFlowLength(double l) {
        if (this.getNext() != null) {
            throw new IllegalStateException("Cannot edit length of a connected component");
        }
        double length = this.getFlowLength();
        Point3d p1 = new Point3d();
        Point3d p2 = new Point3d();
        this.controlPoint.getControlPointEnds((Tuple3d)p1, (Tuple3d)p2);
        Vector3d dir = new Vector3d();
        dir.sub((Tuple3d)p2, (Tuple3d)p1);
        dir.normalize();
        dir.scale((l - length) / 2.0);
        Vector3d pos = new Vector3d(this.getPosition());
        pos.add((Tuple3d)dir);
        this.setPosition(pos);
    }
}

