/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.plant3d.actions;

import org.eclipse.jface.action.Action;
import org.eclipse.swt.widgets.Display;
import org.simantics.plant3d.dialog.EquipmentSelectionDialog;
import org.simantics.plant3d.scenegraph.Equipment;
import org.simantics.plant3d.scenegraph.P3DRootNode;
import org.simantics.plant3d.utils.ComponentUtils;
import org.simantics.plant3d.utils.Item;
import org.simantics.utils.ui.ExceptionUtils;

public class AddEquipmentAction
extends Action {
    P3DRootNode root;
    private String libUri;

    public AddEquipmentAction(P3DRootNode root, String libUri) {
        this.root = root;
        this.libUri = libUri;
        this.setText("Add equipment");
    }

    public void run() {
        EquipmentSelectionDialog dialog = new EquipmentSelectionDialog(Display.getCurrent().getActiveShell(), this.root, this.libUri);
        if (dialog.open() == 1) {
            return;
        }
        Item item = dialog.getSelected();
        if (item == null) {
            return;
        }
        Item selectedNozzle = dialog.getSelectedNozzle();
        try {
            Equipment equipment = null;
            equipment = selectedNozzle == null ? ComponentUtils.createEquipment(this.root, item) : ComponentUtils.createEquipmentWithNozzles(this.root, item, selectedNozzle);
            this.root.getNodeMap().commit("Add equipment " + equipment.getName());
        }
        catch (Exception e) {
            ExceptionUtils.logAndShowError((String)"Cannot create equipment", (Throwable)e);
        }
    }
}

