/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.plant3d.actions;

import java.awt.event.KeyEvent;
import java.awt.event.MouseEvent;
import java.awt.event.MouseWheelEvent;
import java.util.HashSet;
import java.util.Set;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.resource.ResourceLocator;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;
import org.simantics.db.Resource;
import org.simantics.g3d.scenegraph.NodeMap;
import org.simantics.g3d.scenegraph.base.INode;
import org.simantics.g3d.vtk.common.VtkView;
import org.simantics.g3d.vtk.swt.InteractiveVtkComposite;
import org.simantics.g3d.vtk.swt.vtkSwtAction;
import org.simantics.plant3d.dialog.ComponentSelectionDialog;
import org.simantics.plant3d.gizmo.TerminalSelectionGizmo;
import org.simantics.plant3d.scenegraph.InlineComponent;
import org.simantics.plant3d.scenegraph.Nozzle;
import org.simantics.plant3d.scenegraph.P3DRootNode;
import org.simantics.plant3d.scenegraph.PipelineComponent;
import org.simantics.plant3d.scenegraph.controlpoint.PipeControlPoint;
import org.simantics.plant3d.utils.ComponentUtils;
import org.simantics.plant3d.utils.Item;
import org.simantics.utils.threads.IThreadWorkQueue;
import org.simantics.utils.threads.ThreadUtils;
import org.simantics.utils.ui.ExceptionUtils;
import vtk.vtkProp;

public class AddComponentAction
extends vtkSwtAction {
    private P3DRootNode root;
    private PipelineComponent component;
    private NodeMap<Resource, vtkProp, INode> nodeMap;
    private TerminalSelectionGizmo gizmo;
    private Set<PipeControlPoint.PositionType> allowed = new HashSet<PipeControlPoint.PositionType>();
    private Item toAdd = null;
    private PipeControlPoint.PositionType insertPosition;
    private boolean insertAdjustable;
    private boolean lengthAdjustable;
    private String libUri;
    private double lengthFactor = 1.0;
    private String lengthUnit = "m";
    private String componentTypeURI;
    private String name;
    private Double length;
    private Double angle;
    private Double rotationAngle;
    private Double diameter;
    private Double thickness;
    private Double turnRadius;

    public AddComponentAction(InteractiveVtkComposite panel, P3DRootNode root, String libUri) {
        super(panel);
        this.root = root;
        this.setText("Add Component");
        this.setImageDescriptor((ImageDescriptor)ResourceLocator.imageDescriptorFromBundle((String)"org.simantics.plant3d", (String)"icons/Component.png").get());
        this.nodeMap = root.getNodeMap();
        this.gizmo = new TerminalSelectionGizmo((VtkView)panel);
        this.libUri = libUri;
    }

    public void setLengthFactor(double lengthFactor) {
        this.lengthFactor = lengthFactor;
    }

    public void setLengthUnit(String lengthUnit) {
        this.lengthUnit = lengthUnit;
    }

    public void setComponent(PipelineComponent component) {
        this.component = component;
        this.allowed.clear();
        if (component instanceof Nozzle) {
            if (component.getNext() == null && component.getPrevious() == null) {
                this.allowed.add(PipeControlPoint.PositionType.NEXT);
            }
        } else {
            if (component.getNext() == null || component.getControlPoint().isVariableLength()) {
                this.allowed.add(PipeControlPoint.PositionType.NEXT);
            }
            if (component.getPrevious() == null || component.getControlPoint().isVariableLength()) {
                this.allowed.add(PipeControlPoint.PositionType.PREVIOUS);
            }
            if (component instanceof InlineComponent && component.getControlPoint().isVariableLength()) {
                this.allowed.add(PipeControlPoint.PositionType.SPLIT);
            }
        }
        this.setEnabled(this.allowed.size() > 0);
    }

    public void run() {
        ComponentSelectionDialog dialog = new ComponentSelectionDialog(Display.getCurrent().getActiveShell(), this.allowed, this.component, this.libUri);
        dialog.addUsedNames(ComponentUtils.getPipelineComponentNames(this.root));
        dialog.setLengthFactor(this.lengthFactor);
        dialog.setLengthUnit(this.lengthUnit);
        if (this.componentTypeURI != null) {
            dialog.setSelectedItem(this.componentTypeURI);
        }
        if (dialog.open() == 1) {
            return;
        }
        this.toAdd = dialog.getSelected();
        if (this.toAdd == null) {
            return;
        }
        this.name = dialog.getName();
        this.insertPosition = dialog.getInsertPosition();
        this.insertAdjustable = dialog.isInsertAdjustable();
        this.lengthAdjustable = dialog.isLenghtAdjustable();
        this.length = dialog.getLength();
        this.angle = dialog.getAngle();
        this.rotationAngle = dialog.getRotationAngle();
        this.diameter = dialog.getDiameter();
        this.thickness = dialog.getThickness();
        this.turnRadius = dialog.getTurnRadius();
        this.allowed = dialog.filterAllowed();
        this.gizmo.setComponent(this.component, this.allowed);
        super.run();
        this.panel.refresh();
    }

    public boolean keyPressed(KeyEvent e) {
        if (e.getKeyCode() == 27) {
            this.panel.useDefaultAction();
        }
        return true;
    }

    public void attach() {
        if (this.component == null) {
            return;
        }
        super.attach();
        ThreadUtils.asyncExec((IThreadWorkQueue)this.panel.getThreadQueue(), (Runnable)new Runnable(){

            @Override
            public void run() {
                AddComponentAction.this.attachUI();
            }
        });
    }

    public void deattach() {
        this.component = null;
        this.nodeMap.commit("Add component");
        this.deattachUI();
        super.deattach();
        this.panel.refresh();
    }

    private void attachUI() {
        this.gizmo.attach((VtkView)this.panel);
    }

    private void deattachUI() {
        this.gizmo.deattach();
    }

    public boolean mouseMoved(MouseEvent e) {
        return this.getDefaultAction().mouseMoved(e);
    }

    public boolean mousePressed(MouseEvent e) {
        return this.getDefaultAction().mousePressed(e);
    }

    public boolean mouseReleased(MouseEvent e) {
        return this.getDefaultAction().mouseReleased(e);
    }

    public boolean mouseDragged(MouseEvent e) {
        return this.getDefaultAction().mouseDragged(e);
    }

    public void doInsert(PipeControlPoint.PositionType position) {
        try {
            if (position == PipeControlPoint.PositionType.SPLIT && this.length != null && this.length > this.component.getControlPoint().getLength()) {
                MessageDialog.openError((Shell)this.panel.getComponent().getShell(), (String)"Error", (String)("There is no room for a component of length " + this.length * this.lengthFactor + " units"));
                return;
            }
            ComponentUtils.InsertInstruction inst = new ComponentUtils.InsertInstruction();
            inst.typeUri = this.toAdd.getUri();
            inst.name = this.name;
            inst.angle = this.angle;
            inst.diameter = this.diameter;
            inst.thickness = this.thickness;
            inst.length = this.length;
            inst.turnRadius = this.turnRadius;
            inst.insertPosition = this.insertPosition;
            inst.rotationAngle = this.rotationAngle;
            inst.position = position;
            PipelineComponent newComponent = ComponentUtils.addComponent(this.root, this.component, inst);
            this.componentAdded(newComponent);
        }
        catch (Exception e) {
            ExceptionUtils.logAndShowError((String)"Cannot add component", (Throwable)e);
        }
    }

    protected void componentAdded(PipelineComponent newComponent) {
    }

    public boolean mouseClicked(MouseEvent e) {
        if (e.getClickCount() == 1 && e.getButton() == 1) {
            int type = this.panel.getPickType();
            this.panel.setPickType(5);
            vtkProp[] picked = this.panel.pick(e.getX(), e.getY());
            this.panel.setPickType(type);
            PipeControlPoint.PositionType position = this.gizmo.getPickedPosition(picked);
            if (position != null) {
                this.doInsert(position);
                this.panel.useDefaultAction();
                return true;
            }
        }
        return this.getDefaultAction().mouseClicked(e);
    }

    public boolean mouseWheelMoved(MouseWheelEvent e) {
        return this.getDefaultAction().mouseWheelMoved(e);
    }

    public void setComponentType(String componentTypeURI) {
        this.componentTypeURI = componentTypeURI;
    }
}

