/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.g3d.shape;

import java.util.ArrayList;
import javax.vecmath.AxisAngle4d;
import javax.vecmath.Tuple3d;
import javax.vecmath.Vector3d;
import org.simantics.g3d.math.MathTools;
import org.simantics.g3d.shape.Mesh;

public class Cone {
    public static Mesh create(double radius, int s) {
        if (s < 3 || radius < MathTools.NEAR_ZERO) {
            throw new IllegalArgumentException();
        }
        ArrayList<Vector3d> vertices = new ArrayList<Vector3d>(s + 2);
        ArrayList<Vector3d> normals = new ArrayList<Vector3d>(vertices.size());
        ArrayList<Integer> indices = new ArrayList<Integer>();
        vertices.add(new Vector3d(0.0, 0.0, 0.0));
        normals.add(new Vector3d(0.0, -1.0, 0.0));
        vertices.add(new Vector3d(0.0, radius * 2.0, 0.0));
        normals.add(new Vector3d(0.0, 1.0, 0.0));
        Vector3d v = new Vector3d(radius, 0.0, 0.0);
        int i = 0;
        while (i < s) {
            AxisAngle4d aa = new AxisAngle4d(0.0, 1.0, 0.0, (double)i / (double)s * Math.PI * 2.0);
            Vector3d t = new Vector3d();
            MathTools.rotate(MathTools.getQuat(aa), (Tuple3d)v, (Tuple3d)t);
            vertices.add(t);
            Vector3d n = new Vector3d(t);
            n.normalize();
            normals.add(n);
            ++i;
        }
        i = 0;
        while (i < s) {
            indices.add(0);
            if (i < s - 1) {
                indices.add(i + 3);
            } else {
                indices.add(2);
            }
            indices.add(i + 2);
            ++i;
        }
        i = 0;
        while (i < s) {
            indices.add(1);
            indices.add(i + 2);
            if (i < s - 1) {
                indices.add(i + 3);
            } else {
                indices.add(2);
            }
            ++i;
        }
        return Mesh.create(vertices, normals, indices);
    }

    public static void main(String[] arg) {
        Mesh s1 = Cone.create(1.0, 3);
        Mesh s2 = Cone.create(1.0, 4);
        System.out.println("debug " + s1 + "\n" + s2);
    }
}

