/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.g3d.scenegraph.structural;

import java.util.Collection;
import java.util.Objects;
import javax.vecmath.Quat4d;
import javax.vecmath.Vector3d;
import org.simantics.g3d.math.MathTools;
import org.simantics.g3d.property.annotations.GetPropertyValue;
import org.simantics.g3d.property.annotations.SetPropertyValue;
import org.simantics.g3d.scenegraph.IG3DNode;
import org.simantics.g3d.scenegraph.base.INode;
import org.simantics.g3d.scenegraph.base.NodeException;
import org.simantics.g3d.scenegraph.structural.IStructuralNode;
import org.simantics.g3d.scenegraph.structural.StructuralParentNode;
import org.simantics.g3d.tools.NodeTools;
import org.simantics.objmap.graph.annotations.RelatedGetValue;
import org.simantics.objmap.graph.annotations.RelatedSetValue;

public abstract class G3DStructuralParentNode<T extends IStructuralNode>
extends StructuralParentNode<T>
implements IG3DNode {
    private Vector3d position = new Vector3d();
    private Quat4d orientation = MathTools.getIdentityQuat();

    @Override
    @GetPropertyValue(value="http://www.simantics.org/G3D-0.1/hasOrientation", tabId="Transform", name="Orientation")
    public Quat4d getOrientation() {
        if (this.getParent() == null) {
            return MathTools.getIdentityQuat();
        }
        return this.orientation;
    }

    @Override
    @GetPropertyValue(value="http://www.simantics.org/G3D-0.1/hasPosition", tabId="Transform", name="Position")
    public Vector3d getPosition() {
        if (this.getParent() == null) {
            return MathTools.ORIGIN;
        }
        return this.position;
    }

    @Override
    @GetPropertyValue(value="http://www.simantics.org/G3D-0.1/hasWorldOrientation", tabId="Transform", name="World Orientation")
    public Quat4d getWorldOrientation() {
        if (this.getParent() == null) {
            return MathTools.getIdentityQuat();
        }
        return this.getWorldOrientation(this.orientation);
    }

    @Override
    @GetPropertyValue(value="http://www.simantics.org/G3D-0.1/hasWorldPosition", tabId="Transform", name="World Position")
    public Vector3d getWorldPosition() {
        IG3DNode parent = (IG3DNode)((Object)this.getParent());
        if (parent == null) {
            return MathTools.ORIGIN;
        }
        return NodeTools.getWorldPosition(parent, new Vector3d(this.position));
    }

    @Override
    public Quat4d getWorldOrientation(Quat4d localOrientation) {
        IG3DNode parent = (IG3DNode)((Object)this.getParent());
        if (parent == null) {
            return localOrientation;
        }
        return NodeTools.getWorldOrientation(parent, localOrientation);
    }

    @Override
    public Vector3d getWorldPosition(Vector3d localPosition) {
        return NodeTools.getWorldPosition(this, localPosition);
    }

    @Override
    public Quat4d getLocalOrientation(Quat4d worldOrientation) {
        IG3DNode parent = (IG3DNode)((Object)this.getParent());
        if (parent == null) {
            return worldOrientation;
        }
        return NodeTools.getLocalOrientation(parent, new Quat4d(worldOrientation));
    }

    @Override
    public Vector3d getLocalPosition(Vector3d worldPosition) {
        IG3DNode parent = (IG3DNode)((Object)this.getParent());
        if (parent == null) {
            return worldPosition;
        }
        return NodeTools.getLocalPosition(parent, new Vector3d(worldPosition));
    }

    @Override
    @SetPropertyValue(value="http://www.simantics.org/G3D-0.1/hasPosition")
    public void setPosition(Vector3d position) {
        if (Objects.equals(this.position, position)) {
            return;
        }
        this.position = position;
        this.firePropertyChanged("http://www.simantics.org/G3D-0.1/hasPosition");
    }

    @Override
    @SetPropertyValue(value="http://www.simantics.org/G3D-0.1/hasOrientation")
    public void setOrientation(Quat4d orientation) {
        if (Objects.equals(this.orientation, orientation)) {
            return;
        }
        this.orientation = orientation;
        this.firePropertyChanged("http://www.simantics.org/G3D-0.1/hasOrientation");
    }

    @Override
    @SetPropertyValue(value="http://www.simantics.org/G3D-0.1/hasWorldOrientation")
    public void setWorldOrientation(Quat4d orientation) {
        if (this.getParent() == null) {
            throw new NodeException("Cannot set root node orientation");
        }
        Quat4d localOr = this.getLocalOrientation(orientation);
        this.setOrientation(localOr);
    }

    @Override
    @SetPropertyValue(value="http://www.simantics.org/G3D-0.1/hasWorldPosition")
    public void setWorldPosition(Vector3d position) {
        if (this.getParent() == null) {
            throw new NodeException("Cannot set root node position");
        }
        Vector3d localPos = this.getLocalPosition(position);
        this.setPosition(localPos);
    }

    @RelatedGetValue(value="http://www.simantics.org/G3D-0.1/hasOrientation")
    public double[] getOrientationArr() {
        double[] arr = new double[4];
        this.orientation.get(arr);
        return arr;
    }

    @RelatedGetValue(value="http://www.simantics.org/G3D-0.1/hasPosition")
    public double[] getPositionArr() {
        double[] arr = new double[3];
        this.position.get(arr);
        return arr;
    }

    @RelatedSetValue(value="http://www.simantics.org/G3D-0.1/hasOrientation")
    public void setOrientation(double[] arr) {
        if (arr == null) {
            return;
        }
        this.setOrientation(new Quat4d(arr));
    }

    @RelatedSetValue(value="http://www.simantics.org/G3D-0.1/hasPosition")
    public void setPosition(double[] arr) {
        if (arr == null) {
            return;
        }
        this.setPosition(new Vector3d(arr));
    }

    protected void _addStrNode(String id, T child) {
        this.addNode(String.valueOf(id) + "/str", child);
    }

    protected boolean _removeStrNode(String id, T child) {
        return this.removeNode(String.valueOf(id) + "/str", (INode)child);
    }

    protected Collection<T> _getStrNodes(String id) {
        return this.getNodes(String.valueOf(id) + "/str");
    }

    public <U> U getAdapter(Class<U> adapter) {
        if (adapter.isInstance(this)) {
            return adapter.cast(this);
        }
        return null;
    }
}

