/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.g3d.property;

import java.util.List;
import org.simantics.g3d.property.ComboValueProvider;
import org.simantics.g3d.property.PropertyManipulator;
import org.simantics.g3d.property.ValueProvider;
import org.simantics.utils.datastructures.Arrays;

public class ComboPropertyManipulator
implements PropertyManipulator {
    ComboValueProvider provider;
    Object input;
    boolean editMode;

    public ComboPropertyManipulator(ValueProvider provider, Object input) {
        this.provider = (ComboValueProvider)provider;
        this.input = input;
    }

    @Override
    public int getValueCount() {
        return 1;
    }

    @Override
    public String getDescription(int i) {
        if (i == 0) {
            return "Value";
        }
        return null;
    }

    @Override
    public String getValue(int i) {
        Object rawValue;
        block5: {
            try {
                rawValue = this.provider.getValue(this.input);
                if (rawValue != null) break block5;
                return null;
            }
            catch (Exception e) {
                return null;
            }
        }
        if (rawValue instanceof Integer) {
            Integer value = (Integer)rawValue;
            return this.getItems()[value];
        }
        if (rawValue instanceof Enum) {
            return rawValue.toString();
        }
        return null;
    }

    @Override
    public String setValue(String value, int i) {
        try {
            int intValue = Integer.parseInt(value);
            Class<?> valueType = this.provider.getValueType();
            if (Enum.class.isAssignableFrom(valueType)) {
                this.provider.setValue(this.input, valueType.getEnumConstants()[intValue]);
            } else {
                this.provider.setValue(this.input, intValue);
            }
        }
        catch (Exception e) {
            return e.getMessage();
        }
        return null;
    }

    @Override
    public boolean getEditMode() {
        return this.editMode;
    }

    @Override
    public void setEditMode(boolean b) {
        this.editMode = b;
    }

    public String[] getItems() {
        try {
            List<Object> vals = this.provider.getValues(this.input);
            String[] arr = new String[vals.size()];
            int i = 0;
            while (i < vals.size()) {
                arr[i] = vals.get(i).toString();
                ++i;
            }
            return arr;
        }
        catch (Exception e) {
            return new String[0];
        }
    }

    public Integer getValueIndex() {
        try {
            Object value = this.provider.getValue(this.input);
            Class<?> valueType = this.provider.getValueType();
            if (valueType.isEnum()) {
                return Arrays.indexOf((Object[])valueType.getEnumConstants(), (Object)value);
            }
            return (Integer)value;
        }
        catch (Exception e) {
            return null;
        }
    }

    public Integer indexOf(String value) {
        String[] items = this.getItems();
        int i = 0;
        while (i < items.length) {
            if (items[i].equals(value)) {
                return i;
            }
            ++i;
        }
        return -1;
    }
}

