/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.g3d.vtk.utils;

import javax.vecmath.Point2d;
import javax.vecmath.Point3d;
import javax.vecmath.Tuple3d;
import org.simantics.g3d.scenegraph.RenderListener;
import org.simantics.g3d.vtk.common.VtkView;
import org.simantics.g3d.vtk.utils.vtkUtil;
import vtk.vtkObjectBase;
import vtk.vtkProp;
import vtk.vtkTextActor;
import vtk.vtkTextProperty;
import vtk.vtkViewport;

public class vtkToolTip<T>
implements RenderListener {
    VtkView view;
    long tooltipDelay = 1000L;
    double[] backgroundColor = new double[]{0.8, 0.8, 0.8};
    double backgroundOpacity = 0.8;
    double[] color = new double[]{0.0, 0.0, 0.0};
    double[] frameColor = new double[]{0.0, 0.0, 0.0};
    int fontSize = 12;
    T obj = null;
    Point3d pos3d;
    Point2d pos2d;
    String tooltip = null;
    boolean showing = false;
    boolean changed = false;
    long setTime = 0L;
    vtkTextActor textActor = null;

    public vtkToolTip(VtkView view) {
        this.view = view;
        view.addListener(this);
    }

    public long getTooltipDelay() {
        return this.tooltipDelay;
    }

    public void setTooltipDelay(long tooltipDelay) {
        this.tooltipDelay = tooltipDelay;
    }

    public void setBackgroundColor(double[] backgroundColor) {
        this.backgroundColor = backgroundColor;
    }

    public void setBackgroundOpacity(double backgroundOpacity) {
        this.backgroundOpacity = backgroundOpacity;
    }

    public void setColor(double[] color) {
        this.color = color;
    }

    public void setFrameColor(double[] frameColor) {
        this.frameColor = frameColor;
    }

    public void setFontSize(int fontSize) {
        this.fontSize = fontSize;
    }

    public void remove() {
        this.obj = null;
        this.pos3d = null;
        this.pos2d = null;
        this.tooltip = null;
        if (this.showing) {
            this.view.refresh();
        }
    }

    public void setHoverObject(T obj, Point3d pos, String tooltip) {
        if (this.obj != null && this.obj == obj) {
            this.pos3d = pos;
            return;
        }
        this.obj = obj;
        this.pos3d = pos;
        this.pos2d = null;
        this.tooltip = tooltip;
        this.setTime = System.currentTimeMillis();
        this.view.refresh();
    }

    public void setHoverObject(T obj, Point2d pos, String tooltip) {
        if (this.obj != null && this.obj == obj) {
            this.pos2d = pos;
            return;
        }
        this.obj = obj;
        this.pos3d = null;
        this.pos2d = pos;
        this.tooltip = tooltip;
        this.setTime = System.currentTimeMillis();
        this.changed = true;
        this.view.refresh();
    }

    public void preRender() {
        if (this.tooltip == null) {
            if (this.showing) {
                this.removeTooltip();
            }
        } else {
            if (this.changed) {
                this.removeTooltip();
            }
            if (!this.showing) {
                this.addTooltip();
            } else {
                this.updateTooltip();
            }
        }
    }

    public void postRender() {
        if (!this.showing && this.tooltip != null) {
            this.view.refresh();
        }
    }

    protected void addTooltip() {
        if (this.showing) {
            return;
        }
        long currentTime = System.currentTimeMillis();
        if (currentTime - this.setTime < this.tooltipDelay) {
            return;
        }
        if (this.textActor == null) {
            this.textActor = new vtkTextActor();
            vtkTextProperty prop = this.textActor.GetTextProperty();
            prop.SetBackgroundColor(this.backgroundColor);
            prop.SetBackgroundOpacity(this.backgroundOpacity);
            prop.SetColor(this.color);
            if (this.frameColor != null) {
                prop.SetFrameColor(this.frameColor);
                prop.SetFrame(1);
            } else {
                prop.SetFrame(0);
            }
            prop.SetFontSize(this.view.upscale(this.fontSize));
            prop.Delete();
            this.view.addDeletable((vtkObjectBase)this.textActor);
        }
        this.textActor.SetInput(this.tooltip);
        this.showing = true;
        this.view.getRenderer().AddActor2D((vtkProp)this.textActor);
        this.updateTooltip();
        this.changed = false;
    }

    protected void removeTooltip() {
        if (!this.showing) {
            return;
        }
        if (this.textActor == null) {
            return;
        }
        this.view.getRenderer().RemoveActor2D((vtkProp)this.textActor);
        this.showing = false;
        this.changed = false;
    }

    protected void updateTooltip() {
        if (!this.showing) {
            return;
        }
        Point2d p = this.pos3d != null ? vtkUtil.getScreenCoordinates(this.view.getRenderer(), (Tuple3d)this.pos3d) : new Point2d(this.pos2d);
        this.screenPoint(p);
        this.textActor.SetDisplayPosition((int)p.x, (int)p.y);
    }

    private void screenPoint(Point2d pos) {
        double[] bounds = new double[4];
        this.textActor.GetBoundingBox((vtkViewport)this.view.getRenderer(), bounds);
        int[] size = this.view.getRenderer().GetRenderWindow().GetSize();
        double sw = size[0];
        double sh = size[1];
        Point2d min = new Point2d(pos.x - bounds[0], pos.y - bounds[2]);
        Point2d max = new Point2d(pos.x + bounds[1] + 1.0, pos.y + bounds[3] + 1.0);
        if (min.x < 0.0) {
            pos.x -= min.x;
        } else if (max.x > sw) {
            pos.x -= max.x - sw;
        }
        if (min.y < 0.0) {
            pos.y -= min.y;
        } else if (max.y > sh) {
            pos.y -= max.y - sh;
        }
    }
}

