/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.g3d.vtk.utils;

import javax.vecmath.AxisAngle4d;
import javax.vecmath.Tuple3d;
import javax.vecmath.Vector3d;
import org.simantics.g3d.math.MathTools;
import org.simantics.g3d.vtk.shape.IvtkVisualObject;
import vtk.vtkAbstractTransform;
import vtk.vtkActor;
import vtk.vtkCamera;
import vtk.vtkContourFilter;
import vtk.vtkDataObject;
import vtk.vtkMapper;
import vtk.vtkOutlineFilter;
import vtk.vtkOutlineSource;
import vtk.vtkPolyData;
import vtk.vtkPolyDataMapper;
import vtk.vtkPolyDataSilhouette;
import vtk.vtkProp;
import vtk.vtkProp3D;
import vtk.vtkRenderWindow;
import vtk.vtkRenderer;
import vtk.vtkTransform;
import vtk.vtkTransformPolyDataFilter;
import vtk.vtkWindow;
import vtk.vtkWindowToImageFilter;

public class vtkEffect {
    private static vtkRenderer tmpRenderer;

    public static vtkRenderer getRenderer() {
        if (tmpRenderer == null) {
            tmpRenderer = new vtkRenderer();
        }
        return tmpRenderer;
    }

    public static vtkActor createContour(vtkProp3D tmpProp) {
        vtkRenderer tmpRenderer = vtkEffect.getRenderer();
        tmpRenderer.SetBackground(1.0, 1.0, 1.0);
        if (tmpProp instanceof IvtkVisualObject) {
            ((IvtkVisualObject)tmpProp).addToRenderer();
        } else {
            tmpRenderer.AddActor((vtkProp)tmpProp);
        }
        if (tmpProp instanceof vtkActor) {
            ((vtkActor)tmpProp).GetProperty().SetColor(0.0, 0.0, 0.0);
        }
        double[] bounds_data = tmpProp.GetBounds();
        double[] center_data = tmpProp.GetCenter();
        tmpRenderer.ResetCamera();
        tmpRenderer.GetActiveCamera().SetParallelProjection(1);
        vtkRenderWindow tmpRenderWindow = new vtkRenderWindow();
        tmpRenderWindow.SetOffScreenRendering(1);
        tmpRenderWindow.AddRenderer(tmpRenderer);
        tmpRenderWindow.Render();
        vtkWindowToImageFilter windowToImageFilter = new vtkWindowToImageFilter();
        windowToImageFilter.SetInput((vtkWindow)tmpRenderWindow);
        windowToImageFilter.Update();
        vtkContourFilter contourFilter = new vtkContourFilter();
        contourFilter.SetInputConnection(windowToImageFilter.GetOutputPort());
        contourFilter.SetValue(0, 255.0);
        contourFilter.Update();
        vtkPolyData contour = contourFilter.GetOutput();
        double[] bounds_contour = new double[6];
        double[] center_contour = new double[3];
        double trans_x = 0.0;
        double trans_y = 0.0;
        double trans_z = 0.0;
        double ratio_x = 0.0;
        double ratio_y = 0.0;
        contour.GetBounds(bounds_contour);
        ratio_x = (bounds_data[1] - bounds_data[0]) / (bounds_contour[1] - bounds_contour[0]);
        ratio_y = (bounds_data[3] - bounds_data[2]) / (bounds_contour[3] - bounds_contour[2]);
        vtkTransform transform1 = new vtkTransform();
        transform1.Scale(ratio_x, ratio_y, 1.0);
        vtkTransformPolyDataFilter tFilter1 = new vtkTransformPolyDataFilter();
        tFilter1.SetInputData((vtkDataObject)contour);
        tFilter1.SetTransform((vtkAbstractTransform)transform1);
        tFilter1.Update();
        contour = tFilter1.GetOutput();
        contour.GetCenter(center_contour);
        trans_x = center_data[0] - center_contour[0];
        trans_y = center_data[1] - center_contour[1];
        trans_z = center_data[2] - center_contour[2];
        vtkTransform transform2 = new vtkTransform();
        transform2.Translate(trans_x, trans_y, trans_z);
        vtkTransformPolyDataFilter tFilter2 = new vtkTransformPolyDataFilter();
        tFilter2.SetInputData((vtkDataObject)contour);
        tFilter2.SetTransform((vtkAbstractTransform)transform2);
        tFilter2.Update();
        contour = tFilter2.GetOutput();
        vtkPolyDataMapper mapper = new vtkPolyDataMapper();
        mapper.SetInputData(contour);
        vtkActor actor = new vtkActor();
        actor.SetMapper((vtkMapper)mapper);
        actor.GetProperty().SetLineWidth(2.0f);
        tmpRenderer.RemoveActor((vtkProp)tmpProp);
        tFilter1.Delete();
        tFilter2.Delete();
        contour.Delete();
        contourFilter.Delete();
        mapper.Delete();
        tmpRenderWindow.Delete();
        transform1.Delete();
        transform2.Delete();
        windowToImageFilter.Delete();
        return actor;
    }

    public static vtkActor createContour(vtkProp3D tmpProp, vtkRenderer ren) {
        vtkRenderer tmpRenderer = vtkEffect.getRenderer();
        tmpRenderer.SetBackground(1.0, 1.0, 1.0);
        if (tmpProp instanceof IvtkVisualObject) {
            ((IvtkVisualObject)tmpProp).addToRenderer();
        } else {
            tmpRenderer.AddActor((vtkProp)tmpProp);
        }
        if (tmpProp instanceof vtkActor) {
            ((vtkActor)tmpProp).GetProperty().SetColor(0.0, 0.0, 0.0);
        }
        double[] center_data = tmpProp.GetCenter();
        tmpRenderer.ResetCamera();
        vtkCamera camera = ren.GetActiveCamera();
        vtkCamera tmpCamera = tmpRenderer.GetActiveCamera();
        tmpCamera.SetParallelProjection(camera.GetParallelProjection());
        Vector3d pos = new Vector3d(camera.GetPosition());
        Vector3d foc = new Vector3d(camera.GetFocalPoint());
        Vector3d dir = new Vector3d();
        dir.sub((Tuple3d)pos, (Tuple3d)foc);
        double l = dir.length();
        tmpCamera.DeepCopy(camera);
        tmpCamera.UpdateViewport(tmpRenderer);
        vtkRenderWindow tmpRenderWindow = new vtkRenderWindow();
        tmpRenderWindow.SetOffScreenRendering(1);
        tmpRenderWindow.AddRenderer(tmpRenderer);
        tmpRenderWindow.Render();
        vtkWindowToImageFilter windowToImageFilter = new vtkWindowToImageFilter();
        windowToImageFilter.SetInput((vtkWindow)tmpRenderWindow);
        windowToImageFilter.Update();
        vtkContourFilter contourFilter = new vtkContourFilter();
        contourFilter.SetInputConnection(windowToImageFilter.GetOutputPort());
        contourFilter.SetValue(0, 255.0);
        contourFilter.Update();
        vtkPolyData contour = contourFilter.GetOutput();
        double[] or = camera.GetOrientationWXYZ();
        AxisAngle4d aa = new AxisAngle4d();
        aa.angle = -MathTools.degToRad((double)or[0]);
        aa.x = or[1];
        aa.y = or[2];
        aa.z = or[3];
        vtkTransform transform0 = new vtkTransform();
        transform0.RotateWXYZ(MathTools.radToDeg((double)aa.angle), aa.x, aa.y, aa.z);
        vtkTransformPolyDataFilter tFilter0 = new vtkTransformPolyDataFilter();
        tFilter0.SetInputData((vtkDataObject)contour);
        tFilter0.SetTransform((vtkAbstractTransform)transform0);
        tFilter0.Update();
        contour.Delete();
        contour = tFilter0.GetOutput();
        double[] bounds_contour = new double[6];
        double trans_x = 0.0;
        double trans_y = 0.0;
        double trans_z = 0.0;
        double ratio_x = 0.002;
        double ratio_y = 0.002;
        double ratio_z = 0.002;
        contour.GetBounds(bounds_contour);
        ratio_x = l * 8.0E-4;
        ratio_y = l * 8.0E-4;
        ratio_z = l * 8.0E-4;
        System.out.println(String.valueOf(ratio_x) + " " + ratio_y);
        vtkTransform transform1 = new vtkTransform();
        transform1.Scale(ratio_x, ratio_y, ratio_z);
        vtkTransformPolyDataFilter tFilter1 = new vtkTransformPolyDataFilter();
        tFilter1.SetInputData((vtkDataObject)contour);
        tFilter1.SetTransform((vtkAbstractTransform)transform1);
        tFilter1.Update();
        contour.Delete();
        contour = tFilter1.GetOutput();
        double[] center_contour = new double[3];
        contour.GetCenter(center_contour);
        trans_x = center_data[0] - center_contour[0];
        trans_y = center_data[1] - center_contour[1];
        trans_z = center_data[2] - center_contour[2];
        System.out.println(String.valueOf(trans_x) + " " + trans_y + " " + trans_z);
        vtkTransform transform2 = new vtkTransform();
        transform2.Translate(trans_x, trans_y, trans_z);
        vtkTransformPolyDataFilter tFilter2 = new vtkTransformPolyDataFilter();
        tFilter2.SetInputData((vtkDataObject)contour);
        tFilter2.SetTransform((vtkAbstractTransform)transform2);
        tFilter2.Update();
        contour.Delete();
        contour = tFilter2.GetOutput();
        vtkPolyDataMapper mapper = new vtkPolyDataMapper();
        mapper.SetInputData(contour);
        vtkActor actor = new vtkActor();
        actor.SetMapper((vtkMapper)mapper);
        actor.GetProperty().SetLineWidth(2.0f);
        actor.GetProperty().SetColor(0.0, 0.0, 1.0);
        actor.GetProperty().Delete();
        tmpRenderer.RemoveActor((vtkProp)tmpProp);
        tFilter0.Delete();
        tFilter1.Delete();
        tFilter2.Delete();
        contour.Delete();
        contourFilter.Delete();
        mapper.Delete();
        tmpRenderWindow.Delete();
        transform0.Delete();
        transform1.Delete();
        transform2.Delete();
        windowToImageFilter.GetOutputPort().Delete();
        windowToImageFilter.Delete();
        ren.AddActor((vtkProp)actor);
        return actor;
    }

    public static vtkActor createSilhouette(vtkRenderer ren, vtkDataObject data) {
        vtkPolyDataSilhouette silhouette = new vtkPolyDataSilhouette();
        silhouette.SetInputData(data);
        silhouette.SetCamera(ren.GetActiveCamera());
        silhouette.SetEnableFeatureAngle(0);
        vtkPolyDataMapper mapper = new vtkPolyDataMapper();
        mapper.SetInputConnection(silhouette.GetOutputPort());
        vtkActor actor = new vtkActor();
        actor.SetMapper((vtkMapper)mapper);
        silhouette.GetOutputPort().Delete();
        silhouette.Delete();
        mapper.Delete();
        return actor;
    }

    public static vtkActor createOutline(vtkDataObject data) {
        vtkOutlineFilter filter = new vtkOutlineFilter();
        filter.SetInputData(data);
        vtkPolyDataMapper mapper = new vtkPolyDataMapper();
        mapper.SetInputConnection(filter.GetOutputPort());
        vtkActor actor = new vtkActor();
        actor.SetMapper((vtkMapper)mapper);
        filter.GetOutputPort().Delete();
        filter.Delete();
        mapper.Delete();
        return actor;
    }

    public static vtkActor createOutline(vtkProp3D prop) {
        double[] bounds = prop.GetBounds();
        vtkOutlineSource source = new vtkOutlineSource();
        source.SetBounds(bounds);
        vtkOutlineFilter filter = new vtkOutlineFilter();
        filter.SetInputData((vtkDataObject)source.GetOutput());
        vtkPolyDataMapper mapper = new vtkPolyDataMapper();
        mapper.SetInputConnection(filter.GetOutputPort());
        vtkActor actor = new vtkActor();
        actor.SetMapper((vtkMapper)mapper);
        source.GetOutput().Delete();
        source.Delete();
        filter.GetOutputPort().Delete();
        filter.Delete();
        mapper.Delete();
        actor.SetPickable(0);
        return actor;
    }
}

