/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.g3d.vtk.common;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.ListIterator;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.ISelectionListener;
import org.eclipse.ui.IWorkbenchPart;
import org.simantics.db.Resource;
import org.simantics.g3d.scenegraph.IG3DNode;
import org.simantics.g3d.scenegraph.base.INode;
import org.simantics.g3d.scenegraph.base.NodeListener;
import org.simantics.g3d.scenegraph.base.ParentNode;
import org.simantics.g3d.tools.AdaptationUtils;
import org.simantics.g3d.vtk.common.VTKNodeMap;
import org.simantics.g3d.vtk.common.VTKSelectionItem;
import org.simantics.objmap.graph.IMapping;
import org.simantics.objmap.structural.StructuralResource;
import org.simantics.utils.ui.AdaptionUtils;
import vtk.vtkProp;

public class NodeSelectionProvider2<DBObject, JavaObject>
implements ISelectionProvider,
ISelectionChangedListener,
ISelectionListener,
NodeListener {
    protected ISelection selection = new StructuredSelection();
    protected List<ISelectionChangedListener> listeners = new ArrayList<ISelectionChangedListener>();
    protected List<INode> selectedNodes = new ArrayList<INode>();
    protected List<VTKSelectionItem<DBObject>> selectedItems = new ArrayList<VTKSelectionItem<DBObject>>();
    protected IEditorPart part;
    protected IMapping<DBObject, JavaObject> mapping;
    protected VTKNodeMap<DBObject, ? extends INode> nodeMap;

    public NodeSelectionProvider2(IEditorPart part, IMapping<DBObject, JavaObject> mapping, VTKNodeMap<DBObject, ? extends INode> nodeMap) {
        this.part = part;
        this.mapping = mapping;
        this.nodeMap = nodeMap;
        nodeMap.addListener(this);
    }

    public void addSelectionChangedListener(ISelectionChangedListener listener) {
        this.listeners.add(listener);
    }

    public void removeSelectionChangedListener(ISelectionChangedListener listener) {
        this.listeners.remove(listener);
    }

    public ISelection getSelection() {
        return this.selection;
    }

    public void setSelection(ISelection selection) {
        ArrayList<IG3DNode> nodes = AdaptionUtils.adaptToCollection((Object)selection, IG3DNode.class);
        Collection resources = AdaptionUtils.adaptToCollection((Object)selection, Resource.class);
        if (nodes.size() > 0) {
            this.processSelection(selection);
            this.fireSelectionChanged(this);
        } else if (resources.size() > 0) {
            nodes = new ArrayList<IG3DNode>();
            for (Resource r : resources) {
                Object n = this.mapping.get((Object)r);
                if (!(n instanceof IG3DNode)) continue;
                nodes.add((IG3DNode)n);
            }
            this.processSelection((ISelection)new StructuredSelection(nodes.toArray()));
            this.fireSelectionChanged(this);
        } else {
            this.processSelection(selection);
            this.fireSelectionChanged(this);
        }
    }

    public void selectionChanged(SelectionChangedEvent event) {
        ISelection s = event.getSelection();
        this.processSelection(s);
        this.fireSelectionChanged(event.getSource());
    }

    protected void processSelection(ISelection s) {
        this.selectedNodes.clear();
        this.selectedItems.clear();
        this._processSelection(s);
    }

    protected void _processSelection(ISelection s) {
        Collection selectedActors = AdaptationUtils.adaptToCollection((Object)s, vtkProp.class);
        if (selectedActors.size() > 0) {
            for (vtkProp a : selectedActors) {
                INode node = this.nodeMap.getNode(a);
                if (node == null) continue;
                if (!this.selectedNodes.contains(node)) {
                    this.selectedNodes.add(node);
                }
                Object r = this.mapping.inverseGet((Object)node);
                this.selectedItems.add(new VTKSelectionItem<Object>(a, node, r));
            }
        } else {
            Collection selectedNds = AdaptationUtils.adaptToCollection((Object)s, IG3DNode.class);
            for (INode node : selectedNds) {
                if (!this.selectedNodes.contains(node)) {
                    this.selectedNodes.add((INode)((IG3DNode)node));
                }
                Object r = this.mapping.inverseGet((Object)node);
                this.selectedItems.add(new VTKSelectionItem<Object>(null, (INode)((IG3DNode)node), r));
            }
        }
        this.selection = new StructuredSelection(this.selectedItems);
    }

    protected void fireSelectionChanged(Object source) {
        SelectionChangedEvent evt = new SelectionChangedEvent((ISelectionProvider)source, this.selection);
        for (ISelectionChangedListener l : this.listeners) {
            l.selectionChanged(evt);
        }
    }

    public void selectionChanged(IWorkbenchPart part, ISelection selection) {
        if (part == this.part) {
            return;
        }
        this.processSelection(selection);
    }

    public List<INode> getSelectedNodes() {
        return this.selectedNodes;
    }

    public List<VTKSelectionItem<DBObject>> getSelectedItems() {
        return this.selectedItems;
    }

    public List<DBObject> getSelectedResources() {
        ArrayList<Resource> list = new ArrayList<Resource>();
        for (VTKSelectionItem<DBObject> i : this.selectedItems) {
            Resource r = i.getAdapter(Resource.class);
            if (r == null) {
                r = i.getAdapter(StructuralResource.class);
            }
            if (r == null || list.contains(r)) continue;
            list.add(r);
        }
        return list;
    }

    protected INode getNode(DBObject r) {
        return (INode)this.mapping.get(r);
    }

    public void propertyChanged(INode node, String id) {
    }

    public <T extends INode> void nodeAdded(ParentNode<T> node, INode child, String rel) {
    }

    public <T extends INode> void nodeRemoved(ParentNode<T> node, INode child, String rel) {
        boolean changed = false;
        ListIterator<VTKSelectionItem<DBObject>> it = this.selectedItems.listIterator();
        while (it.hasNext()) {
            VTKSelectionItem<DBObject> item = it.next();
            INode n = item.getAdapter(INode.class);
            if (n == null || !n.equals(child)) continue;
            it.remove();
            changed = true;
        }
        boolean bl = changed = this.selectedNodes.remove(child) || changed;
        if (changed) {
            this.fireSelectionChanged(this);
        }
    }
}

