/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.g3d.csg.actions;

import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import javax.vecmath.Quat4d;
import javax.vecmath.Vector3d;
import org.eclipse.jface.action.Action;
import org.simantics.g3d.csg.scenegraph2.CSGparentNode;
import org.simantics.g3d.csg.scenegraph2.CSGrootNode;
import org.simantics.g3d.csg.scenegraph2.ICSGnode;
import org.simantics.utils.ui.ExceptionUtils;

public class AddBooleanOpAction2
extends Action {
    CSGrootNode root;
    Class<? extends CSGparentNode> booleanClass;
    Collection<ICSGnode> nodes;

    public AddBooleanOpAction2(CSGrootNode root, Class<? extends CSGparentNode> booleanClass, Collection<ICSGnode> nodes) {
        String name = booleanClass.getSimpleName();
        if (name.endsWith("Node")) {
            name = name.substring(0, name.length() - 4);
        }
        this.setText(name);
        this.booleanClass = booleanClass;
        this.nodes = nodes;
        this.root = root;
        if (nodes.size() != 2) {
            this.setEnabled(false);
        }
        for (ICSGnode node : nodes) {
            if (node.getParent().equals((Object)root)) continue;
            this.setEnabled(false);
        }
    }

    public void run() {
        try {
            CSGparentNode booleanNode = this.booleanClass.newInstance();
            HashMap<ICSGnode, Vector3d> positions = new HashMap<ICSGnode, Vector3d>();
            HashMap<ICSGnode, Quat4d> orientations = new HashMap<ICSGnode, Quat4d>();
            for (ICSGnode node : this.nodes) {
                positions.put(node, node.getWorldPosition());
                orientations.put(node, node.getWorldOrientation());
                node.deattach();
            }
            Iterator<ICSGnode> iter = this.nodes.iterator();
            booleanNode.addPrimaryChild(iter.next());
            booleanNode.addSecondaryChild(iter.next());
            String name = this.root.getUniqueName(booleanNode.getClass().getSimpleName());
            booleanNode.setName(name);
            this.root.addChild(booleanNode);
            for (ICSGnode node : this.nodes) {
                node.setWorldPosition((Vector3d)positions.get(node));
                node.setWorldOrientation((Quat4d)orientations.get(node));
            }
            this.root.getNodeMap().commit("Add Boolean Op");
        }
        catch (Exception e) {
            ExceptionUtils.logAndShowError((String)"Cannot create boolean operation.", (Throwable)e);
        }
    }
}

