/*******************************************************************************
 * Copyright (c) 2007, 2012 Association for Decentralized Information Management in
 * Industry THTH ry.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *     VTT Technical Research Centre of Finland - initial API and implementation
 *******************************************************************************/
package org.simantics.databoard.example;

import org.simantics.databoard.Bindings;
import org.simantics.databoard.binding.Binding;
import org.simantics.databoard.binding.util.DefaultValue;
import org.simantics.databoard.type.DoubleType;
import org.simantics.databoard.type.RecordType;
import org.simantics.databoard.util.Limit;
import org.simantics.databoard.util.Range;

public class MyTest {

	public static void main(String[] args) {
		
		DoubleType t1 = new DoubleType();
		DoubleType t2 = new DoubleType();
		t2.setUnit("m");
		
		System.out.println( t1.hashCode() );
		System.out.println( t2.hashCode() );
		
		
		RecordType r1 = new RecordType();
		RecordType r2 = new RecordType();
		r1.addComponent("x", t1);
		r2.addComponent("x", t2);
		
		System.out.println( r1.hashCode() );
		System.out.println( r2.hashCode() );
		
		t1.setRange( new Range(Limit.nolimit(), Limit.nolimit()) );
		Binding b = Bindings.getBinding(t1);
		DefaultValue dv = new DefaultValue();
		System.out.println(  b.accept( dv )  );
		
	}
	
}
