/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.utils;

import java.io.File;
import java.io.IOException;
import org.simantics.utils.IOperation;

public interface FileService {
    public IOperation<Boolean, IOException> scheduleDeleteIfExists(File var1, DeleteOption ... var2);

    default public FileOperation deleteOperation(DeleteOption ... options) {
        return new DeleteOperation(this, options);
    }

    public static class DeleteOperation
    implements FileOperation {
        private final FileService service;
        private final DeleteOption[] options;

        public DeleteOperation(FileService service, DeleteOption ... options) {
            this.service = service;
            this.options = options;
        }

        @Override
        public IOperation<Boolean, IOException> perform(File file) {
            return this.service.scheduleDeleteIfExists(file, this.options);
        }
    }

    public static interface DeleteOption {
    }

    public static class EffortOption
    implements DeleteOption {
        public final int maxTries;

        private EffortOption(int maxTries) {
            this.maxTries = maxTries;
        }

        public static EffortOption maxTries(int maxTries) {
            return new EffortOption(maxTries);
        }
    }

    @FunctionalInterface
    public static interface FileOperation {
        public IOperation<Boolean, IOException> perform(File var1);

        default public void perform(File ... files) {
            File[] fileArray = files;
            int n = files.length;
            int n2 = 0;
            while (n2 < n) {
                File f = fileArray[n2];
                this.perform(f);
                ++n2;
            }
        }
    }
}

