/*
 * Decompiled with CFR 0.152.
 */
package org.cojen.util;

import java.lang.ref.Reference;
import java.lang.ref.ReferenceQueue;
import java.lang.ref.WeakReference;
import java.util.AbstractCollection;
import java.util.AbstractMap;
import java.util.AbstractSet;
import java.util.Collection;
import java.util.Collections;
import java.util.ConcurrentModificationException;
import java.util.Iterator;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Set;
import org.cojen.util.ReferencedValueHashMap;

public class WeakIdentityMap<K, V>
extends AbstractMap<K, V>
implements Map<K, V>,
Cloneable {
    static final int KEYS = 0;
    static final int VALUES = 1;
    static final int ENTRIES = 2;
    private transient Entry<K, V>[] table;
    private transient int count;
    private int threshold;
    private final float loadFactor;
    private final ReferenceQueue<K> queue;
    private volatile transient int modCount;
    private transient Set<K> keySet;
    private transient Set<Map.Entry<K, V>> entrySet;
    private transient Collection<V> values;

    static String toString(Collection c) {
        if (c.size() == 0) {
            return "[]";
        }
        StringBuffer buf = new StringBuffer(32 * c.size());
        buf.append('[');
        Iterator it = c.iterator();
        boolean hasNext = it.hasNext();
        while (hasNext) {
            Object obj = it.next();
            buf.append((Object)(obj == c ? "(this Collection)" : obj));
            hasNext = it.hasNext();
            if (!hasNext) continue;
            buf.append(", ");
        }
        buf.append("]");
        return buf.toString();
    }

    static String toString(Map m) {
        if (m.size() == 0) {
            return "{}";
        }
        StringBuffer buf = new StringBuffer(32 * m.size());
        buf.append('{');
        Iterator it = m.entrySet().iterator();
        boolean hasNext = it.hasNext();
        while (hasNext) {
            Map.Entry entry = it.next();
            Object key = entry.getKey();
            Object value = entry.getValue();
            buf.append((Object)(key == m ? "(this Map)" : key)).append('=').append((Object)(value == m ? "(this Map)" : value));
            hasNext = it.hasNext();
            if (!hasNext) continue;
            buf.append(',').append(' ');
        }
        buf.append('}');
        return buf.toString();
    }

    public WeakIdentityMap(int initialCapacity, float loadFactor) {
        if (initialCapacity <= 0) {
            throw new IllegalArgumentException("Initial capacity must be greater than 0");
        }
        if (loadFactor <= 0.0f || Float.isNaN(loadFactor)) {
            throw new IllegalArgumentException("Load factor must be greater than 0");
        }
        this.loadFactor = loadFactor;
        this.table = new Entry[initialCapacity];
        this.threshold = (int)((float)initialCapacity * loadFactor);
        this.queue = new ReferenceQueue();
    }

    public WeakIdentityMap(int initialCapacity) {
        this(initialCapacity, 0.75f);
    }

    public WeakIdentityMap() {
        this(11, 0.75f);
    }

    public WeakIdentityMap(Map<? extends K, ? extends V> t) {
        this(Math.max(2 * t.size(), 11), 0.75f);
        this.putAll(t);
    }

    @Override
    public int size() {
        this.cleanup();
        return this.count;
    }

    @Override
    public boolean isEmpty() {
        return this.count == 0;
    }

    @Override
    public boolean containsValue(Object value) {
        Entry<K, V>[] tab = this.table;
        if (value == null) {
            int i = tab.length;
            while (i-- > 0) {
                Entry<K, V> e = tab[i];
                Entry<K, V> prev = null;
                while (e != null) {
                    if (e.get() == null) {
                        ++this.modCount;
                        if (prev != null) {
                            prev.next = e.next;
                        } else {
                            tab[i] = e.next;
                        }
                        --this.count;
                    } else {
                        if (e.value == null) {
                            return true;
                        }
                        prev = e;
                    }
                    e = e.next;
                }
            }
        } else {
            int i = tab.length;
            while (i-- > 0) {
                Entry<K, V> e = tab[i];
                Entry<K, V> prev = null;
                while (e != null) {
                    if (e.get() == null) {
                        ++this.modCount;
                        if (prev != null) {
                            prev.next = e.next;
                        } else {
                            tab[i] = e.next;
                        }
                        --this.count;
                    } else {
                        if (value.equals(e.value)) {
                            return true;
                        }
                        prev = e;
                    }
                    e = e.next;
                }
            }
        }
        return false;
    }

    @Override
    public boolean containsKey(Object key) {
        if (key == null) {
            key = ReferencedValueHashMap.NULL;
        }
        Entry<K, V>[] tab = this.table;
        int hash = System.identityHashCode(key);
        int index = (hash & Integer.MAX_VALUE) % tab.length;
        Entry<K, V> e = tab[index];
        Entry<K, V> prev = null;
        while (e != null) {
            Object entryKey = e.get();
            if (entryKey == null) {
                ++this.modCount;
                if (prev != null) {
                    prev.next = e.next;
                } else {
                    tab[index] = e.next;
                }
                --this.count;
            } else {
                if (e.hash == hash && key == entryKey) {
                    return true;
                }
                prev = e;
            }
            e = e.next;
        }
        return false;
    }

    @Override
    public V get(Object key) {
        if (key == null) {
            key = ReferencedValueHashMap.NULL;
        }
        Entry<K, V>[] tab = this.table;
        int hash = System.identityHashCode(key);
        int index = (hash & Integer.MAX_VALUE) % tab.length;
        Entry<K, V> e = tab[index];
        Entry<K, V> prev = null;
        while (e != null) {
            Object entryKey = e.get();
            if (entryKey == null) {
                ++this.modCount;
                if (prev != null) {
                    prev.next = e.next;
                } else {
                    tab[index] = e.next;
                }
                --this.count;
            } else {
                if (e.hash == hash && key == entryKey) {
                    return e.value;
                }
                prev = e;
            }
            e = e.next;
        }
        return null;
    }

    private void cleanup() {
        Reference<K> ref;
        Entry<K, V>[] tab = this.table;
        ReferenceQueue<K> queue = this.queue;
        while ((ref = queue.poll()) != null) {
            int index = (((Entry)ref).hash & Integer.MAX_VALUE) % tab.length;
            Entry<K, V> e = tab[index];
            Entry<K, V> prev = null;
            while (e != null) {
                if (e.get() == null) {
                    ++this.modCount;
                    if (prev != null) {
                        prev.next = e.next;
                    } else {
                        tab[index] = e.next;
                    }
                    --this.count;
                } else {
                    prev = e;
                }
                e = e.next;
            }
        }
    }

    private void rehash() {
        int oldCapacity = this.table.length;
        Entry<K, V>[] oldMap = this.table;
        int newCapacity = oldCapacity * 2 + 1;
        if (newCapacity <= 0) {
            newCapacity = Integer.MAX_VALUE;
            if (Integer.MAX_VALUE == oldCapacity) {
                return;
            }
        }
        Entry[] newMap = new Entry[newCapacity];
        ++this.modCount;
        this.threshold = (int)((float)newCapacity * this.loadFactor);
        this.table = newMap;
        int i = oldCapacity;
        while (i-- > 0) {
            Entry<K, V> old = oldMap[i];
            while (old != null) {
                Entry<K, V> e = old;
                old = old.next;
                if (e.get() == null) {
                    --this.count;
                    continue;
                }
                int index = (e.hash & Integer.MAX_VALUE) % newCapacity;
                e.next = newMap[index];
                newMap[index] = e;
            }
        }
    }

    @Override
    public V put(K key, V value) {
        if (key == null) {
            key = ReferencedValueHashMap.NULL;
        }
        this.cleanup();
        Entry<K, V>[] tab = this.table;
        int hash = System.identityHashCode(key);
        int index = (hash & Integer.MAX_VALUE) % tab.length;
        Entry<K, V> e = tab[index];
        Entry<K, V> prev = null;
        while (e != null) {
            Object entryKey = e.get();
            if (entryKey == null) {
                ++this.modCount;
                if (prev != null) {
                    prev.next = e.next;
                } else {
                    tab[index] = e.next;
                }
                --this.count;
            } else {
                if (e.hash == hash && key == entryKey) {
                    Object old = e.value;
                    e.value = value;
                    return old;
                }
                prev = e;
            }
            e = e.next;
        }
        ++this.modCount;
        if (this.count >= this.threshold) {
            this.rehash();
            tab = this.table;
            index = (hash & Integer.MAX_VALUE) % tab.length;
        }
        e = new Entry<K, V>(hash, key, this.queue, value, tab[index]);
        tab[index] = e;
        ++this.count;
        return null;
    }

    @Override
    public V remove(Object key) {
        if (key == null) {
            key = ReferencedValueHashMap.NULL;
        }
        Entry<K, V>[] tab = this.table;
        int hash = System.identityHashCode(key);
        int index = (hash & Integer.MAX_VALUE) % tab.length;
        Entry<K, V> e = tab[index];
        Entry<K, V> prev = null;
        while (e != null) {
            Object entryKey = e.get();
            if (entryKey == null) {
                ++this.modCount;
                if (prev != null) {
                    prev.next = e.next;
                } else {
                    tab[index] = e.next;
                }
                --this.count;
            } else {
                if (e.hash == hash && key == entryKey) {
                    ++this.modCount;
                    if (prev != null) {
                        prev.next = e.next;
                    } else {
                        tab[index] = e.next;
                    }
                    --this.count;
                    Object oldValue = e.value;
                    e.value = null;
                    return oldValue;
                }
                prev = e;
            }
            e = e.next;
        }
        return null;
    }

    @Override
    public void putAll(Map<? extends K, ? extends V> t) {
        for (Map.Entry<K, V> e : t.entrySet()) {
            this.put(e.getKey(), e.getValue());
        }
    }

    @Override
    public void clear() {
        Entry<K, V>[] tab = this.table;
        ++this.modCount;
        int index = tab.length;
        while (--index >= 0) {
            tab[index] = null;
        }
        this.count = 0;
    }

    @Override
    public Object clone() {
        try {
            WeakIdentityMap t = (WeakIdentityMap)super.clone();
            t.table = new Entry[this.table.length];
            int i = this.table.length;
            while (i-- > 0) {
                Entry<K, V> entry = t.table[i] = this.table[i] != null ? (Entry<K, V>)this.table[i].copy(this.queue) : null;
            }
            t.keySet = null;
            t.entrySet = null;
            t.values = null;
            t.modCount = 0;
            return t;
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            throw new InternalError();
        }
    }

    @Override
    public Set<K> keySet() {
        if (this.keySet == null) {
            this.keySet = new AbstractSet<K>(){

                @Override
                public Iterator iterator() {
                    return WeakIdentityMap.this.createHashIterator(0);
                }

                @Override
                public int size() {
                    return WeakIdentityMap.this.count;
                }

                @Override
                public boolean contains(Object o) {
                    return WeakIdentityMap.this.containsKey(o);
                }

                @Override
                public boolean remove(Object o) {
                    return o == null ? false : WeakIdentityMap.this.remove(o) == o;
                }

                @Override
                public void clear() {
                    WeakIdentityMap.this.clear();
                }

                @Override
                public String toString() {
                    return WeakIdentityMap.toString(this);
                }
            };
        }
        return this.keySet;
    }

    @Override
    public Collection<V> values() {
        if (this.values == null) {
            this.values = new AbstractCollection<V>(){

                @Override
                public Iterator<V> iterator() {
                    return WeakIdentityMap.this.createHashIterator(1);
                }

                @Override
                public int size() {
                    return WeakIdentityMap.this.count;
                }

                @Override
                public boolean contains(Object o) {
                    return WeakIdentityMap.this.containsValue(o);
                }

                @Override
                public void clear() {
                    WeakIdentityMap.this.clear();
                }

                @Override
                public String toString() {
                    return WeakIdentityMap.toString(this);
                }
            };
        }
        return this.values;
    }

    @Override
    public Set<Map.Entry<K, V>> entrySet() {
        if (this.entrySet == null) {
            this.entrySet = new AbstractSet<Map.Entry<K, V>>(){

                @Override
                public Iterator<Map.Entry<K, V>> iterator() {
                    return WeakIdentityMap.this.createHashIterator(2);
                }

                @Override
                public boolean contains(Object o) {
                    if (!(o instanceof Map.Entry)) {
                        return false;
                    }
                    Map.Entry entry = (Map.Entry)o;
                    Object key = entry.getKey();
                    Entry<K, V>[] tab = WeakIdentityMap.this.table;
                    int hash = System.identityHashCode(key);
                    int index = (hash & Integer.MAX_VALUE) % tab.length;
                    Entry e = tab[index];
                    Entry prev = null;
                    while (e != null) {
                        Object entryKey = e.get();
                        if (entryKey == null) {
                            ++WeakIdentityMap.this.modCount;
                            if (prev != null) {
                                prev.next = e.next;
                            } else {
                                tab[index] = e.next;
                            }
                            --WeakIdentityMap.this.count;
                        } else {
                            if (e.hash == hash && e.equals(entry)) {
                                return true;
                            }
                            prev = e;
                        }
                        e = e.next;
                    }
                    return false;
                }

                @Override
                public boolean remove(Object o) {
                    if (!(o instanceof Map.Entry)) {
                        return false;
                    }
                    Map.Entry entry = (Map.Entry)o;
                    Object key = entry.getKey();
                    Entry<K, V>[] tab = WeakIdentityMap.this.table;
                    int hash = System.identityHashCode(key);
                    int index = (hash & Integer.MAX_VALUE) % tab.length;
                    Entry e = tab[index];
                    Entry prev = null;
                    while (e != null) {
                        if (e.get() == null) {
                            ++WeakIdentityMap.this.modCount;
                            if (prev != null) {
                                prev.next = e.next;
                            } else {
                                tab[index] = e.next;
                            }
                            --WeakIdentityMap.this.count;
                        } else {
                            if (e.hash == hash && e.equals(entry)) {
                                ++WeakIdentityMap.this.modCount;
                                if (prev != null) {
                                    prev.next = e.next;
                                } else {
                                    tab[index] = e.next;
                                }
                                --WeakIdentityMap.this.count;
                                e.value = null;
                                return true;
                            }
                            prev = e;
                        }
                        e = e.next;
                    }
                    return false;
                }

                @Override
                public int size() {
                    return WeakIdentityMap.this.count;
                }

                @Override
                public void clear() {
                    WeakIdentityMap.this.clear();
                }

                @Override
                public String toString() {
                    return WeakIdentityMap.toString(this);
                }
            };
        }
        return this.entrySet;
    }

    @Override
    public String toString() {
        return WeakIdentityMap.toString(this);
    }

    private Iterator createHashIterator(int type) {
        if (this.count == 0) {
            return Collections.EMPTY_SET.iterator();
        }
        return new HashIterator(type);
    }

    private static class Entry<K, V>
    extends WeakReference<K>
    implements Map.Entry<K, V> {
        int hash;
        V value;
        Entry<K, V> next;

        Entry(int hash, K key, ReferenceQueue<K> queue, V value, Entry<K, V> next) {
            super(key, queue);
            this.hash = hash;
            this.value = value;
            this.next = next;
        }

        @Override
        public void clear() {
        }

        @Override
        public K getKey() {
            Object key = this.get();
            return key == ReferencedValueHashMap.NULL ? null : (K)key;
        }

        @Override
        public V getValue() {
            return this.value;
        }

        @Override
        public V setValue(V value) {
            V oldValue = this.value;
            this.value = value;
            return oldValue;
        }

        @Override
        public boolean equals(Object obj) {
            if (!(obj instanceof Map.Entry)) {
                return false;
            }
            return this.equals((Map.Entry)obj);
        }

        boolean equals(Map.Entry<K, V> e) {
            Object thisKey = this.get();
            if (thisKey == null) {
                return false;
            }
            if (thisKey == ReferencedValueHashMap.NULL) {
                thisKey = null;
            }
            return thisKey == e.getKey() && (this.value == null ? e.getValue() == null : this.value.equals(e.getValue()));
        }

        @Override
        public int hashCode() {
            return this.hash ^ (this.value == null ? 0 : this.value.hashCode());
        }

        public String toString() {
            return this.getKey() + "=" + this.value;
        }

        protected Object copy(ReferenceQueue queue) {
            return new Entry(this.hash, this.get(), queue, this.value, this.next == null ? null : (Entry)this.next.copy(queue));
        }
    }

    private class HashIterator
    implements Iterator {
        private final int type;
        private final Entry[] table;
        private int index;
        Object entryKey;
        Entry entry;
        Entry last;
        private int expectedModCount;

        HashIterator(int type) {
            this.expectedModCount = WeakIdentityMap.this.modCount;
            this.table = WeakIdentityMap.this.table;
            this.type = type;
            this.index = this.table.length;
        }

        @Override
        public boolean hasNext() {
            while (this.entry == null || (this.entryKey = this.entry.get()) == null) {
                if (this.entry != null) {
                    this.remove(this.entry);
                    this.entry = this.entry.next;
                    continue;
                }
                if (this.index <= 0) {
                    return false;
                }
                this.entry = this.table[--this.index];
            }
            return true;
        }

        public Object next() {
            if (WeakIdentityMap.this.modCount != this.expectedModCount) {
                throw new ConcurrentModificationException();
            }
            if (!this.hasNext()) {
                throw new NoSuchElementException();
            }
            this.last = this.entry;
            this.entry = this.entry.next;
            return this.type == 0 ? this.last.getKey() : (this.type == 1 ? this.last.getValue() : this.last);
        }

        @Override
        public void remove() {
            if (this.last == null) {
                throw new IllegalStateException();
            }
            if (WeakIdentityMap.this.modCount != this.expectedModCount) {
                throw new ConcurrentModificationException();
            }
            this.remove(this.last);
            this.last = null;
        }

        private void remove(Entry toRemove) {
            Entry[] tab = this.table;
            int index = (toRemove.hash & Integer.MAX_VALUE) % tab.length;
            Entry e = tab[index];
            Entry prev = null;
            while (e != null) {
                if (e == toRemove) {
                    ++WeakIdentityMap.this.modCount;
                    ++this.expectedModCount;
                    if (prev == null) {
                        tab[index] = e.next;
                    } else {
                        prev.next = e.next;
                    }
                    --WeakIdentityMap.this.count;
                    return;
                }
                prev = e;
                e = e.next;
            }
            throw new ConcurrentModificationException();
        }

        public String toString() {
            if (this.last != null) {
                return "Iterator[" + this.last + ']';
            }
            return "Iterator[]";
        }
    }
}

