/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.utils.threads.internal;

public final class Pair<T1, T2> {
    public final T1 first;
    public final T2 second;
    private final int hash;

    public Pair(T1 first, T2 second) {
        assert (first != null);
        assert (second != null);
        this.first = first;
        this.second = second;
        this.hash = this.makeHash();
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (!obj.getClass().equals(this.getClass())) {
            return false;
        }
        Pair other = (Pair)obj;
        if (other.first != this.first && !other.first.equals(this.first)) {
            return false;
        }
        return other.second == this.second || other.second.equals(this.second);
    }

    public int hashCode() {
        return this.hash;
    }

    public String toString() {
        return "<" + this.first + ", " + this.second + ">";
    }

    private int makeHash() {
        return this.first.hashCode() ^ this.second.hashCode() * 7;
    }
}

