/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.scl.runtime.generation;

import java.io.File;
import java.io.FileOutputStream;
import java.io.PrintStream;
import java.net.URL;
import org.simantics.scl.runtime.generation.GenerateFunctions;

public class GenerateTuples {
    public static final String PACKAGE = "org.simantics.scl.runtime.tuple";
    public static final int MAX_ARITY = 32;
    public static final String HEADER = "/**\n * This code is generated in " + GenerateTuples.class.getName() + ".\n" + " * Do not edit manually!\n" + " */";

    private static void generateTupleN(PrintStream p, int n) {
        p.println(HEADER);
        p.println("package org.simantics.scl.runtime.tuple;");
        p.println();
        p.println("public class Tuple" + n + " implements Tuple {");
        int i = 0;
        while (i < n) {
            p.println("    public final Object c" + i + ";");
            ++i;
        }
        p.println();
        p.print("    public Tuple" + n + "(");
        i = 0;
        while (i < n) {
            if (i > 0) {
                p.print(", ");
            }
            p.print("Object c" + i);
            ++i;
        }
        p.println(") {");
        i = 0;
        while (i < n) {
            p.println("        this.c" + i + " = c" + i + ";");
            ++i;
        }
        p.println("    }");
        p.println();
        p.println("    public int length() {");
        p.println("        return " + n + ";");
        p.println("    }");
        p.println();
        p.println("    public Object get(int id) {");
        p.println("        switch(id) {");
        i = 0;
        while (i < n) {
            p.println("        case " + i + ": return c" + i + ";");
            ++i;
        }
        p.println("        default: throw new IndexOutOfBoundsException();");
        p.println("        }");
        p.println("    }");
        p.println();
        p.println("    public Object[] toArray() {");
        p.print("        return new Object[] { ");
        i = 0;
        while (i < n) {
            if (i > 0) {
                p.print(", ");
            }
            p.print("c" + i);
            ++i;
        }
        p.println(" };");
        p.println("    }");
        p.println();
        p.println("    @Override");
        p.println("    public boolean equals(Object obj) {");
        p.println("        if(obj == this)");
        p.println("            return true;");
        p.println("        if(obj == null || obj.getClass() != getClass())");
        p.println("            return false;");
        p.println("        Tuple" + n + " tuple = (Tuple" + n + ")obj;");
        i = 0;
        while (i < n) {
            p.println("        if(c" + i + " == null) {");
            p.println("            if(tuple.c" + i + " != null)");
            p.println("                return false;");
            p.println("        }");
            p.println("        else if(!c" + i + ".equals(tuple.c" + i + "))");
            p.println("            return false;");
            ++i;
        }
        p.println("        return true;");
        p.println("    }");
        p.println();
        p.println("    @Override");
        p.println("    public int hashCode() {");
        p.println("        int result = c0 == null ? 0 : c0.hashCode();");
        i = 1;
        while (i < n) {
            p.println("        result *= 31;");
            p.println("        if(c" + i + " != null)");
            p.println("            result += c" + i + ".hashCode();");
            ++i;
        }
        p.println("        return result;");
        p.println("    }");
        p.println();
        p.println("    @Override");
        p.println("    public String toString() {");
        p.println("        StringBuilder b = new StringBuilder();");
        p.println("        b.append('(');");
        i = 0;
        while (i < n) {
            if (i > 0) {
                p.println("        b.append(',');");
            }
            p.println("        b.append(c" + i + ");");
            ++i;
        }
        p.println("        b.append(')');");
        p.println("        return b.toString();");
        p.println("    }");
        p.println("}");
    }

    public static void main(String[] args) throws Exception {
        URL url = GenerateFunctions.class.getResource(".");
        File dir = new File(url.getPath());
        while (!new File(dir, "src").exists()) {
            dir = dir.getParentFile();
        }
        dir = new File(dir, "src");
        dir = new File(dir, PACKAGE.replace('.', '/'));
        dir.mkdirs();
        int n = 2;
        while (n <= 32) {
            PrintStream ps = new PrintStream(new FileOutputStream(new File(dir, "Tuple" + n + ".java")));
            GenerateTuples.generateTupleN(ps, n);
            ++n;
        }
    }
}

