/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.scl.compiler.runtime;

import java.lang.reflect.Array;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.simantics.databoard.binding.mutable.Variant;
import org.simantics.scl.compiler.types.TApply;
import org.simantics.scl.compiler.types.TCon;
import org.simantics.scl.compiler.types.Type;
import org.simantics.scl.compiler.types.Types;

public class ValueConversion {
    public static Number convertNumber(TCon expectedType, Number value) {
        if (expectedType == Types.DOUBLE) {
            if (value instanceof Double) {
                return value;
            }
            return new Double(value.doubleValue());
        }
        if (expectedType == Types.INTEGER) {
            if (value instanceof Integer) {
                return value;
            }
            return new Integer(value.intValue());
        }
        if (expectedType == Types.FLOAT) {
            if (value instanceof Float) {
                return value;
            }
            return new Float(value.floatValue());
        }
        if (expectedType == Types.BYTE) {
            if (value instanceof Byte) {
                return value;
            }
            return new Byte(value.byteValue());
        }
        if (expectedType == Types.SHORT) {
            if (value instanceof Short) {
                return value;
            }
            return new Short(value.shortValue());
        }
        if (expectedType == Types.LONG) {
            if (value instanceof Long) {
                return value;
            }
            return new Long(value.longValue());
        }
        return value;
    }

    public static Object parsePrimitive(TCon expectedType, String value) {
        if (expectedType == Types.DOUBLE) {
            return Double.parseDouble(value);
        }
        if (expectedType == Types.INTEGER) {
            return Integer.parseInt(value);
        }
        if (expectedType == Types.FLOAT) {
            return Float.valueOf(Float.parseFloat(value));
        }
        if (expectedType == Types.BYTE) {
            return Byte.parseByte(value);
        }
        if (expectedType == Types.SHORT) {
            return Short.parseShort(value);
        }
        if (expectedType == Types.LONG) {
            return Long.parseLong(value);
        }
        if (expectedType == Types.BOOLEAN) {
            return Boolean.parseBoolean(value);
        }
        if (expectedType == Types.CHARACTER && value.length() == 1) {
            return Character.valueOf(value.charAt(0));
        }
        return value;
    }

    public static Class<?> getNativeClass(Type expectedType) {
        if (expectedType == Types.STRING) {
            return String.class;
        }
        if (expectedType == Types.DOUBLE) {
            return Double.class;
        }
        if (expectedType == Types.INTEGER) {
            return Integer.class;
        }
        if (expectedType == Types.FLOAT) {
            return Float.class;
        }
        if (expectedType == Types.BYTE) {
            return Byte.class;
        }
        if (expectedType == Types.SHORT) {
            return Short.class;
        }
        if (expectedType == Types.LONG) {
            return Long.class;
        }
        if (expectedType == Types.BOOLEAN) {
            return Boolean.class;
        }
        if (expectedType == Types.CHARACTER) {
            return Character.class;
        }
        return Object.class;
    }

    public static Class<?> getNativePrimitiveClass(Type expectedType) {
        if (expectedType == Types.STRING) {
            return String.class;
        }
        if (expectedType == Types.DOUBLE) {
            return Double.TYPE;
        }
        if (expectedType == Types.INTEGER) {
            return Integer.TYPE;
        }
        if (expectedType == Types.FLOAT) {
            return Float.TYPE;
        }
        if (expectedType == Types.BYTE) {
            return Byte.TYPE;
        }
        if (expectedType == Types.SHORT) {
            return Short.TYPE;
        }
        if (expectedType == Types.LONG) {
            return Long.TYPE;
        }
        if (expectedType == Types.BOOLEAN) {
            return Boolean.TYPE;
        }
        if (expectedType == Types.CHARACTER) {
            return Character.TYPE;
        }
        return Object.class;
    }

    public static boolean needsConversion(Type expectedType, Object value) {
        if (!ValueConversion.needsConversion(expectedType, value.getClass(), false)) {
            return false;
        }
        if (expectedType instanceof TApply) {
            TApply apply = (TApply)expectedType;
            if (apply.function == Types.LIST) {
                if (!(value instanceof List)) {
                    return true;
                }
                for (Object item : (List)value) {
                    if (!ValueConversion.needsConversion(apply.parameter, item)) continue;
                    return true;
                }
                return false;
            }
        }
        return true;
    }

    public static boolean needsConversion(Type expectedType, Class<?> clazz, boolean needPrimitive) {
        if (expectedType instanceof TCon) {
            if (needPrimitive && Types.isPrimitive(expectedType)) {
                Class<?> expectedClass = ValueConversion.getNativePrimitiveClass(expectedType);
                if (expectedClass.isPrimitive()) {
                    return clazz == expectedClass;
                }
                return expectedClass.isAssignableFrom(clazz);
            }
            if (clazz.isPrimitive()) {
                return true;
            }
            return !ValueConversion.getNativeClass(expectedType).isAssignableFrom(clazz);
        }
        if (expectedType instanceof TApply) {
            TApply apply = (TApply)expectedType;
            if (apply.function == Types.LIST) {
                return true;
            }
            if (apply.function == Types.VECTOR || apply.function == Types.MVECTOR || apply.function == Types.ARRAY) {
                if (!clazz.isArray()) {
                    return true;
                }
                boolean needPrimitive2 = apply.function != Types.ARRAY;
                return ValueConversion.needsConversion(apply.parameter, clazz.getComponentType(), needPrimitive2);
            }
        }
        return false;
    }

    public static Object fromDynamic(Type expectedType, Object value) {
        if (value == null) {
            return null;
        }
        if (value instanceof Variant) {
            return ValueConversion.fromDynamic(expectedType, ((Variant)value).getValue());
        }
        if (expectedType == Types.DYNAMIC) {
            return value;
        }
        if (!ValueConversion.needsConversion(expectedType, value)) {
            return value;
        }
        if (expectedType instanceof TCon) {
            TCon con = (TCon)expectedType;
            if (con == Types.STRING) {
                return value.toString();
            }
            if (value instanceof Number) {
                return ValueConversion.convertNumber(con, (Number)value);
            }
            if (value instanceof String && Types.isPrimitive(con)) {
                return ValueConversion.parsePrimitive(con, (String)value);
            }
        } else if (expectedType instanceof TApply) {
            TApply apply = (TApply)expectedType;
            Type expectedComponentType = apply.parameter;
            if (apply.function == Types.LIST) {
                Class<?> valueClass = value.getClass();
                if (valueClass.isArray()) {
                    Class<?> componentType = valueClass.getComponentType();
                    if (ValueConversion.needsConversion(expectedComponentType, componentType, false)) {
                        int length = Array.getLength(value);
                        ArrayList<Object> list = new ArrayList<Object>(length);
                        int i = 0;
                        while (i < length) {
                            list.add(ValueConversion.fromDynamic(expectedComponentType, Array.get(value, i)));
                            ++i;
                        }
                        return list;
                    }
                    return Arrays.asList((Object[])value);
                }
                if (value instanceof Iterable) {
                    Iterable iterable = (Iterable)value;
                    ArrayList<Object> list = new ArrayList<Object>();
                    for (Object element : iterable) {
                        list.add(ValueConversion.fromDynamic(expectedComponentType, element));
                    }
                    return list;
                }
            } else if (apply.function == Types.VECTOR || apply.function == Types.MVECTOR || apply.function == Types.ARRAY) {
                Class<?> expectedComponentClass;
                Class<?> valueClass = value.getClass();
                Class<?> clazz = expectedComponentClass = apply.function != Types.ARRAY ? ValueConversion.getNativePrimitiveClass(expectedComponentType) : ValueConversion.getNativeClass(expectedComponentType);
                if (valueClass.isArray()) {
                    Class<?> componentType = valueClass.getComponentType();
                    int length = Array.getLength(value);
                    Object array = Array.newInstance(expectedComponentClass, length);
                    if (ValueConversion.needsConversion(expectedComponentType, componentType, apply.function != Types.ARRAY)) {
                        int i = 0;
                        while (i < length) {
                            Array.set(array, i, ValueConversion.fromDynamic(expectedComponentType, Array.get(value, i)));
                            ++i;
                        }
                        return array;
                    }
                    return value;
                }
                if (value instanceof Iterable) {
                    ArrayList<Object> list = new ArrayList<Object>();
                    for (Object item : (Iterable)value) {
                        list.add(ValueConversion.fromDynamic(expectedComponentType, item));
                    }
                    if (apply.function != Types.ARRAY && expectedComponentClass.isPrimitive()) {
                        int length = list.size();
                        Object array = Array.newInstance(expectedComponentClass, length);
                        int i = 0;
                        while (i < length) {
                            Array.set(array, i, list.get(i));
                            ++i;
                        }
                        return array;
                    }
                    return list.toArray();
                }
            }
        }
        return value;
    }
}

