/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.scl.compiler.internal.elaboration.transformations;

import gnu.trove.map.hash.THashMap;
import gnu.trove.set.hash.THashSet;
import java.util.ArrayList;
import org.simantics.scl.compiler.common.exceptions.InternalCompilerError;
import org.simantics.scl.compiler.common.names.Names;
import org.simantics.scl.compiler.constants.Constant;
import org.simantics.scl.compiler.constants.StringConstant;
import org.simantics.scl.compiler.elaboration.contexts.EnvironmentalContext;
import org.simantics.scl.compiler.elaboration.contexts.TypingContext;
import org.simantics.scl.compiler.elaboration.expressions.EApply;
import org.simantics.scl.compiler.elaboration.expressions.EConstant;
import org.simantics.scl.compiler.elaboration.expressions.ELambda;
import org.simantics.scl.compiler.elaboration.expressions.ELiteral;
import org.simantics.scl.compiler.elaboration.expressions.ESimpleLet;
import org.simantics.scl.compiler.elaboration.expressions.EVariable;
import org.simantics.scl.compiler.elaboration.expressions.Expression;
import org.simantics.scl.compiler.elaboration.expressions.Expressions;
import org.simantics.scl.compiler.elaboration.expressions.Variable;
import org.simantics.scl.compiler.elaboration.expressions.VariableProcedure;
import org.simantics.scl.compiler.elaboration.expressions.block.LetStatement;
import org.simantics.scl.compiler.elaboration.expressions.block.Statement;
import org.simantics.scl.compiler.elaboration.modules.SCLValue;
import org.simantics.scl.compiler.internal.codegen.references.IVal;
import org.simantics.scl.compiler.internal.types.HashCodeUtils;
import org.simantics.scl.compiler.types.TCon;
import org.simantics.scl.compiler.types.Type;
import org.simantics.scl.compiler.types.Types;
import org.simantics.scl.compiler.types.exceptions.MatchException;
import org.simantics.scl.compiler.types.util.MultiApply;
import org.simantics.scl.compiler.types.util.MultiFunction;

public class UnifiableFactory {
    private final TypingContext context;
    private final ArrayList<Statement> mappingStatements;
    private THashMap<Type, Variable> defaultGenerators = new THashMap();
    private THashMap<Constructor, Variable> constructorTags = new THashMap();

    public UnifiableFactory(TypingContext context, ArrayList<Statement> phase2Statements) {
        this.context = context;
        this.mappingStatements = phase2Statements;
    }

    private Expression toUnifiable(THashSet<Variable> variableSet, THashMap<Variable, Variable> uniVariableMap, Expression expression) {
        UnifiableRep rep = this.toUnifiableRep(variableSet, uniVariableMap, expression);
        return rep.toExpression();
    }

    private UnifiableRep toUnifiableRep(final THashSet<Variable> variableSet, THashMap<Variable, Variable> uniVariableMap, Expression expression) {
        Expression[] parameters;
        int arity;
        Constant constant;
        int constructorTag;
        EConstant function;
        IVal val;
        EApply apply;
        if (expression instanceof EVariable) {
            Variable variable = ((EVariable)expression).getVariable();
            if (!variableSet.contains((Object)variable)) {
                return new ConstantRep(expression);
            }
            Variable uniVariable = (Variable)uniVariableMap.get((Object)variable);
            if (uniVariable != null) {
                return new UniRep(new EVariable(uniVariable));
            }
            return new UniRep(Expressions.apply((EnvironmentalContext)this.context.getCompilationContext(), (Type)Types.PROC, Names.Unifiable_uVar, variable.getType(), Expressions.punit()));
        }
        if (expression instanceof EApply && (apply = (EApply)expression).getFunction() instanceof EConstant && (val = (function = (EConstant)apply.getFunction()).getValue().getValue()) instanceof Constant && (constructorTag = (constant = (Constant)val).constructorTag()) >= 0 && (arity = constant.getArity()) == (parameters = apply.getParameters()).length) {
            UnifiableRep uRep;
            boolean hasUnifiableParameter = false;
            boolean hasPendingParameter = false;
            UnifiableRep[] uniParameters = new UnifiableRep[arity];
            int i = 0;
            while (i < arity) {
                uniParameters[i] = uRep = this.toUnifiableRep(variableSet, uniVariableMap, parameters[i]);
                if (uRep instanceof UniRep) {
                    hasUnifiableParameter = true;
                } else if (uRep instanceof PendingRep) {
                    hasPendingParameter = true;
                }
                ++i;
            }
            if (hasUnifiableParameter) {
                Expression[] tupleParameters = new Expression[arity];
                int i2 = 0;
                while (i2 < arity) {
                    tupleParameters[i2] = uniParameters[i2].toExpression();
                    ++i2;
                }
                Expression tuple = Expressions.tuple(tupleParameters);
                return new UniRep(Expressions.apply((EnvironmentalContext)this.context.getCompilationContext(), (Type)Types.NO_EFFECTS, Names.Unifiable_uCons, expression.getType(), tuple.getType(), this.getTag(function), tuple));
            }
            if (hasPendingParameter) {
                THashSet dependences = new THashSet();
                UnifiableRep[] unifiableRepArray = uniParameters;
                int n = uniParameters.length;
                int n2 = 0;
                while (n2 < n) {
                    uRep = unifiableRepArray[n2];
                    if (uRep instanceof PendingRep) {
                        dependences.addAll(((PendingRep)uRep).dependences);
                    }
                    ++n2;
                }
                return new PendingRep((THashSet<Variable>)dependences, uniVariableMap, expression);
            }
            return new ConstantRep(expression);
        }
        final THashSet dependences = new THashSet();
        expression.forVariableUses(new VariableProcedure(){

            @Override
            public void execute(long location, Variable variable) {
                if (variableSet.contains((Object)variable)) {
                    dependences.add((Object)variable);
                }
            }
        });
        if (dependences.isEmpty()) {
            return new ConstantRep(expression);
        }
        return new PendingRep((THashSet<Variable>)dependences, uniVariableMap, expression);
    }

    private Expression getTag(EConstant constructorExpr) {
        Constructor key = new Constructor(constructorExpr.getValue(), constructorExpr.getTypeParameters());
        Variable tag = (Variable)this.constructorTags.get((Object)key);
        if (tag == null) {
            Expression destructor;
            MultiFunction mfun;
            SCLValue sclValue = constructorExpr.getValue();
            Constant constant = (Constant)sclValue.getValue();
            int arity = constant.getArity();
            int constructorTag = constant.constructorTag();
            try {
                mfun = Types.matchFunction(constructorExpr.getType(), arity);
            }
            catch (MatchException e) {
                throw new InternalCompilerError(e);
            }
            Type[] uniParameterTypes = new Type[arity];
            int i = 0;
            while (i < arity) {
                uniParameterTypes[i] = Types.apply((Type)Names.Unifiable_Unifiable, mfun.parameterTypes[i]);
                ++i;
            }
            Type tupleType = Types.tuple(uniParameterTypes);
            if (sclValue.getName().module.equals("Builtin") && sclValue.getName().name.charAt(0) == '(') {
                destructor = Expressions.constant(this.context.getCompilationContext(), Names.JavaBuiltin_unsafeCoerce, mfun.returnType, tupleType);
            } else {
                Variable[] parameters = new Variable[arity];
                int i2 = 0;
                while (i2 < arity) {
                    parameters[i2] = new Variable("p" + i2, mfun.parameterTypes[i2]);
                    ++i2;
                }
                EApply pattern = new EApply(constructorExpr.copy(this.context), Expressions.vars(parameters));
                Expression[] tupleParameters = new Expression[arity];
                int i3 = 0;
                while (i3 < arity) {
                    tupleParameters[i3] = Expressions.apply((EnvironmentalContext)this.context.getCompilationContext(), (Type)Types.NO_EFFECTS, Names.Unifiable_uId, parameters[i3].getType(), Expressions.var(parameters[i3]));
                    ++i3;
                }
                Expression value = Expressions.tuple(tupleParameters);
                destructor = new ELambda(9223372034707292160L, pattern, value);
            }
            Variable[] parameters = new Variable[arity];
            int i4 = 0;
            while (i4 < arity) {
                parameters[i4] = new Variable("p" + i4, uniParameterTypes[i4]);
                ++i4;
            }
            Expression pattern = Expressions.tuple(Expressions.vars(parameters));
            Expression[] constructorParameters = new Expression[arity];
            int i5 = 0;
            while (i5 < arity) {
                constructorParameters[i5] = this.extract(mfun.parameterTypes[i5], Expressions.var(parameters[i5]));
                ++i5;
            }
            EApply value = new EApply(constructorExpr.copy(this.context), constructorParameters);
            ELambda constructor = new ELambda(9223372034707292160L, pattern, value);
            tag = new Variable("tag", Types.apply((Type)Names.Unifiable_UTag, mfun.returnType, tupleType));
            this.mappingStatements.add(new LetStatement(new EVariable(tag), Expressions.apply((EnvironmentalContext)this.context.getCompilationContext(), (Type)Types.NO_EFFECTS, Names.Unifiable_uTag, tupleType, mfun.returnType, Expressions.integer(constructorTag), constructor, destructor)));
            this.constructorTags.put((Object)key, (Object)tag);
        }
        return new EVariable(tag);
    }

    private Expression extract(Type type, Expression uni) {
        return Expressions.apply((EnvironmentalContext)this.context.getCompilationContext(), (Type)Types.PROC, Names.Unifiable_extractWithDefault, type, this.getDefaultGenerator(type), uni);
    }

    private Expression getDefaultGenerator(Type type) {
        Variable generator = (Variable)this.defaultGenerators.get((Object)type);
        if (generator == null) {
            generator = new Variable("defGen", Types.functionE(Types.PUNIT, (Type)Types.PROC, type));
            this.mappingStatements.add(new LetStatement(new EVariable(generator), Expressions.computation(Types.PROC, this.createGenerationExpression(type))));
            this.defaultGenerators.put((Object)type, (Object)generator);
        }
        return new EVariable(generator);
    }

    private Expression createGenerationExpression(Type type) {
        MultiApply apply = Types.matchApply(type);
        if (apply.constructor instanceof TCon) {
            if (apply.constructor.equals(Types.RESOURCE)) {
                return Expressions.apply((EnvironmentalContext)this.context.getCompilationContext(), (Type)Types.PROC, Names.Simantics_DB_newResource, Expressions.tuple());
            }
            if (apply.constructor.equals(Types.STRING)) {
                return new ELiteral(new StringConstant(""));
            }
            if (apply.constructor.equals(Names.Data_XML_Element)) {
                return Expressions.apply((EnvironmentalContext)this.context.getCompilationContext(), (Type)Types.PROC, Names.Data_XML_createElement, Expressions.string("NO-NAME"));
            }
            TCon con = (TCon)apply.constructor;
            if (con.name.charAt(0) == '(') {
                int arity = con.name.length() - 1;
                if (arity == 1) {
                    arity = 0;
                }
                if (arity != apply.parameters.length) {
                    throw new InternalCompilerError();
                }
                Expression[] parameters = new Expression[arity];
                int i = 0;
                while (i < arity) {
                    parameters[i] = new EApply(9223372034707292160L, Types.PROC, this.getDefaultGenerator(apply.parameters[i]), Expressions.punit());
                    ++i;
                }
                return Expressions.tuple(parameters);
            }
        }
        return Expressions.apply((EnvironmentalContext)this.context.getCompilationContext(), (Type)Types.NO_EFFECTS, Names.Builtin_fail, new ELiteral(new StringConstant("Cannot generated default instance for type " + type + ".")));
    }

    public Expression generateDefaultValue(Type type) {
        return Expressions.apply(Types.PROC, this.getDefaultGenerator(type), Expressions.punit());
    }

    public Expression getFromUMap(Expression umap, Expression key, Type valueType) {
        return Expressions.apply((EnvironmentalContext)this.context.getCompilationContext(), (Type)Types.PROC, Names.Unifiable_getUMapWithDefault, valueType, key.getType(), this.getDefaultGenerator(valueType), umap, key);
    }

    public Expression putToUMapUnifiable(THashSet<Variable> variableSet, THashMap<Variable, Variable> uniVariableMap, Expression umap, Expression key, Expression value) {
        return Expressions.apply((EnvironmentalContext)this.context.getCompilationContext(), (Type)Types.PROC, Names.Unifiable_putUMap, key.getType(), value.getType(), umap, key, this.toUnifiable(variableSet, uniVariableMap, value));
    }

    public Expression putToUMapConstant(Variable umap, Expression key, Expression value) {
        return Expressions.apply((EnvironmentalContext)this.context.getCompilationContext(), (Type)Types.PROC, Names.Unifiable_putUMapC, key.getType(), value.getType(), Expressions.var(umap), key, value);
    }

    class ConstantRep
    implements UnifiableRep {
        final Expression constant;

        public ConstantRep(Expression constant) {
            this.constant = constant;
        }

        @Override
        public Expression toExpression() {
            return Expressions.apply((EnvironmentalContext)UnifiableFactory.this.context.getCompilationContext(), (Type)Types.NO_EFFECTS, Names.Unifiable_uId, this.constant.getType(), this.constant);
        }
    }

    private static class Constructor {
        final SCLValue function;
        final Type[] typeParameters;
        private int hashCode;

        public Constructor(SCLValue function, Type[] typeParameters) {
            this.function = function;
            this.typeParameters = typeParameters;
        }

        public boolean equals(Object obj) {
            if (obj == this) {
                return true;
            }
            if (obj == null || obj.getClass() != Constructor.class) {
                return false;
            }
            Constructor other = (Constructor)obj;
            if (this.function != other.function) {
                return false;
            }
            return Types.equals(this.typeParameters, other.typeParameters);
        }

        public int hashCode() {
            if (this.hashCode == 0) {
                int hash = 0;
                hash = HashCodeUtils.update(hash, this.function.hashCode());
                Type[] typeArray = this.typeParameters;
                int n = this.typeParameters.length;
                int n2 = 0;
                while (n2 < n) {
                    Type typeParameter = typeArray[n2];
                    hash = typeParameter.hashCode(hash);
                    ++n2;
                }
                this.hashCode = hash;
            }
            return this.hashCode;
        }
    }

    class PendingRep
    implements UnifiableRep {
        final THashSet<Variable> dependences;
        final THashMap<Variable, Variable> uniVariableMap;
        final Expression value;

        public PendingRep(THashSet<Variable> dependences, THashMap<Variable, Variable> uniVariableMap, Expression value) {
            this.dependences = dependences;
            this.uniVariableMap = uniVariableMap;
            this.value = value;
        }

        @Override
        public Expression toExpression() {
            Expression expression = this.value;
            for (Variable variable : this.dependences) {
                expression = new ESimpleLet(variable, UnifiableFactory.this.extract(variable.getType(), Expressions.var((Variable)this.uniVariableMap.get((Object)variable))), expression);
            }
            return Expressions.apply((EnvironmentalContext)UnifiableFactory.this.context.getCompilationContext(), (Type)Types.NO_EFFECTS, Names.Unifiable_uPending, this.value.getType(), Expressions.computation(Types.PROC, expression));
        }
    }

    static class UniRep
    implements UnifiableRep {
        final Expression uni;

        public UniRep(Expression uni) {
            this.uni = uni;
        }

        @Override
        public Expression toExpression() {
            return this.uni;
        }
    }

    static interface UnifiableRep {
        public Expression toExpression();
    }
}

