/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.scl.compiler.errors;

import gnu.trove.list.array.TIntArrayList;
import java.io.IOException;
import java.io.Reader;
import java.io.StringReader;
import org.simantics.scl.compiler.errors.CompilationError;
import org.simantics.scl.compiler.errors.Locations;

public class CompilationErrorFormatter {
    public static int[] rows(Reader reader) throws IOException {
        TIntArrayList rows = new TIntArrayList();
        rows.add(0);
        int i = 0;
        while (true) {
            ++i;
            int c = reader.read();
            if (c < 0) break;
            if (c != 10) continue;
            rows.add(i);
        }
        reader.close();
        return rows.toArray();
    }

    public static int lineNumber(int[] rows, int location) {
        if (location < 0) {
            return 1;
        }
        if (location >= rows[rows.length - 1]) {
            return rows.length;
        }
        int a = 0;
        int b = rows.length - 1;
        while (b - a > 1) {
            int c = (a + b) / 2;
            if (rows[c] <= location) {
                a = c;
                continue;
            }
            b = c;
        }
        return a + 1;
    }

    private static String locationToString(int[] rows, int location) {
        if (location == -1) {
            return "?";
        }
        if (location >= rows[rows.length - 1]) {
            return String.valueOf(rows.length) + ":" + (location - rows[rows.length - 1] + 1);
        }
        int a = 0;
        int b = rows.length - 1;
        while (b - a > 1) {
            int c = (a + b) / 2;
            if (rows[c] <= location) {
                a = c;
                continue;
            }
            b = c;
        }
        return String.valueOf(a + 1) + ":" + (location - rows[a] + 1);
    }

    public static String toString(String source, CompilationError[] errors) {
        return CompilationErrorFormatter.toString(new StringReader(source), errors);
    }

    public static String toString(Reader source, CompilationError[] errors) {
        int[] rows;
        try {
            rows = source != null ? CompilationErrorFormatter.rows(source) : new int[1];
        }
        catch (IOException iOException) {
            rows = new int[1];
        }
        StringBuilder b = new StringBuilder();
        boolean first = true;
        CompilationError[] compilationErrorArray = errors;
        int n = errors.length;
        int n2 = 0;
        while (n2 < n) {
            CompilationError error = compilationErrorArray[n2];
            if (first) {
                first = false;
            } else {
                b.append('\n');
            }
            b.append(String.valueOf(CompilationErrorFormatter.locationToString(rows, Locations.beginOf(error.location))) + "-" + CompilationErrorFormatter.locationToString(rows, Locations.endOf(error.location)) + ": " + error.description);
            ++n2;
        }
        return b.toString();
    }

    public static String toString(CompilationError[] errors) {
        return CompilationErrorFormatter.toString(null, errors);
    }
}

