/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.simulator.toolkit;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.concurrent.Callable;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.Semaphore;
import org.simantics.simulator.ExperimentState;
import org.simantics.simulator.toolkit.DynamicExperimentThreadListener;
import org.simantics.simulator.toolkit.StandardExperimentStates;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class DynamicExperimentThread
extends Thread {
    private static final Logger LOGGER = LoggerFactory.getLogger(DynamicExperimentThread.class);
    private CopyOnWriteArrayList<DynamicExperimentThreadListener> listeners = new CopyOnWriteArrayList();
    private ExperimentState state = StandardExperimentStates.CREATED;
    private long runStart = 0L;
    private double desiredRealtimeRatio = 1000.0;
    private double obtainedRealtimeRatio = 1.0;
    private long runTimeNs = 0L;
    private long endTimeNs = 0L;
    protected long simulationStepNs = 0L;
    protected double stepInSeconds = 1.0;
    private long rt;
    private long rt_l;
    protected ArrayList<Runnable> tasks = new ArrayList();
    long stepTime = 0L;
    long taskTime = 0L;
    Thread executorThread = this;
    Semaphore beginSyncExec = new Semaphore(0);
    Semaphore endSyncExec = new Semaphore(0);
    Runnable scheduleSyncExec = () -> {
        this.beginSyncExec.release();
        try {
            this.endSyncExec.acquire();
        }
        catch (InterruptedException interruptedException) {}
    };

    private void updateTimes() {
        long time = System.nanoTime();
        long elapsed = time - this.runStart;
        this.obtainedRealtimeRatio = this.longToDoubleDivision(this.runTimeNs, elapsed);
    }

    protected double longToDoubleDivision(long l1, long l2) {
        this.rt = l1 / l2;
        this.rt_l = l1 % l2;
        double d = (double)this.rt_l / (double)l2;
        return d += (double)this.rt;
    }

    public abstract void step(double var1);

    public boolean inState(Class<? extends ExperimentState> state) {
        return state.isInstance(this.state);
    }

    public void initialize() throws Exception {
    }

    public void deinitialize() throws Exception {
    }

    @Override
    public void run() {
        try {
            try {
                this.initialize();
                try {
                    this.runReally();
                }
                catch (Exception e) {
                    LOGGER.error("Unhandled exception while running simulation thread", (Throwable)e);
                }
            }
            catch (Exception e) {
                LOGGER.error("Unhandled exception while initializing simulation thread", (Throwable)e);
            }
        }
        finally {
            try {
                this.deinitialize();
            }
            catch (Exception e) {
                LOGGER.error("Error while deinitializing simulation thread", (Throwable)e);
            }
        }
    }

    protected boolean inActiveState() {
        return !this.inState(StandardExperimentStates.Disposed.class) && !this.inState(StandardExperimentStates.Disposing.class) && !this.inState(StandardExperimentStates.ToBeDisposed.class);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void runReally() {
        while (this.inActiveState()) {
            block18: {
                block19: {
                    if (!this.inState(StandardExperimentStates.Running.class)) break block19;
                    asd = System.nanoTime();
                    this.step(this.simulationStepNs);
                    this.stepTime += System.nanoTime() - asd;
                    this.runTimeNs += this.simulationStepNs;
                    this.updateTimes();
                    asd2 = System.nanoTime();
                    this.runTasks();
                    this.taskTime += System.nanoTime() - asd2;
                    if (true) ** GOTO lbl51
                }
                var1_2 = this.tasks;
                synchronized (var1_2) {
                    while (true) {
                        while (true) {
                            if (this.inState(StandardExperimentStates.Running.class) || !this.inActiveState()) {
                                break block18;
                            }
                            ran = this.runTasks();
                            if (ran != 0) continue;
                            try {
                                this.tasks.wait(0x7FFFFFFFL);
                            }
                            catch (InterruptedException e) {
                                DynamicExperimentThread.LOGGER.warn("Dynamic experiment thread '" + this.getName() + "' (" + this.getClass().getName() + ") interrupted", (Throwable)e);
                            }
                        }
                        break;
                    }
                    catch (Throwable v0) {
                        throw v0;
                    }
                }
                do {
                    if ((ran = this.runTasks()) == 0) {
                        elapsed = System.nanoTime() - this.runStart;
                        deltaNs = BigDecimal.valueOf(this.runTimeNs).divide(BigDecimal.valueOf(this.desiredRealtimeRatio)).longValue() - elapsed;
                        deltaMs = deltaNs / 1000000L;
                        deltaNsRem = (int)(deltaNs % 1000000L);
                        if (deltaNs > 0L) {
                            var13_11 = this.tasks;
                            synchronized (var13_11) {
                                if (this.inState(StandardExperimentStates.Running.class)) {
                                    try {
                                        this.tasks.wait(deltaMs, deltaNsRem);
                                    }
                                    catch (InterruptedException e) {
                                        DynamicExperimentThread.LOGGER.warn("Dynamic experiment thread '" + this.getName() + "' (" + this.getClass().getName() + ") interrupted", (Throwable)e);
                                    }
                                }
                            }
                        }
                    }
                    this.updateTimes();
lbl51:
                    // 2 sources

                } while (this.obtainedRealtimeRatio > this.desiredRealtimeRatio);
            }
            if (this.runTimeNs < this.endTimeNs || !this.inActiveState()) continue;
            this.changeState(StandardExperimentStates.STOPPED);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int runTasks() {
        ArrayList<Runnable> todo = new ArrayList<Runnable>(this.tasks.size());
        ArrayList<Runnable> arrayList = this.tasks;
        synchronized (arrayList) {
            todo.addAll(this.tasks);
            this.tasks.clear();
        }
        todo.forEach(Runnable::run);
        return todo.size();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void queue(Runnable runnable) {
        ArrayList<Runnable> arrayList = this.tasks;
        synchronized (arrayList) {
            this.tasks.add(runnable);
            this.tasks.notify();
        }
    }

    public <T> T syncExec(Callable<T> callable) throws InterruptedException {
        if (this.executorThread == Thread.currentThread()) {
            try {
                return callable.call();
            }
            catch (Throwable t) {
                LOGGER.error("syncExec in current thread failed", t);
                return null;
            }
        }
        this.queue(this.scheduleSyncExec);
        this.beginSyncExec.acquire();
        Thread oldThread = this.executorThread;
        this.executorThread = Thread.currentThread();
        try {
            T t = callable.call();
            return t;
        }
        catch (Throwable t) {
            LOGGER.error("syncExec failed", t);
            return null;
        }
        finally {
            this.executorThread = oldThread;
            this.endSyncExec.release();
        }
    }

    public void asyncExec(Runnable runnable) {
        if (this.executorThread == Thread.currentThread()) {
            try {
                runnable.run();
            }
            catch (Throwable t) {
                LOGGER.error("asyncExec failed", t);
            }
            return;
        }
        this.queue(runnable);
    }

    public void setSimulationStepNs(long ns) {
        this.simulationStepNs = ns;
        this.stepInSeconds = BigDecimal.valueOf(this.simulationStepNs).multiply(BigDecimal.valueOf(1.0E-9)).doubleValue();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void runDuration(long ns) {
        this.runStart = System.nanoTime();
        this.runTimeNs = 0L;
        this.endTimeNs = ns;
        ArrayList<Runnable> arrayList = this.tasks;
        synchronized (arrayList) {
            this.changeState(StandardExperimentStates.RUNNING);
            this.tasks.notify();
        }
    }

    public ExperimentState getExperimentState() {
        return this.state;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void changeState(ExperimentState state) {
        this.state = state;
        this.fireStateChanged(state);
        ArrayList<Runnable> arrayList = this.tasks;
        synchronized (arrayList) {
            this.tasks.notifyAll();
        }
    }

    public void addListener(DynamicExperimentThreadListener listener) {
        if (!this.listeners.contains(listener)) {
            this.listeners.add(listener);
        }
    }

    public void removeListener(DynamicExperimentThreadListener listener) {
        this.listeners.remove(listener);
    }

    protected void fireAfterStep() {
        this.listeners.forEach(DynamicExperimentThreadListener::afterStep);
    }

    protected void fireBeforeStep() {
        this.listeners.forEach(DynamicExperimentThreadListener::beforeStep);
    }

    protected void fireStateChanged(ExperimentState newState) {
        this.listeners.forEach(l -> l.stateChanged(newState));
    }
}

