The Java HDF5 interface library and the accompanying hdf5_java.dll JNI library
are built without both separately licensed ZLIB and SZIP open source libraries.
The native library (DLL) has been compiled with Visual Studio 2015 and dynamic
linking.

## Building HDF5 Linux native libraries

Current libraries have been using the 1.10.2 source code release.

* Get source code from https://www.hdfgroup.org/downloads/hdf5/source-code/
  * The configure-version, not the CMake source

* Extract source code package

* According to the build instructions at
  https://support.hdfgroup.org/ftp/HDF5/releases/hdf5-1.10/hdf5-1.10.2/src/unpacked/release_docs/INSTALL
  configure the source using:

      ./configure --enable-java --enable-build-mode=production --without-zlib --without-szlib --disable-sharedlib-rpath

  and you'll get a listing like this in the end:

~~~
            SUMMARY OF THE HDF5 CONFIGURATION
            =================================

General Information:
-------------------
                   HDF5 Version: 1.10.2
                  Configured on: Fri Apr  6 15:13:51 EEST 2018
                  Configured by: lehtonen@dev2
                    Host system: x86_64-unknown-linux-gnu
              Uname information: Linux dev2 4.4.0-96-generic #119-Ubuntu SMP Tue Sep 12 14:59:54 UTC 2017 x86_64 x86_64 x86_64 GNU/Linux
                       Byte sex: little-endian
             Installation point: /home/lehtonen/hdf/hdf5-1.10.2/hdf5

Compiling Options:
------------------
                     Build Mode: production
              Debugging Symbols: no
                        Asserts: no
                      Profiling: no
             Optimization Level: high

Linking Options:
----------------
                      Libraries: static, shared
  Statically Linked Executables:
                        LDFLAGS:
                     H5_LDFLAGS:
                     AM_LDFLAGS:
                Extra libraries: -ldl -lm
                       Archiver: ar
                       AR_FLAGS: cr
                         Ranlib: ranlib
						 
Languages:
----------
                              C: yes
                     C Compiler: /usr/bin/gcc
                       CPPFLAGS:
                    H5_CPPFLAGS: -D_GNU_SOURCE -D_POSIX_C_SOURCE=200112L   -DNDEBUG -UH5_DEBUG_API
                    AM_CPPFLAGS:
                        C Flags:
                     H5 C Flags:   -std=c99 -pedantic -Wall -Wextra -Wbad-function-cast -Wc++-compat -Wcast-align -Wcast-qual -Wconversion -Wdeclaration-after-statement -Wdisabled-optimization -Wfloat-equal -Wformat=2 -Winit-self -Winvalid-pch -Wmissing-declarations -Wmissing-include-dirs -Wmissing-prototypes -Wnested-externs -Wold-style-definition -Wpacked -Wpointer-arith -Wredundant-decls -Wshadow -Wstrict-prototypes -Wswitch-default -Wswitch-enum -Wundef -Wunused-macros -Wunsafe-loop-optimizations -Wwrite-strings -Wlogical-op -Wlarger-than=2048 -Wvla -Wsync-nand -Wframe-larger-than=16384 -Wpacked-bitfield-compat -Wstrict-overflow=5 -Wjump-misses-init -Wunsuffixed-float-constants -Wdouble-promotion -Wtrampolines -Wstack-usage=8192 -Wvector-operation-performance -Wdate-time -Warray-bounds=2 -Wc99-c11-compat -fstdarg-opt -s -Wno-inline -Wno-aggregate-return -Wno-missing-format-attribute -Wno-missing-noreturn -Wno-suggest-attribute=const -Wno-suggest-attribute=pure -Wno-suggest-attribute=noreturn -Wno-suggest-attribute=format -O3
                     AM C Flags:
               Shared C Library: yes
               Static C Library: yes


                        Fortran: no

                            C++: no

                           Java: yes
                  Java Compiler: /usr/bin/java (openjdk 1.8.0_162)


Features:
---------
                  Parallel HDF5: no
             High-level library: yes
                   Threadsafety: no
            Default API mapping: v110
 With deprecated public symbols: yes
         I/O filters (external):
                            MPE: no
                     Direct VFD: no
                        dmalloc: no
 Packages w/ extra debug output: none
                    API tracing: no
           Using memory checker: no
Memory allocation sanity checks: no
            Metadata trace file: no
         Function stack tracing: no
      Strict file format checks: no
   Optimization instrumentation: no

~~~

* Build the library and utilities: `make -j -l6`

* Copy the artifacts from the source tree into this directory:
  * Hdf5 library: `hdf5-1.10.2/src/.libs/libhdf5.so.101`
  * Hdf5 JNI library: `hdf5-1.10.2/java/src/jni/.libs/libhdf5_java.so`

* IMPORTANT:
  * Linux .so files do not automatically look at the same directory they exist in for required .so files.
  * We can add this behaviour with the "patchelf" commandline tool:
  * apt-get update && apt-get install patchelf
  * patchelf --set-rpath \$ORIGIN libhdf5_java.so

## Building HDF5 Windows native libraries

* Get CMake source code for Windows from https://www.hdfgroup.org/downloads/hdf5/source-code/#cmake
* Build instructions are at https://portal.hdfgroup.org/display/support/Building+HDF5+with+CMake
  
Here's our version in a nutshell:
  
* Unpack CMake-hdf5-1.10.2.zip and step into the extracted directory 
* Edit HDF5options.cmake
  * Release build
    ~~~
    set(CTEST_BUILD_CONFIGURATION "Release")
    ~~~
  * Build shared libraries:
    ~~~
    set (ADD_BUILD_OPTIONS "${ADD_BUILD_OPTIONS} -DBUILD_SHARED_LIBS:BOOL=ON")
    ~~~
  * Disable C++ library:
    ~~~
    set(ADD_BUILD_OPTIONS "${ADD_BUILD_OPTIONS} -DHDF5_BUILD_CPP_LIB:BOOL=OFF")
    ~~~
  * Enable Java:
    ~~~
    #############################################################################################
    ####      java enabled      ####
    set (ADD_BUILD_OPTIONS "${ADD_BUILD_OPTIONS} -DHDF5_BUILD_JAVA:BOOL=ON")
    ####      java disabled      ####
    #set (ADD_BUILD_OPTIONS "${ADD_BUILD_OPTIONS} -DHDF5_BUILD_JAVA:BOOL=OFF")
    ~~~
  * Disable zlib and szip
    ~~~
	### disable ext zlib building
    set(ADD_BUILD_OPTIONS "${ADD_BUILD_OPTIONS} -DHDF5_ENABLE_Z_LIB_SUPPORT:BOOL=OFF")
    ### disable ext szip building
    set(ADD_BUILD_OPTIONS "${ADD_BUILD_OPTIONS} -DHDF5_ENABLE_SZIP_SUPPORT:BOOL=OFF")
    set(ADD_BUILD_OPTIONS "${ADD_BUILD_OPTIONS} -DHDF5_ENABLE_SZIP_ENCODING:BOOL=OFF")
	~~~
  * Disable packaging
    ~~~
    #############################################################################################
    ### disable packaging

    set(ADD_BUILD_OPTIONS "${ADD_BUILD_OPTIONS} -DHDF5_NO_PACKAGES:BOOL=ON")
    ### Create install package with external libraries (szip, zlib)
    #set(ADD_BUILD_OPTIONS "${ADD_BUILD_OPTIONS} -DHDF5_PACKAGE_EXTLIBS:BOOL=ON")
    ~~~
* Run build-VS2015-64.bat and wait
* Copy build\bin\hdf5_java.dll into this directory