/*
 * Decompiled with CFR 0.152.
 */
package com.strobel.decompiler.languages.java.ast.transforms;

import com.strobel.assembler.metadata.CompilerTarget;
import com.strobel.assembler.metadata.IMemberDefinition;
import com.strobel.assembler.metadata.IMetadataResolver;
import com.strobel.assembler.metadata.MetadataHelper;
import com.strobel.assembler.metadata.MetadataParser;
import com.strobel.assembler.metadata.MethodDefinition;
import com.strobel.assembler.metadata.MethodReference;
import com.strobel.assembler.metadata.TypeDefinition;
import com.strobel.assembler.metadata.TypeReference;
import com.strobel.core.CollectionUtilities;
import com.strobel.core.Predicate;
import com.strobel.core.StringUtilities;
import com.strobel.decompiler.DecompilerContext;
import com.strobel.decompiler.languages.java.ast.Annotation;
import com.strobel.decompiler.languages.java.ast.AstBuilder;
import com.strobel.decompiler.languages.java.ast.ConstructorDeclaration;
import com.strobel.decompiler.languages.java.ast.ContextTrackingVisitor;
import com.strobel.decompiler.languages.java.ast.EntityDeclaration;
import com.strobel.decompiler.languages.java.ast.EnumValueDeclaration;
import com.strobel.decompiler.languages.java.ast.FieldDeclaration;
import com.strobel.decompiler.languages.java.ast.Keys;
import com.strobel.decompiler.languages.java.ast.MethodDeclaration;
import com.strobel.decompiler.languages.java.ast.SimpleType;
import com.strobel.decompiler.languages.java.ast.TypeDeclaration;
import java.util.List;

public final class AddStandardAnnotationsTransform
extends ContextTrackingVisitor<Void> {
    private static final String OVERRIDE_ANNOTATION_NAME = "java/lang/Override";
    private static final String DEPRECATED_ANNOTATION_NAME = "java/lang/Deprecated";
    private static final Predicate<Annotation> IS_OVERRIDE_ANNOTATION = new Predicate<Annotation>(){

        public boolean test(Annotation a) {
            TypeReference t = a.getType().getUserData(Keys.TYPE_REFERENCE);
            return t != null && StringUtilities.equals((String)t.getInternalName(), (String)AddStandardAnnotationsTransform.OVERRIDE_ANNOTATION_NAME);
        }
    };
    private static final Predicate<Annotation> IS_DEPRECATED_ANNOTATION = new Predicate<Annotation>(){

        @Deprecated
        public boolean test(Annotation a) {
            TypeReference t = a.getType().getUserData(Keys.TYPE_REFERENCE);
            return t != null && StringUtilities.equals((String)t.getInternalName(), (String)AddStandardAnnotationsTransform.DEPRECATED_ANNOTATION_NAME);
        }
    };
    private final AstBuilder _astBuilder;

    public AddStandardAnnotationsTransform(DecompilerContext context) {
        super(context);
        this._astBuilder = (AstBuilder)context.getUserData(Keys.AST_BUILDER);
    }

    @Override
    public Void visitMethodDeclaration(MethodDeclaration node, Void p) {
        this.tryAddOverrideAnnotation(node);
        this.tryAddDeprecatedAnnotationToMember(node);
        return (Void)super.visitMethodDeclaration(node, p);
    }

    @Override
    public Void visitConstructorDeclaration(ConstructorDeclaration node, Void p) {
        this.tryAddDeprecatedAnnotationToMember(node);
        return (Void)super.visitConstructorDeclaration(node, p);
    }

    @Override
    public Void visitFieldDeclaration(FieldDeclaration node, Void data) {
        this.tryAddDeprecatedAnnotationToMember(node);
        return (Void)super.visitFieldDeclaration(node, data);
    }

    @Override
    public Void visitEnumValueDeclaration(EnumValueDeclaration node, Void data) {
        this.tryAddDeprecatedAnnotationToMember(node);
        return (Void)super.visitEnumValueDeclaration(node, data);
    }

    @Override
    public Void visitTypeDeclaration(TypeDeclaration typeDeclaration, Void p) {
        this.tryAddDeprecatedAnnotationToType(typeDeclaration);
        return (Void)super.visitTypeDeclaration(typeDeclaration, p);
    }

    private void tryAddOverrideAnnotation(MethodDeclaration node) {
        if (CollectionUtilities.any(node.getAnnotations(), IS_OVERRIDE_ANNOTATION)) {
            return;
        }
        final MethodDefinition method = node.getUserData(Keys.METHOD_DEFINITION);
        if (method.isStatic() || method.isConstructor() || method.isTypeInitializer()) {
            return;
        }
        TypeDefinition declaringType = method.getDeclaringType();
        if (declaringType.getCompilerMajorVersion() < CompilerTarget.JDK1_5.majorVersion) {
            return;
        }
        TypeReference annotationType = new MetadataParser(declaringType).parseTypeDescriptor(OVERRIDE_ANNOTATION_NAME);
        List<MethodReference> candidates = MetadataHelper.findMethods(declaringType, (Predicate<? super MethodReference>)new Predicate<MethodReference>(){

            public boolean test(MethodReference reference) {
                return StringUtilities.equals((String)reference.getName(), (String)method.getName());
            }
        }, false, true);
        for (MethodReference candidate : candidates) {
            MethodDefinition resolvedCandidate;
            if (!MetadataHelper.isOverride(method, candidate) || (resolvedCandidate = candidate.resolve()) != null && resolvedCandidate.getDeclaringType().isInterface() && declaringType.getCompilerMajorVersion() < CompilerTarget.JDK1_6.majorVersion) continue;
            Annotation annotation = new Annotation();
            if (this._astBuilder != null) {
                annotation.setType(this._astBuilder.convertType(annotationType));
            } else {
                annotation.setType(new SimpleType(annotationType.getSimpleName()));
            }
            node.getAnnotations().add(annotation);
            break;
        }
    }

    private void tryAddDeprecatedAnnotationToMember(EntityDeclaration node) {
        TypeDefinition resolvedType;
        if (CollectionUtilities.any(node.getAnnotations(), IS_DEPRECATED_ANNOTATION)) {
            return;
        }
        IMemberDefinition member = node.getUserData(Keys.METHOD_DEFINITION);
        if (member == null) {
            member = node.getUserData(Keys.FIELD_DEFINITION);
        }
        if (member == null || (member.getFlags() & 0x20000L) != 131072L) {
            return;
        }
        TypeReference declaringType = member.getDeclaringType();
        TypeDefinition typeDefinition = resolvedType = declaringType instanceof TypeDefinition ? (TypeDefinition)declaringType : declaringType.resolve();
        if (resolvedType == null || resolvedType.getCompilerMajorVersion() < CompilerTarget.JDK1_5.majorVersion) {
            return;
        }
        this.addAnnotation(node, resolvedType.getResolver(), DEPRECATED_ANNOTATION_NAME);
    }

    private void tryAddDeprecatedAnnotationToType(TypeDeclaration node) {
        if (CollectionUtilities.any(node.getAnnotations(), IS_DEPRECATED_ANNOTATION)) {
            return;
        }
        TypeDefinition type = node.getUserData(Keys.TYPE_DEFINITION);
        if (type == null || (type.getFlags() & 0x20000L) != 131072L) {
            return;
        }
        if (type.getCompilerMajorVersion() < CompilerTarget.JDK1_5.majorVersion) {
            return;
        }
        this.addAnnotation(node, type.getResolver(), DEPRECATED_ANNOTATION_NAME);
    }

    private void addAnnotation(EntityDeclaration node, IMetadataResolver resolver, String annotationName) {
        if (resolver == null) {
            return;
        }
        Annotation annotation = new Annotation();
        TypeReference annotationType = new MetadataParser(resolver).parseTypeDescriptor(annotationName);
        if (this._astBuilder != null) {
            annotation.setType(this._astBuilder.convertType(annotationType));
        } else {
            annotation.setType(new SimpleType(annotationType.getSimpleName()));
        }
        node.getAnnotations().add(annotation);
    }
}

