/*
 * Decompiled with CFR 0.152.
 */
package com.strobel.decompiler.languages.java;

import com.strobel.assembler.ir.attributes.LineNumberTableAttribute;
import com.strobel.assembler.ir.attributes.SourceAttribute;
import com.strobel.assembler.metadata.FieldDefinition;
import com.strobel.assembler.metadata.Flags;
import com.strobel.assembler.metadata.MethodDefinition;
import com.strobel.assembler.metadata.MethodReference;
import com.strobel.assembler.metadata.ParameterDefinition;
import com.strobel.assembler.metadata.TypeDefinition;
import com.strobel.assembler.metadata.TypeReference;
import com.strobel.core.ArrayUtilities;
import com.strobel.core.CollectionUtilities;
import com.strobel.core.StringUtilities;
import com.strobel.core.VerifyArgument;
import com.strobel.decompiler.DecompilerSettings;
import com.strobel.decompiler.ITextOutput;
import com.strobel.decompiler.languages.LineNumberPosition;
import com.strobel.decompiler.languages.TextLocation;
import com.strobel.decompiler.languages.java.BraceEnforcement;
import com.strobel.decompiler.languages.java.BraceStyle;
import com.strobel.decompiler.languages.java.JavaFormattingOptions;
import com.strobel.decompiler.languages.java.LineNumberTableConverter;
import com.strobel.decompiler.languages.java.OffsetToLineNumberConverter;
import com.strobel.decompiler.languages.java.TextOutputFormatter;
import com.strobel.decompiler.languages.java.Wrapping;
import com.strobel.decompiler.languages.java.ast.Annotation;
import com.strobel.decompiler.languages.java.ast.AnonymousObjectCreationExpression;
import com.strobel.decompiler.languages.java.ast.ArrayCreationExpression;
import com.strobel.decompiler.languages.java.ast.ArrayInitializerExpression;
import com.strobel.decompiler.languages.java.ast.ArraySpecifier;
import com.strobel.decompiler.languages.java.ast.AssertStatement;
import com.strobel.decompiler.languages.java.ast.AssignmentExpression;
import com.strobel.decompiler.languages.java.ast.AstNode;
import com.strobel.decompiler.languages.java.ast.AstNodeCollection;
import com.strobel.decompiler.languages.java.ast.AstType;
import com.strobel.decompiler.languages.java.ast.BinaryOperatorExpression;
import com.strobel.decompiler.languages.java.ast.BinaryOperatorType;
import com.strobel.decompiler.languages.java.ast.BlockStatement;
import com.strobel.decompiler.languages.java.ast.BreakStatement;
import com.strobel.decompiler.languages.java.ast.CaseLabel;
import com.strobel.decompiler.languages.java.ast.CastExpression;
import com.strobel.decompiler.languages.java.ast.CatchClause;
import com.strobel.decompiler.languages.java.ast.ClassOfExpression;
import com.strobel.decompiler.languages.java.ast.ClassType;
import com.strobel.decompiler.languages.java.ast.Comment;
import com.strobel.decompiler.languages.java.ast.CommentType;
import com.strobel.decompiler.languages.java.ast.CompilationUnit;
import com.strobel.decompiler.languages.java.ast.ComposedType;
import com.strobel.decompiler.languages.java.ast.ConditionalExpression;
import com.strobel.decompiler.languages.java.ast.ConstructorDeclaration;
import com.strobel.decompiler.languages.java.ast.ContinueStatement;
import com.strobel.decompiler.languages.java.ast.DoWhileStatement;
import com.strobel.decompiler.languages.java.ast.EmptyStatement;
import com.strobel.decompiler.languages.java.ast.EntityDeclaration;
import com.strobel.decompiler.languages.java.ast.EnumValueDeclaration;
import com.strobel.decompiler.languages.java.ast.Expression;
import com.strobel.decompiler.languages.java.ast.ExpressionStatement;
import com.strobel.decompiler.languages.java.ast.FieldDeclaration;
import com.strobel.decompiler.languages.java.ast.ForEachStatement;
import com.strobel.decompiler.languages.java.ast.ForStatement;
import com.strobel.decompiler.languages.java.ast.GotoStatement;
import com.strobel.decompiler.languages.java.ast.IAstVisitor;
import com.strobel.decompiler.languages.java.ast.Identifier;
import com.strobel.decompiler.languages.java.ast.IdentifierExpression;
import com.strobel.decompiler.languages.java.ast.IfElseStatement;
import com.strobel.decompiler.languages.java.ast.ImportDeclaration;
import com.strobel.decompiler.languages.java.ast.IndexerExpression;
import com.strobel.decompiler.languages.java.ast.InstanceInitializer;
import com.strobel.decompiler.languages.java.ast.InstanceOfExpression;
import com.strobel.decompiler.languages.java.ast.InvocationExpression;
import com.strobel.decompiler.languages.java.ast.JavaModifierToken;
import com.strobel.decompiler.languages.java.ast.JavaTokenNode;
import com.strobel.decompiler.languages.java.ast.Keys;
import com.strobel.decompiler.languages.java.ast.LabelStatement;
import com.strobel.decompiler.languages.java.ast.LabeledStatement;
import com.strobel.decompiler.languages.java.ast.LambdaExpression;
import com.strobel.decompiler.languages.java.ast.LocalTypeDeclarationStatement;
import com.strobel.decompiler.languages.java.ast.MemberReferenceExpression;
import com.strobel.decompiler.languages.java.ast.MethodDeclaration;
import com.strobel.decompiler.languages.java.ast.MethodGroupExpression;
import com.strobel.decompiler.languages.java.ast.NewLineNode;
import com.strobel.decompiler.languages.java.ast.NodeType;
import com.strobel.decompiler.languages.java.ast.NullReferenceExpression;
import com.strobel.decompiler.languages.java.ast.ObjectCreationExpression;
import com.strobel.decompiler.languages.java.ast.PackageDeclaration;
import com.strobel.decompiler.languages.java.ast.ParameterDeclaration;
import com.strobel.decompiler.languages.java.ast.ParenthesizedExpression;
import com.strobel.decompiler.languages.java.ast.PrimitiveExpression;
import com.strobel.decompiler.languages.java.ast.ReturnStatement;
import com.strobel.decompiler.languages.java.ast.Roles;
import com.strobel.decompiler.languages.java.ast.SimpleType;
import com.strobel.decompiler.languages.java.ast.Statement;
import com.strobel.decompiler.languages.java.ast.SuperReferenceExpression;
import com.strobel.decompiler.languages.java.ast.SwitchSection;
import com.strobel.decompiler.languages.java.ast.SwitchStatement;
import com.strobel.decompiler.languages.java.ast.SynchronizedStatement;
import com.strobel.decompiler.languages.java.ast.TextNode;
import com.strobel.decompiler.languages.java.ast.ThisReferenceExpression;
import com.strobel.decompiler.languages.java.ast.ThrowStatement;
import com.strobel.decompiler.languages.java.ast.TokenRole;
import com.strobel.decompiler.languages.java.ast.TryCatchStatement;
import com.strobel.decompiler.languages.java.ast.TypeDeclaration;
import com.strobel.decompiler.languages.java.ast.TypeParameterDeclaration;
import com.strobel.decompiler.languages.java.ast.TypeReferenceExpression;
import com.strobel.decompiler.languages.java.ast.UnaryOperatorExpression;
import com.strobel.decompiler.languages.java.ast.UnaryOperatorType;
import com.strobel.decompiler.languages.java.ast.VariableDeclarationStatement;
import com.strobel.decompiler.languages.java.ast.VariableInitializer;
import com.strobel.decompiler.languages.java.ast.WhileStatement;
import com.strobel.decompiler.languages.java.ast.WildcardType;
import com.strobel.decompiler.languages.java.utilities.TypeUtilities;
import com.strobel.decompiler.patterns.AnyNode;
import com.strobel.decompiler.patterns.AstTypeMatch;
import com.strobel.decompiler.patterns.BackReference;
import com.strobel.decompiler.patterns.Choice;
import com.strobel.decompiler.patterns.INode;
import com.strobel.decompiler.patterns.IdentifierExpressionBackReference;
import com.strobel.decompiler.patterns.MemberReferenceTypeNode;
import com.strobel.decompiler.patterns.NamedNode;
import com.strobel.decompiler.patterns.OptionalNode;
import com.strobel.decompiler.patterns.ParameterReferenceNode;
import com.strobel.decompiler.patterns.Pattern;
import com.strobel.decompiler.patterns.Repeat;
import com.strobel.decompiler.patterns.Role;
import com.strobel.decompiler.patterns.TypedNode;
import com.strobel.util.ContractUtils;
import java.util.AbstractCollection;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Stack;

public final class JavaOutputVisitor
implements IAstVisitor<Void, Void> {
    final TextOutputFormatter formatter;
    final DecompilerSettings settings;
    final JavaFormattingOptions policy;
    final Stack<AstNode> containerStack = new Stack();
    final Stack<AstNode> positionStack = new Stack();
    final ITextOutput output;
    private LastWritten lastWritten;
    private static final String[] KEYWORDS = new String[]{"abstract", "assert", "boolean", "break", "byte", "case", "catch", "char", "class", "const", "continue", "default", "do", "double", "else", "enum", "extends", "final", "finally", "float", "for", "goto", "if", "implements", "import", "instanceof", "int", "interface", "long", "native", "new", "package", "private", "protected", "public", "return", "short", "static", "strictfp", "super", "switch", "synchronized", "this", "throw", "throws", "transient", "try", "void", "volatile", "while"};

    public JavaOutputVisitor(ITextOutput output, DecompilerSettings settings) {
        this.output = output;
        this.settings = (DecompilerSettings)VerifyArgument.notNull((Object)settings, (String)"settings");
        this.formatter = new TextOutputFormatter(output, settings.getShowDebugLineNumbers() ? TextOutputFormatter.LineNumberMode.WITH_DEBUG_LINE_NUMBERS : TextOutputFormatter.LineNumberMode.WITHOUT_DEBUG_LINE_NUMBERS);
        JavaFormattingOptions formattingOptions = settings.getJavaFormattingOptions();
        this.policy = formattingOptions != null ? formattingOptions : JavaFormattingOptions.createDefault();
    }

    public List<LineNumberPosition> getLineNumberPositions() {
        return this.formatter.getLineNumberPositions();
    }

    void startNode(AstNode node) {
        assert (this.containerStack.isEmpty() || node.getParent() == this.containerStack.peek() || this.containerStack.peek().getNodeType() == NodeType.PATTERN);
        if (this.positionStack.size() > 0) {
            this.writeSpecialsUpToNode(node);
        }
        this.containerStack.push(node);
        this.positionStack.push(node.getFirstChild());
        this.formatter.startNode(node);
    }

    void endNode(AstNode node) {
        assert (node == this.containerStack.peek());
        AstNode position = this.positionStack.pop();
        assert (position == null || position.getParent() == node);
        this.writeSpecials(position, null);
        this.containerStack.pop();
        this.formatter.endNode(node);
    }

    private void writeSpecials(AstNode start, AstNode end) {
        for (AstNode current = start; current != end; current = current.getNextSibling()) {
            if (current.getRole() != Roles.COMMENT && current.getRole() != Roles.NEW_LINE) continue;
            current.acceptVisitor(this, null);
        }
    }

    private void writeSpecialsUpToRole(Role<?> role) {
        this.writeSpecialsUpToRole(role, null);
    }

    private void writeSpecialsUpToRole(Role<?> role, AstNode nextNode) {
        if (this.positionStack.isEmpty()) {
            return;
        }
        for (AstNode current = this.positionStack.peek(); current != null && current != nextNode; current = current.getNextSibling()) {
            if (current.getRole() != role) continue;
            this.writeSpecials(this.positionStack.pop(), current);
            this.positionStack.push(current.getNextSibling());
            break;
        }
    }

    private void writeSpecialsUpToNode(AstNode node) {
        if (this.positionStack.isEmpty()) {
            return;
        }
        for (AstNode current = this.positionStack.peek(); current != null; current = current.getNextSibling()) {
            if (current != node) continue;
            this.writeSpecials(this.positionStack.pop(), current);
            this.positionStack.push(current.getNextSibling());
            break;
        }
    }

    void leftParenthesis() {
        this.writeToken(Roles.LEFT_PARENTHESIS);
    }

    void rightParenthesis() {
        this.writeToken(Roles.RIGHT_PARENTHESIS);
    }

    void space() {
        this.formatter.space();
        this.lastWritten = LastWritten.Whitespace;
    }

    void space(boolean addSpace) {
        if (addSpace) {
            this.space();
        }
    }

    void newLine() {
        this.formatter.newLine();
        this.lastWritten = LastWritten.Whitespace;
    }

    void openBrace(BraceStyle style) {
        this.writeSpecialsUpToRole(Roles.LEFT_BRACE);
        this.space((style == BraceStyle.EndOfLine || style == BraceStyle.BannerStyle) && this.lastWritten != LastWritten.Whitespace && this.lastWritten != LastWritten.LeftParenthesis);
        this.formatter.openBrace(style);
        this.lastWritten = style == BraceStyle.BannerStyle ? LastWritten.Other : LastWritten.Whitespace;
    }

    void closeBrace(BraceStyle style) {
        this.writeSpecialsUpToRole(Roles.RIGHT_BRACE);
        this.formatter.closeBrace(style);
        this.lastWritten = LastWritten.Other;
    }

    void writeIdentifier(String identifier) {
        this.writeIdentifier(identifier, null);
    }

    void writeIdentifier(String identifier, Role<Identifier> identifierRole) {
        this.writeSpecialsUpToRole(identifierRole != null ? identifierRole : Roles.IDENTIFIER);
        if (JavaOutputVisitor.isKeyword(identifier, this.containerStack.peek())) {
            if (this.lastWritten == LastWritten.KeywordOrIdentifier) {
                this.space();
            }
        } else if (this.lastWritten == LastWritten.KeywordOrIdentifier) {
            this.formatter.space();
        }
        if (identifierRole == Roles.LABEL) {
            this.formatter.writeLabel(identifier);
        } else {
            this.formatter.writeIdentifier(identifier);
        }
        this.lastWritten = LastWritten.KeywordOrIdentifier;
    }

    void writeToken(TokenRole tokenRole) {
        this.writeToken(tokenRole.getToken(), tokenRole);
    }

    void writeToken(String token, Role role) {
        this.writeSpecialsUpToRole(role);
        if (this.lastWritten == LastWritten.Plus && token.charAt(0) == '+' || this.lastWritten == LastWritten.Minus && token.charAt(0) == '-' || this.lastWritten == LastWritten.Ampersand && token.charAt(0) == '&' || this.lastWritten == LastWritten.QuestionMark && token.charAt(0) == '?' || this.lastWritten == LastWritten.Division && token.charAt(0) == '*') {
            this.formatter.space();
        }
        if (role instanceof TokenRole) {
            TokenRole tokenRole = (TokenRole)role;
            if (tokenRole.isKeyword()) {
                this.formatter.writeKeyword(token);
                this.lastWritten = LastWritten.KeywordOrIdentifier;
                return;
            }
            if (tokenRole.isOperator()) {
                this.formatter.writeOperator(token);
                this.lastWritten = LastWritten.Operator;
                return;
            }
            if (tokenRole.isDelimiter()) {
                this.formatter.writeDelimiter(token);
                this.lastWritten = "(".equals(token) ? LastWritten.LeftParenthesis : LastWritten.Delimiter;
                return;
            }
        }
        this.formatter.writeToken(token);
        switch (token) {
            case "+": {
                this.lastWritten = LastWritten.Plus;
                break;
            }
            case "-": {
                this.lastWritten = LastWritten.Minus;
                break;
            }
            case "&": {
                this.lastWritten = LastWritten.Ampersand;
                break;
            }
            case "?": {
                this.lastWritten = LastWritten.QuestionMark;
                break;
            }
            case "/": {
                this.lastWritten = LastWritten.Division;
                break;
            }
            case "(": {
                this.lastWritten = LastWritten.LeftParenthesis;
                break;
            }
            default: {
                this.lastWritten = LastWritten.Other;
            }
        }
    }

    void comma(AstNode nextNode) {
        this.comma(nextNode, false);
    }

    void comma(AstNode nextNode, boolean noSpaceAfterComma) {
        this.writeSpecialsUpToRole(Roles.COMMA, nextNode);
        this.space(this.policy.SpaceBeforeBracketComma);
        this.formatter.writeDelimiter(",");
        this.lastWritten = LastWritten.Other;
        this.space(!noSpaceAfterComma && this.policy.SpaceAfterBracketComma);
    }

    void optionalComma() {
        AstNode position;
        for (position = this.positionStack.peek(); position != null && position.getNodeType() == NodeType.WHITESPACE; position = position.getNextSibling()) {
        }
        if (position != null && position.getRole() == Roles.COMMA) {
            this.comma(null, true);
        }
    }

    void semicolon() {
        Role<? extends AstNode> role = this.containerStack.peek().getRole();
        if (role != ForStatement.INITIALIZER_ROLE && role != ForStatement.ITERATOR_ROLE) {
            this.writeToken(Roles.SEMICOLON);
            this.newLine();
        }
    }

    private void optionalSemicolon() {
        AstNode pos;
        for (pos = this.positionStack.peek(); pos != null && pos.getNodeType() == NodeType.WHITESPACE; pos = pos.getNextSibling()) {
        }
        if (pos != null && pos.getRole() == Roles.SEMICOLON) {
            this.semicolon();
        }
    }

    private void writeCommaSeparatedList(Iterable<? extends AstNode> list) {
        boolean isFirst = true;
        for (AstNode astNode : list) {
            if (isFirst) {
                isFirst = false;
            } else {
                this.comma(astNode);
            }
            astNode.acceptVisitor(this, null);
        }
    }

    private void writePipeSeparatedList(Iterable<? extends AstNode> list) {
        boolean isFirst = true;
        for (AstNode astNode : list) {
            if (isFirst) {
                isFirst = false;
            } else {
                this.space();
                this.writeToken(Roles.PIPE);
                this.space();
            }
            astNode.acceptVisitor(this, null);
        }
    }

    private void writeCommaSeparatedListInParenthesis(Iterable<? extends AstNode> list, boolean spaceWithin) {
        this.leftParenthesis();
        if (CollectionUtilities.any(list)) {
            this.space(spaceWithin);
            this.writeCommaSeparatedList(list);
            this.space(spaceWithin);
        }
        this.rightParenthesis();
    }

    private void writeTypeArguments(Iterable<AstType> typeArguments) {
        if (CollectionUtilities.any(typeArguments)) {
            this.writeToken(Roles.LEFT_CHEVRON);
            this.writeCommaSeparatedList(typeArguments);
            this.writeToken(Roles.RIGHT_CHEVRON);
        }
    }

    public void writeTypeParameters(Iterable<TypeParameterDeclaration> typeParameters) {
        if (CollectionUtilities.any(typeParameters)) {
            this.writeToken(Roles.LEFT_CHEVRON);
            this.writeCommaSeparatedList(typeParameters);
            this.writeToken(Roles.RIGHT_CHEVRON);
        }
    }

    private void writeModifiers(Iterable<JavaModifierToken> modifierTokens) {
        for (JavaModifierToken modifier : modifierTokens) {
            modifier.acceptVisitor(this, null);
        }
    }

    private void writeQualifiedIdentifier(Iterable<Identifier> identifiers) {
        boolean first = true;
        for (Identifier identifier : identifiers) {
            if (first) {
                first = false;
                if (this.lastWritten == LastWritten.KeywordOrIdentifier) {
                    this.formatter.space();
                }
            } else {
                this.writeSpecialsUpToRole(Roles.DOT, identifier);
                this.formatter.writeToken(".");
                this.lastWritten = LastWritten.Other;
            }
            this.writeSpecialsUpToNode(identifier);
            this.formatter.writeIdentifier(identifier.getName());
            this.lastWritten = LastWritten.KeywordOrIdentifier;
        }
    }

    void writeEmbeddedStatement(Statement embeddedStatement) {
        if (embeddedStatement.isNull()) {
            this.newLine();
            return;
        }
        if (embeddedStatement instanceof BlockStatement) {
            this.visitBlockStatement((BlockStatement)embeddedStatement, null);
        } else {
            this.newLine();
            this.formatter.indent();
            embeddedStatement.acceptVisitor(this, null);
            this.formatter.unindent();
        }
    }

    void writeMethodBody(AstNodeCollection<TypeDeclaration> declaredTypes, BlockStatement body) {
        boolean addBraces;
        BraceEnforcement braceEnforcement;
        BraceStyle style;
        if (body.isNull()) {
            this.semicolon();
            return;
        }
        this.startNode(body);
        AstNode parent = body.getParent();
        if (parent instanceof ConstructorDeclaration) {
            style = this.policy.ConstructorBraceStyle;
            braceEnforcement = BraceEnforcement.AddBraces;
        } else if (parent instanceof MethodDeclaration) {
            style = this.policy.MethodBraceStyle;
            braceEnforcement = BraceEnforcement.AddBraces;
        } else {
            style = this.policy.StatementBraceStyle;
            braceEnforcement = parent instanceof IfElseStatement ? this.policy.IfElseBraceEnforcement : (parent instanceof WhileStatement ? this.policy.WhileBraceEnforcement : BraceEnforcement.AddBraces);
        }
        AstNodeCollection<Statement> statements = body.getStatements();
        switch (braceEnforcement) {
            case RemoveBraces: {
                addBraces = false;
                break;
            }
            default: {
                addBraces = true;
            }
        }
        if (addBraces) {
            this.openBrace(style);
        }
        boolean needNewLine = false;
        if (declaredTypes != null && !declaredTypes.isEmpty()) {
            for (TypeDeclaration typeDeclaration : declaredTypes) {
                if (needNewLine) {
                    this.newLine();
                }
                typeDeclaration.acceptVisitor(new JavaOutputVisitor(this.output, this.settings), null);
                needNewLine = true;
            }
        }
        if (needNewLine) {
            this.newLine();
        }
        for (AstNode astNode : statements) {
            astNode.acceptVisitor(this, null);
        }
        if (addBraces) {
            this.closeBrace(style);
        }
        if (!(parent instanceof Expression)) {
            this.newLine();
        }
        this.endNode(body);
    }

    void writeAnnotations(Iterable<Annotation> annotations, boolean newLineAfter) {
        for (Annotation annotation : annotations) {
            annotation.acceptVisitor(this, null);
            if (newLineAfter) {
                this.newLine();
                continue;
            }
            this.space();
        }
    }

    void writePrivateImplementationType(AstType privateImplementationType) {
        if (!privateImplementationType.isNull()) {
            privateImplementationType.acceptVisitor(this, null);
            this.writeToken(Roles.DOT);
        }
    }

    void writeKeyword(TokenRole tokenRole) {
        this.writeKeyword(tokenRole.getToken(), tokenRole);
    }

    void writeKeyword(String token) {
        this.writeKeyword(token, null);
    }

    void writeKeyword(String token, Role tokenRole) {
        if (tokenRole != null) {
            this.writeSpecialsUpToRole(tokenRole);
        }
        if (this.lastWritten == LastWritten.KeywordOrIdentifier) {
            this.formatter.space();
        }
        this.formatter.writeKeyword(token);
        this.lastWritten = LastWritten.KeywordOrIdentifier;
    }

    void visitNodeInPattern(INode childNode) {
        if (childNode instanceof AstNode) {
            ((AstNode)childNode).acceptVisitor(this, null);
        } else if (childNode instanceof IdentifierExpressionBackReference) {
            this.visitIdentifierExpressionBackReference((IdentifierExpressionBackReference)childNode);
        } else if (childNode instanceof Choice) {
            this.visitChoice((Choice)childNode);
        } else if (childNode instanceof AnyNode) {
            this.visitAnyNode((AnyNode)childNode);
        } else if (childNode instanceof BackReference) {
            this.visitBackReference((BackReference)childNode);
        } else if (childNode instanceof NamedNode) {
            this.visitNamedNode((NamedNode)childNode);
        } else if (childNode instanceof OptionalNode) {
            this.visitOptionalNode((OptionalNode)childNode);
        } else if (childNode instanceof Repeat) {
            this.visitRepeat((Repeat)childNode);
        } else if (childNode instanceof MemberReferenceTypeNode) {
            this.visitMemberReferenceTypeNode((MemberReferenceTypeNode)childNode);
        } else if (childNode instanceof TypedNode) {
            this.visitTypedNode((TypedNode)childNode);
        } else if (childNode instanceof ParameterReferenceNode) {
            this.visitParameterReferenceNode((ParameterReferenceNode)childNode);
        } else if (childNode instanceof AstTypeMatch) {
            this.visitAstTypeMatch((AstTypeMatch)childNode);
        } else {
            this.writePrimitiveValue(childNode);
        }
    }

    private void visitTypedNode(TypedNode node) {
        this.writeKeyword("anyOf");
        this.leftParenthesis();
        this.writeIdentifier(node.getNodeType().getSimpleName());
        this.rightParenthesis();
    }

    private void visitParameterReferenceNode(ParameterReferenceNode node) {
        this.writeKeyword("parameterAt");
        this.leftParenthesis();
        this.writePrimitiveValue(node.getParameterPosition());
        this.rightParenthesis();
    }

    private void visitIdentifierExpressionBackReference(IdentifierExpressionBackReference node) {
        this.writeKeyword("identifierBackReference");
        this.leftParenthesis();
        this.writeIdentifier(node.getReferencedGroupName());
        this.rightParenthesis();
    }

    private void visitChoice(Choice choice) {
        this.writeKeyword("choice");
        this.space();
        this.leftParenthesis();
        this.newLine();
        this.formatter.indent();
        INode last = (INode)CollectionUtilities.lastOrDefault((Iterable)choice);
        for (INode alternative : choice) {
            this.visitNodeInPattern(alternative);
            if (alternative != last) {
                this.writeToken(Roles.COMMA);
            }
            this.newLine();
        }
        this.formatter.unindent();
        this.rightParenthesis();
    }

    private void visitMemberReferenceTypeNode(MemberReferenceTypeNode node) {
        this.writeKeyword("memberReference");
        this.writeToken(Roles.LEFT_BRACKET);
        this.writeIdentifier(node.getReferenceType().getSimpleName());
        this.writeToken(Roles.RIGHT_BRACKET);
        this.leftParenthesis();
        this.visitNodeInPattern(node.getTarget());
        this.rightParenthesis();
    }

    private void visitAnyNode(AnyNode anyNode) {
        if (!StringUtilities.isNullOrEmpty((String)anyNode.getGroupName())) {
            this.writeIdentifier(anyNode.getGroupName());
            this.writeToken(Roles.COLON);
            this.writeIdentifier("*");
        }
    }

    private void visitBackReference(BackReference backReference) {
        this.writeKeyword("backReference");
        this.leftParenthesis();
        this.writeIdentifier(backReference.getReferencedGroupName());
        this.rightParenthesis();
    }

    private void visitNamedNode(NamedNode namedNode) {
        if (!StringUtilities.isNullOrEmpty((String)namedNode.getGroupName())) {
            this.writeIdentifier(namedNode.getGroupName());
            this.writeToken(Roles.COLON);
        }
        this.visitNodeInPattern(namedNode.getNode());
    }

    private void visitOptionalNode(OptionalNode optionalNode) {
        this.writeKeyword("optional");
        this.leftParenthesis();
        this.visitNodeInPattern(optionalNode.getNode());
        this.rightParenthesis();
    }

    private void visitRepeat(Repeat repeat) {
        this.writeKeyword("repeat");
        this.leftParenthesis();
        if (repeat.getMinCount() != 0 || repeat.getMaxCount() != Integer.MAX_VALUE) {
            this.writeIdentifier(String.valueOf(repeat.getMinCount()));
            this.writeToken(Roles.COMMA);
            this.writeIdentifier(String.valueOf(repeat.getMaxCount()));
            this.writeToken(Roles.COMMA);
        }
        this.visitNodeInPattern(repeat.getNode());
        this.rightParenthesis();
    }

    private void visitAstTypeMatch(AstTypeMatch repeat) {
        SimpleType t = new SimpleType(repeat.getType().getFullName());
        t.putUserData(Keys.TYPE_REFERENCE, repeat.getType());
        this.writeKeyword("astType");
        this.leftParenthesis();
        this.visitSimpleType(t, null);
        this.rightParenthesis();
    }

    @Override
    public Void visitComment(Comment comment, Void ignored) {
        if (this.lastWritten == LastWritten.Division) {
            this.formatter.space();
        }
        this.formatter.startNode(comment);
        this.formatter.writeComment(comment.getCommentType(), comment.getContent());
        this.formatter.endNode(comment);
        this.lastWritten = LastWritten.Whitespace;
        return null;
    }

    @Override
    public Void visitPatternPlaceholder(AstNode node, Pattern pattern, Void ignored) {
        this.startNode(node);
        this.visitNodeInPattern(pattern);
        this.endNode(node);
        return null;
    }

    @Override
    public Void visitInvocationExpression(InvocationExpression node, Void ignored) {
        this.startNode(node);
        node.getTarget().acceptVisitor(this, null);
        this.space(this.policy.SpaceBeforeMethodCallParentheses);
        this.writeCommaSeparatedListInParenthesis(node.getArguments(), this.policy.SpaceWithinMethodCallParentheses);
        this.endNode(node);
        return null;
    }

    @Override
    public Void visitTypeReference(TypeReferenceExpression node, Void ignored) {
        this.startNode(node);
        node.getType().acceptVisitor(this, null);
        this.endNode(node);
        return null;
    }

    @Override
    public Void visitJavaTokenNode(JavaTokenNode node, Void ignored) {
        node.setStartLocation(new TextLocation(this.output.getRow(), this.output.getColumn()));
        if (!(node instanceof JavaModifierToken)) {
            throw ContractUtils.unsupported();
        }
        JavaModifierToken modifierToken = (JavaModifierToken)node;
        this.startNode(modifierToken);
        this.writeKeyword(JavaModifierToken.getModifierName(modifierToken.getModifier()));
        this.endNode(modifierToken);
        return null;
    }

    @Override
    public Void visitMemberReferenceExpression(MemberReferenceExpression node, Void ignored) {
        this.startNode(node);
        Expression target = node.getTarget();
        if (!target.isNull()) {
            target.acceptVisitor(this, null);
            this.writeToken(Roles.DOT);
        }
        this.writeTypeArguments(node.getTypeArguments());
        this.writeIdentifier(node.getMemberName());
        this.endNode(node);
        return null;
    }

    @Override
    public Void visitIdentifier(Identifier node, Void ignored) {
        node.setStartLocation(new TextLocation(this.output.getRow(), this.output.getColumn()));
        this.startNode(node);
        this.writeIdentifier(node.getName());
        this.endNode(node);
        return null;
    }

    @Override
    public Void visitNullReferenceExpression(NullReferenceExpression node, Void ignored) {
        node.setStartLocation(new TextLocation(this.output.getRow(), this.output.getColumn()));
        this.startNode(node);
        this.writeKeyword("null", node.getRole());
        this.endNode(node);
        return null;
    }

    @Override
    public Void visitThisReferenceExpression(ThisReferenceExpression node, Void ignored) {
        node.setStartLocation(new TextLocation(this.output.getRow(), this.output.getColumn()));
        this.startNode(node);
        Expression target = node.getTarget();
        if (target != null && !target.isNull()) {
            target.acceptVisitor(this, ignored);
            this.writeToken(Roles.DOT);
        }
        this.writeKeyword("this", node.getRole());
        this.endNode(node);
        return null;
    }

    @Override
    public Void visitSuperReferenceExpression(SuperReferenceExpression node, Void ignored) {
        node.setStartLocation(new TextLocation(this.output.getRow(), this.output.getColumn()));
        this.startNode(node);
        Expression target = node.getTarget();
        if (target != null && !target.isNull()) {
            target.acceptVisitor(this, ignored);
            this.writeToken(Roles.DOT);
        }
        this.writeKeyword("super", node.getRole());
        this.endNode(node);
        return null;
    }

    @Override
    public Void visitClassOfExpression(ClassOfExpression node, Void ignored) {
        this.startNode(node);
        node.getType().acceptVisitor(this, ignored);
        this.writeToken(Roles.DOT);
        this.writeKeyword("class", node.getRole());
        this.endNode(node);
        return null;
    }

    @Override
    public Void visitBlockStatement(BlockStatement node, Void ignored) {
        boolean addBraces;
        BraceEnforcement braceEnforcement;
        BraceStyle style;
        this.startNode(node);
        AstNode parent = node.getParent();
        Iterable<AstNode> children = node.getChildren();
        if (parent instanceof ConstructorDeclaration) {
            style = this.policy.ConstructorBraceStyle;
            braceEnforcement = BraceEnforcement.AddBraces;
        } else if (parent instanceof MethodDeclaration) {
            style = this.policy.MethodBraceStyle;
            braceEnforcement = BraceEnforcement.AddBraces;
        } else if (this.policy.StatementBraceStyle == BraceStyle.EndOfLine && !CollectionUtilities.any(children)) {
            style = BraceStyle.BannerStyle;
            braceEnforcement = BraceEnforcement.AddBraces;
        } else {
            style = this.policy.StatementBraceStyle;
            braceEnforcement = parent instanceof IfElseStatement ? this.policy.IfElseBraceEnforcement : (parent instanceof WhileStatement ? this.policy.WhileBraceEnforcement : BraceEnforcement.AddBraces);
        }
        switch (braceEnforcement) {
            case RemoveBraces: {
                addBraces = false;
                break;
            }
            default: {
                addBraces = true;
            }
        }
        if (addBraces) {
            this.openBrace(style);
        }
        for (AstNode child : children) {
            if (!(child instanceof Statement) && !(child instanceof TypeDeclaration)) continue;
            child.acceptVisitor(this, null);
        }
        if (addBraces) {
            this.closeBrace(style);
        }
        if (!(parent instanceof Expression) && !(parent instanceof DoWhileStatement)) {
            this.newLine();
        }
        this.endNode(node);
        return null;
    }

    @Override
    public Void visitExpressionStatement(ExpressionStatement node, Void ignored) {
        this.startNode(node);
        node.getExpression().acceptVisitor(this, null);
        this.semicolon();
        this.endNode(node);
        return null;
    }

    @Override
    public Void visitBreakStatement(BreakStatement node, Void ignored) {
        this.startNode(node);
        this.writeKeyword("break");
        String label = node.getLabel();
        if (!StringUtilities.isNullOrEmpty((String)label)) {
            this.writeIdentifier(label, Roles.LABEL);
        }
        this.semicolon();
        this.endNode(node);
        return null;
    }

    @Override
    public Void visitContinueStatement(ContinueStatement node, Void ignored) {
        this.startNode(node);
        this.writeKeyword("continue");
        String label = node.getLabel();
        if (!StringUtilities.isNullOrEmpty((String)label)) {
            this.writeIdentifier(label, Roles.LABEL);
        }
        this.semicolon();
        this.endNode(node);
        return null;
    }

    @Override
    public Void visitDoWhileStatement(DoWhileStatement node, Void ignored) {
        this.startNode(node);
        this.writeKeyword(DoWhileStatement.DO_KEYWORD_ROLE);
        this.writeEmbeddedStatement(node.getEmbeddedStatement());
        this.space(this.lastWritten != LastWritten.Whitespace);
        this.writeKeyword(DoWhileStatement.WHILE_KEYWORD_ROLE);
        this.space(this.policy.SpaceBeforeWhileParentheses);
        this.leftParenthesis();
        this.space(this.policy.SpacesWithinWhileParentheses);
        node.getCondition().acceptVisitor(this, null);
        this.space(this.policy.SpacesWithinWhileParentheses);
        this.rightParenthesis();
        this.semicolon();
        this.endNode(node);
        return null;
    }

    @Override
    public Void visitEmptyStatement(EmptyStatement node, Void ignored) {
        this.startNode(node);
        this.semicolon();
        this.endNode(node);
        return null;
    }

    @Override
    public Void visitIfElseStatement(IfElseStatement node, Void ignored) {
        this.startNode(node);
        this.writeKeyword(IfElseStatement.IF_KEYWORD_ROLE);
        this.space(this.policy.SpaceBeforeIfParentheses);
        this.leftParenthesis();
        this.space(this.policy.SpacesWithinIfParentheses);
        node.getCondition().acceptVisitor(this, null);
        this.space(this.policy.SpacesWithinIfParentheses);
        this.rightParenthesis();
        this.writeEmbeddedStatement(node.getTrueStatement());
        Statement falseStatement = node.getFalseStatement();
        if (!falseStatement.isNull()) {
            this.writeKeyword(IfElseStatement.ELSE_KEYWORD_ROLE);
            if (falseStatement instanceof IfElseStatement) {
                falseStatement.acceptVisitor(this, ignored);
            } else {
                this.writeEmbeddedStatement(falseStatement);
            }
        }
        this.endNode(node);
        return null;
    }

    @Override
    public Void visitLabelStatement(LabelStatement node, Void ignored) {
        this.startNode(node);
        this.writeIdentifier(node.getLabel(), Roles.LABEL);
        this.writeToken(Roles.COLON);
        boolean foundLabelledStatement = false;
        for (AstNode sibling = node.getNextSibling(); sibling != null; sibling = sibling.getNextSibling()) {
            if (sibling.getRole() != node.getRole()) continue;
            foundLabelledStatement = true;
        }
        if (!foundLabelledStatement) {
            this.writeToken(Roles.SEMICOLON);
        }
        this.newLine();
        this.endNode(node);
        return null;
    }

    @Override
    public Void visitLabeledStatement(LabeledStatement node, Void ignored) {
        boolean isLoop = AstNode.isLoop(node.getStatement());
        this.startNode(node);
        if (isLoop) {
            this.formatter.unindent();
        }
        this.writeIdentifier(node.getLabel(), Roles.LABEL);
        this.writeToken(Roles.COLON);
        if (isLoop) {
            this.formatter.indent();
            this.newLine();
        }
        node.getStatement().acceptVisitor(this, ignored);
        this.endNode(node);
        return null;
    }

    @Override
    public Void visitReturnStatement(ReturnStatement node, Void ignored) {
        this.startNode(node);
        this.writeKeyword(ReturnStatement.RETURN_KEYWORD_ROLE);
        if (!node.getExpression().isNull()) {
            this.space();
            node.getExpression().acceptVisitor(this, null);
        }
        this.semicolon();
        this.endNode(node);
        return null;
    }

    @Override
    public Void visitSwitchStatement(SwitchStatement node, Void ignored) {
        this.startNode(node);
        this.writeKeyword(SwitchStatement.SWITCH_KEYWORD_ROLE);
        this.space(this.policy.SpaceBeforeSwitchParentheses);
        this.leftParenthesis();
        this.space(this.policy.SpacesWithinSwitchParentheses);
        node.getExpression().acceptVisitor(this, ignored);
        this.space(this.policy.SpacesWithinSwitchParentheses);
        this.rightParenthesis();
        this.openBrace(this.policy.StatementBraceStyle);
        if (this.policy.IndentSwitchBody) {
            this.formatter.indent();
        }
        for (SwitchSection section : node.getSwitchSections()) {
            section.acceptVisitor(this, ignored);
        }
        if (this.policy.IndentSwitchBody) {
            this.formatter.unindent();
        }
        this.closeBrace(this.policy.StatementBraceStyle);
        this.newLine();
        this.endNode(node);
        return null;
    }

    @Override
    public Void visitSwitchSection(SwitchSection node, Void ignored) {
        boolean isBlock;
        this.startNode(node);
        boolean first = true;
        for (CaseLabel label : node.getCaseLabels()) {
            if (!first) {
                this.newLine();
            }
            label.acceptVisitor(this, ignored);
            first = false;
        }
        boolean bl = isBlock = node.getStatements().size() == 1 && CollectionUtilities.firstOrDefault(node.getStatements()) instanceof BlockStatement;
        if (this.policy.IndentCaseBody && !isBlock) {
            this.formatter.indent();
        }
        if (!isBlock) {
            this.newLine();
        }
        for (Statement statement : node.getStatements()) {
            statement.acceptVisitor(this, ignored);
        }
        if (this.policy.IndentCaseBody && !isBlock) {
            this.formatter.unindent();
        }
        this.endNode(node);
        return null;
    }

    @Override
    public Void visitCaseLabel(CaseLabel node, Void ignored) {
        this.startNode(node);
        if (node.getExpression().isNull()) {
            this.writeKeyword(CaseLabel.DEFAULT_KEYWORD_ROLE);
        } else {
            this.writeKeyword(CaseLabel.CASE_KEYWORD_ROLE);
            this.space();
            node.getExpression().acceptVisitor(this, ignored);
        }
        this.writeToken(Roles.COLON);
        this.endNode(node);
        return null;
    }

    @Override
    public Void visitThrowStatement(ThrowStatement node, Void ignored) {
        this.startNode(node);
        this.writeKeyword(ThrowStatement.THROW_KEYWORD_ROLE);
        if (!node.getExpression().isNull()) {
            this.space();
            node.getExpression().acceptVisitor(this, ignored);
        }
        this.semicolon();
        this.endNode(node);
        return null;
    }

    @Override
    public Void visitCatchClause(CatchClause node, Void ignored) {
        this.startNode(node);
        this.writeKeyword(CatchClause.CATCH_KEYWORD_ROLE);
        if (!node.getExceptionTypes().isEmpty()) {
            this.space(this.policy.SpaceBeforeCatchParentheses);
            this.leftParenthesis();
            this.space(this.policy.SpacesWithinCatchParentheses);
            this.writePipeSeparatedList(node.getExceptionTypes());
            if (!StringUtilities.isNullOrEmpty((String)node.getVariableName())) {
                this.space();
                node.getVariableNameToken().acceptVisitor(this, ignored);
            }
            this.space(this.policy.SpacesWithinCatchParentheses);
            this.rightParenthesis();
        }
        node.getBody().acceptVisitor(this, ignored);
        this.endNode(node);
        return null;
    }

    @Override
    public Void visitAnnotation(Annotation node, Void ignored) {
        this.startNode(node);
        this.startNode(node.getType());
        this.formatter.writeIdentifier("@");
        this.endNode(node.getType());
        node.getType().acceptVisitor(this, ignored);
        AstNodeCollection<Expression> arguments = node.getArguments();
        if (!arguments.isEmpty()) {
            this.writeCommaSeparatedListInParenthesis(arguments, false);
        }
        this.endNode(node);
        return null;
    }

    @Override
    public Void visitNewLine(NewLineNode node, Void ignored) {
        this.formatter.startNode(node);
        this.formatter.newLine();
        this.formatter.endNode(node);
        return null;
    }

    @Override
    public Void visitVariableDeclaration(VariableDeclarationStatement node, Void ignored) {
        return this.writeVariableDeclaration(node, true);
    }

    private Void writeVariableDeclaration(VariableDeclarationStatement node, boolean semicolon) {
        this.startNode(node);
        this.writeModifiers(node.getChildrenByRole(VariableDeclarationStatement.MODIFIER_ROLE));
        node.getType().acceptVisitor(this, null);
        this.space();
        this.writeCommaSeparatedList(node.getVariables());
        if (semicolon) {
            this.semicolon();
        }
        this.endNode(node);
        return null;
    }

    @Override
    public Void visitVariableInitializer(VariableInitializer node, Void ignored) {
        this.startNode(node);
        node.getNameToken().acceptVisitor(this, ignored);
        if (!node.getInitializer().isNull()) {
            this.space(this.policy.SpaceAroundAssignment);
            this.writeToken(Roles.ASSIGN);
            this.space(this.policy.SpaceAroundAssignment);
            node.getInitializer().acceptVisitor(this, ignored);
        }
        this.endNode(node);
        return null;
    }

    @Override
    public Void visitText(TextNode node, Void ignored) {
        return null;
    }

    @Override
    public Void visitImportDeclaration(ImportDeclaration node, Void ignored) {
        this.startNode(node);
        this.writeKeyword(ImportDeclaration.IMPORT_KEYWORD_RULE);
        node.getImportIdentifier().acceptVisitor(this, ignored);
        this.semicolon();
        this.endNode(node);
        if (!(node.getNextSibling() instanceof ImportDeclaration)) {
            this.newLine();
        }
        return null;
    }

    @Override
    public Void visitSimpleType(SimpleType node, Void ignored) {
        this.startNode(node);
        TypeReference typeReference = node.getUserData(Keys.TYPE_REFERENCE);
        if (typeReference != null && typeReference.isPrimitive()) {
            this.writeKeyword(typeReference.getSimpleName());
        } else {
            this.writeIdentifier(node.getIdentifier());
        }
        this.writeTypeArguments(node.getTypeArguments());
        this.endNode(node);
        return null;
    }

    @Override
    public Void visitMethodDeclaration(MethodDeclaration node, Void ignored) {
        Expression defaultValue;
        AstNodeCollection<AstType> thrownTypes;
        LineNumberTableAttribute lineNumberTable;
        this.startNode(node);
        this.formatter.resetLineNumberOffsets(OffsetToLineNumberConverter.NOOP_CONVERTER);
        this.writeAnnotations(node.getAnnotations(), true);
        MethodDefinition definition = node.getUserData(Keys.METHOD_DEFINITION);
        if (definition != null && definition.isDefault()) {
            this.writeKeyword(Roles.DEFAULT_KEYWORD);
        }
        this.writeModifiers(node.getModifiers());
        if (definition != null && (definition.isSynthetic() || definition.isBridgeMethod())) {
            this.space(this.lastWritten != LastWritten.Whitespace);
            this.formatter.writeComment(CommentType.MultiLine, definition.isBridgeMethod() ? " bridge " : " synthetic ");
            this.space();
        }
        if ((lineNumberTable = (LineNumberTableAttribute)SourceAttribute.find("LineNumberTable", definition != null ? definition.getSourceAttributes() : Collections.emptyList())) != null) {
            this.formatter.resetLineNumberOffsets(new LineNumberTableConverter(lineNumberTable));
        }
        if (definition == null || !definition.isTypeInitializer()) {
            AstNodeCollection<TypeParameterDeclaration> typeParameters = node.getTypeParameters();
            if (CollectionUtilities.any(typeParameters)) {
                this.space();
                this.writeTypeParameters(typeParameters);
                this.space();
            }
            node.getReturnType().acceptVisitor(this, ignored);
            this.space();
            this.writePrivateImplementationType(node.getPrivateImplementationType());
            node.getNameToken().acceptVisitor(this, ignored);
            this.space(this.policy.SpaceBeforeMethodDeclarationParentheses);
            this.writeCommaSeparatedListInParenthesis(node.getParameters(), this.policy.SpaceWithinMethodDeclarationParentheses);
        }
        if (!(thrownTypes = node.getThrownTypes()).isEmpty()) {
            this.space();
            this.writeKeyword(MethodDeclaration.THROWS_KEYWORD);
            this.writeCommaSeparatedList(thrownTypes);
        }
        if ((defaultValue = node.getDefaultValue()) != null && !defaultValue.isNull()) {
            this.space();
            this.writeKeyword(MethodDeclaration.DEFAULT_KEYWORD);
            this.space();
            defaultValue.acceptVisitor(this, ignored);
        }
        AstNodeCollection<TypeDeclaration> declaredTypes = node.getDeclaredTypes();
        this.writeMethodBody(declaredTypes, node.getBody());
        this.endNode(node);
        return null;
    }

    @Override
    public Void visitInitializerBlock(InstanceInitializer node, Void ignored) {
        this.startNode(node);
        this.writeMethodBody(node.getDeclaredTypes(), node.getBody());
        this.endNode(node);
        return null;
    }

    @Override
    public Void visitConstructorDeclaration(ConstructorDeclaration node, Void ignored) {
        AstNode parent;
        this.startNode(node);
        this.writeAnnotations(node.getAnnotations(), true);
        this.writeModifiers(node.getModifiers());
        AstNodeCollection<TypeParameterDeclaration> typeParameters = node.getTypeParameters();
        if (CollectionUtilities.any(typeParameters)) {
            this.space();
            this.writeTypeParameters(typeParameters);
            this.space();
        }
        TypeDeclaration type = (parent = node.getParent()) instanceof TypeDeclaration ? (TypeDeclaration)parent : null;
        MethodDefinition constructor = node.getUserData(Keys.METHOD_DEFINITION);
        LineNumberTableAttribute lineNumberTable = (LineNumberTableAttribute)SourceAttribute.find("LineNumberTable", constructor != null ? constructor.getSourceAttributes() : Collections.emptyList());
        if (lineNumberTable != null) {
            this.formatter.resetLineNumberOffsets(new LineNumberTableConverter(lineNumberTable));
        }
        this.startNode(node.getNameToken());
        this.writeIdentifier(type != null ? type.getName() : node.getName());
        this.endNode(node.getNameToken());
        this.space(this.policy.SpaceBeforeConstructorDeclarationParentheses);
        this.writeCommaSeparatedListInParenthesis(node.getParameters(), this.policy.SpaceWithinMethodDeclarationParentheses);
        AstNodeCollection<AstType> thrownTypes = node.getThrownTypes();
        if (!thrownTypes.isEmpty()) {
            this.space();
            this.writeKeyword(MethodDeclaration.THROWS_KEYWORD);
            this.writeCommaSeparatedList(thrownTypes);
        }
        this.writeMethodBody(null, node.getBody());
        this.endNode(node);
        return null;
    }

    @Override
    public Void visitTypeParameterDeclaration(TypeParameterDeclaration node, Void ignored) {
        this.startNode(node);
        this.writeAnnotations(node.getAnnotations(), false);
        node.getNameToken().acceptVisitor(this, ignored);
        AstType extendsBound = node.getExtendsBound();
        if (extendsBound != null && !extendsBound.isNull()) {
            this.writeKeyword(Roles.EXTENDS_KEYWORD);
            extendsBound.acceptVisitor(this, ignored);
        }
        this.endNode(node);
        return null;
    }

    @Override
    public Void visitParameterDeclaration(ParameterDeclaration node, Void ignored) {
        boolean hasType = !node.getType().isNull();
        this.startNode(node);
        this.writeAnnotations(node.getAnnotations(), false);
        if (hasType) {
            this.writeModifiers(node.getModifiers());
            node.getType().acceptVisitor(this, ignored);
            if (!StringUtilities.isNullOrEmpty((String)node.getName())) {
                this.space();
            }
        }
        if (!StringUtilities.isNullOrEmpty((String)node.getName())) {
            node.getNameToken().acceptVisitor(this, ignored);
        }
        this.endNode(node);
        return null;
    }

    @Override
    public Void visitFieldDeclaration(FieldDeclaration node, Void ignored) {
        this.startNode(node);
        this.writeAnnotations(node.getAnnotations(), true);
        this.writeModifiers(node.getModifiers());
        FieldDefinition field = node.getUserData(Keys.FIELD_DEFINITION);
        if (field != null && field.isSynthetic()) {
            this.space(this.lastWritten != LastWritten.Whitespace);
            this.formatter.writeComment(CommentType.MultiLine, " synthetic ");
            this.space();
        }
        node.getReturnType().acceptVisitor(this, ignored);
        this.space();
        this.writeCommaSeparatedList(node.getVariables());
        this.semicolon();
        this.endNode(node);
        return null;
    }

    @Override
    public Void visitLocalTypeDeclarationStatement(LocalTypeDeclarationStatement node, Void data) {
        this.startNode(node);
        node.getTypeDeclaration().acceptVisitor(this, data);
        this.endNode(node);
        return data;
    }

    @Override
    public Void visitTypeDeclaration(TypeDeclaration node, Void ignored) {
        BraceStyle braceStyle;
        boolean isTrulyAnonymous;
        this.startNode(node);
        TypeDefinition type = node.getUserData(Keys.TYPE_DEFINITION);
        boolean bl = isTrulyAnonymous = type != null && type.isAnonymous() && node.getParent() instanceof AnonymousObjectCreationExpression;
        if (!isTrulyAnonymous) {
            this.writeAnnotations(node.getAnnotations(), true);
            this.writeModifiers(node.getModifiers());
            switch (node.getClassType()) {
                case ENUM: {
                    this.writeKeyword(Roles.ENUM_KEYWORD);
                    break;
                }
                case INTERFACE: {
                    this.writeKeyword(Roles.INTERFACE_KEYWORD);
                    break;
                }
                case ANNOTATION: {
                    this.writeKeyword(Roles.ANNOTATION_KEYWORD);
                    break;
                }
                default: {
                    this.writeKeyword(Roles.CLASS_KEYWORD);
                }
            }
            node.getNameToken().acceptVisitor(this, ignored);
            this.writeTypeParameters(node.getTypeParameters());
            if (!node.getBaseType().isNull()) {
                this.space();
                this.writeKeyword(Roles.EXTENDS_KEYWORD);
                this.space();
                node.getBaseType().acceptVisitor(this, ignored);
            }
            if (CollectionUtilities.any(node.getInterfaces())) {
                AbstractCollection interfaceTypes;
                if (node.getClassType() == ClassType.ANNOTATION) {
                    interfaceTypes = new ArrayList();
                    for (AstType t : node.getInterfaces()) {
                        TypeReference r = t.getUserData(Keys.TYPE_REFERENCE);
                        if (r != null && "java/lang/annotation/Annotation".equals(r.getInternalName())) continue;
                        interfaceTypes.add(t);
                    }
                } else {
                    interfaceTypes = node.getInterfaces();
                }
                if (CollectionUtilities.any(interfaceTypes)) {
                    this.space();
                    if (node.getClassType() == ClassType.INTERFACE || node.getClassType() == ClassType.ANNOTATION) {
                        this.writeKeyword(Roles.EXTENDS_KEYWORD);
                    } else {
                        this.writeKeyword(Roles.IMPLEMENTS_KEYWORD);
                    }
                    this.space();
                    this.writeCommaSeparatedList(node.getInterfaces());
                }
            }
        }
        AstNodeCollection<EntityDeclaration> members = node.getMembers();
        switch (node.getClassType()) {
            case ENUM: {
                braceStyle = this.policy.EnumBraceStyle;
                break;
            }
            case INTERFACE: {
                braceStyle = this.policy.InterfaceBraceStyle;
                break;
            }
            case ANNOTATION: {
                braceStyle = this.policy.AnnotationBraceStyle;
                break;
            }
            default: {
                braceStyle = type != null && type.isAnonymous() ? (members.isEmpty() ? BraceStyle.BannerStyle : this.policy.AnonymousClassBraceStyle) : this.policy.ClassBraceStyle;
            }
        }
        this.openBrace(braceStyle);
        boolean first = true;
        EntityDeclaration lastMember = null;
        for (EntityDeclaration member : members) {
            if (first) {
                first = false;
            } else {
                int blankLines = member instanceof FieldDeclaration && lastMember instanceof FieldDeclaration ? this.policy.BlankLinesBetweenFields : this.policy.BlankLinesBetweenMembers;
                for (int i = 0; i < blankLines; ++i) {
                    this.formatter.newLine();
                }
            }
            member.acceptVisitor(this, ignored);
            lastMember = member;
        }
        this.closeBrace(braceStyle);
        if (type == null || !type.isAnonymous()) {
            this.optionalSemicolon();
            this.newLine();
        }
        this.endNode(node);
        return null;
    }

    @Override
    public Void visitCompilationUnit(CompilationUnit node, Void ignored) {
        for (AstNode child : node.getChildren()) {
            child.acceptVisitor(this, ignored);
        }
        return null;
    }

    @Override
    public Void visitPackageDeclaration(PackageDeclaration node, Void ignored) {
        this.startNode(node);
        this.writeKeyword(Roles.PACKAGE_KEYWORD);
        this.writeQualifiedIdentifier(node.getIdentifiers());
        this.semicolon();
        this.newLine();
        for (int i = 0; i < this.policy.BlankLinesAfterPackageDeclaration; ++i) {
            this.newLine();
        }
        this.endNode(node);
        return null;
    }

    @Override
    public Void visitArraySpecifier(ArraySpecifier node, Void ignored) {
        this.startNode(node);
        this.writeToken(Roles.LEFT_BRACKET);
        for (JavaTokenNode comma : node.getChildrenByRole(Roles.COMMA)) {
            this.writeSpecialsUpToNode(comma);
            this.formatter.writeToken(",");
            this.lastWritten = LastWritten.Other;
        }
        this.writeToken(Roles.RIGHT_BRACKET);
        this.endNode(node);
        return null;
    }

    @Override
    public Void visitComposedType(ComposedType node, Void ignored) {
        MethodReference method;
        MethodDefinition resolvedMethod;
        ParameterDefinition parameter;
        this.startNode(node);
        node.getBaseType().acceptVisitor(this, ignored);
        boolean isVarArgs = false;
        if (node.getParent() instanceof ParameterDeclaration && (parameter = node.getParent().getUserData(Keys.PARAMETER_DEFINITION)).getPosition() == parameter.getMethod().getParameters().size() - 1 && parameter.getParameterType().isArray() && parameter.getMethod() instanceof MethodReference && (resolvedMethod = (method = (MethodReference)parameter.getMethod()).resolve()) != null && Flags.testAny(resolvedMethod.getFlags(), 0x400000080L)) {
            isVarArgs = true;
        }
        AstNodeCollection<ArraySpecifier> arraySpecifiers = node.getArraySpecifiers();
        int arraySpecifierCount = arraySpecifiers.size();
        int i = 0;
        for (ArraySpecifier specifier : arraySpecifiers) {
            if (isVarArgs && ++i == arraySpecifierCount) {
                this.writeToken(Roles.VARARGS);
                continue;
            }
            specifier.acceptVisitor(this, ignored);
        }
        this.endNode(node);
        return null;
    }

    @Override
    public Void visitWhileStatement(WhileStatement node, Void ignored) {
        this.startNode(node);
        this.writeKeyword(WhileStatement.WHILE_KEYWORD_ROLE);
        this.space(this.policy.SpaceBeforeWhileParentheses);
        this.leftParenthesis();
        this.space(this.policy.SpacesWithinWhileParentheses);
        node.getCondition().acceptVisitor(this, ignored);
        this.space(this.policy.SpacesWithinWhileParentheses);
        this.rightParenthesis();
        this.writeEmbeddedStatement(node.getEmbeddedStatement());
        this.endNode(node);
        return null;
    }

    @Override
    public Void visitPrimitiveExpression(PrimitiveExpression node, Void ignored) {
        node.setStartLocation(new TextLocation(this.output.getRow(), this.output.getColumn()));
        this.startNode(node);
        if (!StringUtilities.isNullOrEmpty((String)node.getLiteralValue())) {
            this.formatter.writeLiteral(node.getLiteralValue());
        } else if (node.getValue() instanceof Number) {
            long longValue = ((Number)node.getValue()).longValue();
            if (longValue != -1L && this.isBitwiseContext(node.getParent(), node)) {
                this.formatter.writeLiteral(String.format(node.getValue() instanceof Long ? "0x%1$XL" : "0x%1$X", node.getValue()));
            } else {
                this.writePrimitiveValue(node.getValue());
            }
        } else {
            this.writePrimitiveValue(node.getValue());
        }
        this.endNode(node);
        return null;
    }

    private boolean isBitwiseContext(AstNode parent, AstNode node) {
        parent = parent != null ? TypeUtilities.skipParenthesesUp(parent) : null;
        AstNode astNode = node = node != null ? TypeUtilities.skipParenthesesUp(node) : null;
        if (parent instanceof BinaryOperatorExpression || parent instanceof AssignmentExpression) {
            BinaryOperatorType operator = parent instanceof BinaryOperatorExpression ? ((BinaryOperatorExpression)parent).getOperator() : AssignmentExpression.getCorrespondingBinaryOperator(((AssignmentExpression)parent).getOperator());
            if (operator == null) {
                return false;
            }
            switch (operator) {
                case BITWISE_AND: 
                case BITWISE_OR: 
                case EXCLUSIVE_OR: {
                    return true;
                }
                case EQUALITY: 
                case INEQUALITY: {
                    if (node == null) break;
                    BinaryOperatorExpression binary = (BinaryOperatorExpression)parent;
                    Expression comparand = node == binary.getLeft() ? binary.getRight() : binary.getLeft();
                    return this.isBitwiseContext(TypeUtilities.skipParenthesesDown((AstNode)comparand), null);
                }
            }
            return false;
        }
        if (parent instanceof UnaryOperatorExpression) {
            switch (((UnaryOperatorExpression)parent).getOperator()) {
                case BITWISE_NOT: {
                    return true;
                }
            }
            return false;
        }
        return false;
    }

    void writePrimitiveValue(Object val) {
        if (val == null) {
            this.writeKeyword("null");
            return;
        }
        if (val instanceof Boolean) {
            if (((Boolean)val).booleanValue()) {
                this.writeKeyword("true");
            } else {
                this.writeKeyword("false");
            }
            return;
        }
        if (val instanceof String) {
            this.formatter.writeTextLiteral(StringUtilities.escape((String)val.toString(), (boolean)true, (boolean)this.settings.isUnicodeOutputEnabled()));
            this.lastWritten = LastWritten.Other;
        } else if (val instanceof Character) {
            this.formatter.writeTextLiteral(StringUtilities.escape((char)((Character)val).charValue(), (boolean)true, (boolean)this.settings.isUnicodeOutputEnabled()));
            this.lastWritten = LastWritten.Other;
        } else if (val instanceof Float) {
            float f = ((Float)val).floatValue();
            if (Float.isInfinite(f) || Float.isNaN(f)) {
                this.writeKeyword("Float");
                this.writeToken(Roles.DOT);
                if (f == Float.POSITIVE_INFINITY) {
                    this.writeIdentifier("POSITIVE_INFINITY");
                } else if (f == Float.NEGATIVE_INFINITY) {
                    this.writeIdentifier("NEGATIVE_INFINITY");
                } else {
                    this.writeIdentifier("NaN");
                }
                return;
            }
            this.formatter.writeLiteral(Float.toString(f) + "f");
            this.lastWritten = LastWritten.Other;
        } else if (val instanceof Double) {
            double d = (Double)val;
            if (Double.isInfinite(d) || Double.isNaN(d)) {
                this.writeKeyword("Double");
                this.writeToken(Roles.DOT);
                if (d == Double.POSITIVE_INFINITY) {
                    this.writeIdentifier("POSITIVE_INFINITY");
                } else if (d == Double.NEGATIVE_INFINITY) {
                    this.writeIdentifier("NEGATIVE_INFINITY");
                } else {
                    this.writeIdentifier("NaN");
                }
                return;
            }
            String number = Double.toString(d);
            if (number.indexOf(46) < 0 && number.indexOf(69) < 0) {
                number = number + "d";
            }
            this.formatter.writeLiteral(number);
            this.lastWritten = LastWritten.KeywordOrIdentifier;
        } else if (val instanceof Number) {
            boolean writeHex;
            long longValue = ((Number)val).longValue();
            boolean bl = writeHex = longValue == 0xBADBADBADBADL || longValue == -4982089500409860083L;
            if (!writeHex) {
                long msb = longValue & 0xFFFFFFFF00000000L;
                long lsb = longValue & 0xFFFFFFFFL;
                if (msb == 0L) {
                    switch ((int)lsb) {
                        case -1414812757: 
                        case -1414677826: 
                        case -1414673666: 
                        case -1159869698: 
                        case -1146241297: 
                        case -1091581234: 
                        case -889275714: 
                        case -889270259: 
                        case -889262164: 
                        case -559039810: 
                        case -559038737: 
                        case -559038242: 
                        case -559026163: 
                        case -553727763: 
                        case -86057299: 
                        case 464367618: {
                            writeHex = true;
                        }
                    }
                }
            }
            String stringValue = writeHex ? String.format("0x%1$X", longValue) : String.valueOf(val);
            this.formatter.writeLiteral(val instanceof Long ? stringValue + "L" : stringValue);
            this.lastWritten = LastWritten.Other;
        } else {
            this.formatter.writeLiteral(String.valueOf(val));
            this.lastWritten = LastWritten.Other;
        }
    }

    @Override
    public Void visitCastExpression(CastExpression node, Void ignored) {
        this.startNode(node);
        this.leftParenthesis();
        this.space(this.policy.SpacesWithinCastParentheses);
        node.getType().acceptVisitor(this, ignored);
        this.space(this.policy.SpacesWithinCastParentheses);
        this.rightParenthesis();
        this.space(this.policy.SpaceAfterTypecast);
        node.getExpression().acceptVisitor(this, ignored);
        this.endNode(node);
        return null;
    }

    @Override
    public Void visitBinaryOperatorExpression(BinaryOperatorExpression node, Void ignored) {
        boolean spacePolicy;
        this.startNode(node);
        node.getLeft().acceptVisitor(this, ignored);
        switch (node.getOperator()) {
            case BITWISE_AND: 
            case BITWISE_OR: 
            case EXCLUSIVE_OR: {
                spacePolicy = this.policy.SpaceAroundBitwiseOperator;
                break;
            }
            case LOGICAL_AND: 
            case LOGICAL_OR: {
                spacePolicy = this.policy.SpaceAroundLogicalOperator;
                break;
            }
            case GREATER_THAN: 
            case GREATER_THAN_OR_EQUAL: 
            case LESS_THAN_OR_EQUAL: 
            case LESS_THAN: {
                spacePolicy = this.policy.SpaceAroundRelationalOperator;
                break;
            }
            case EQUALITY: 
            case INEQUALITY: {
                spacePolicy = this.policy.SpaceAroundEqualityOperator;
                break;
            }
            case ADD: 
            case SUBTRACT: {
                spacePolicy = this.policy.SpaceAroundAdditiveOperator;
                break;
            }
            case MULTIPLY: 
            case DIVIDE: 
            case MODULUS: {
                spacePolicy = this.policy.SpaceAroundMultiplicativeOperator;
                break;
            }
            case SHIFT_LEFT: 
            case SHIFT_RIGHT: 
            case UNSIGNED_SHIFT_RIGHT: {
                spacePolicy = this.policy.SpaceAroundShiftOperator;
                break;
            }
            default: {
                spacePolicy = true;
            }
        }
        this.space(spacePolicy);
        this.writeToken(BinaryOperatorExpression.getOperatorRole(node.getOperator()));
        this.space(spacePolicy);
        node.getRight().acceptVisitor(this, ignored);
        this.endNode(node);
        return null;
    }

    @Override
    public Void visitInstanceOfExpression(InstanceOfExpression node, Void ignored) {
        this.startNode(node);
        node.getExpression().acceptVisitor(this, ignored);
        this.space();
        this.writeKeyword(InstanceOfExpression.INSTANCE_OF_KEYWORD_ROLE);
        node.getType().acceptVisitor(this, ignored);
        this.endNode(node);
        return null;
    }

    @Override
    public Void visitIndexerExpression(IndexerExpression node, Void ignored) {
        this.startNode(node);
        node.getTarget().acceptVisitor(this, ignored);
        this.space(this.policy.SpaceBeforeMethodCallParentheses);
        this.writeToken(Roles.LEFT_BRACKET);
        node.getArgument().acceptVisitor(this, ignored);
        this.writeToken(Roles.RIGHT_BRACKET);
        this.endNode(node);
        return null;
    }

    @Override
    public Void visitIdentifierExpression(IdentifierExpression node, Void ignored) {
        this.startNode(node);
        this.writeIdentifier(node.getIdentifier());
        this.writeTypeArguments(node.getTypeArguments());
        this.endNode(node);
        return null;
    }

    @Override
    public Void visitUnaryOperatorExpression(UnaryOperatorExpression node, Void ignored) {
        this.startNode(node);
        UnaryOperatorType operator = node.getOperator();
        TokenRole symbol = UnaryOperatorExpression.getOperatorRole(operator);
        if (operator != UnaryOperatorType.POST_INCREMENT && operator != UnaryOperatorType.POST_DECREMENT) {
            this.writeToken(symbol);
        }
        node.getExpression().acceptVisitor(this, ignored);
        if (operator == UnaryOperatorType.POST_INCREMENT || operator == UnaryOperatorType.POST_DECREMENT) {
            this.writeToken(symbol);
        }
        this.endNode(node);
        return null;
    }

    @Override
    public Void visitConditionalExpression(ConditionalExpression node, Void ignored) {
        this.startNode(node);
        node.getCondition().acceptVisitor(this, ignored);
        this.space(this.policy.SpaceBeforeConditionalOperatorCondition);
        this.writeToken(ConditionalExpression.QUESTION_MARK_ROLE);
        this.space(this.policy.SpaceAfterConditionalOperatorCondition);
        node.getTrueExpression().acceptVisitor(this, ignored);
        this.space(this.policy.SpaceBeforeConditionalOperatorSeparator);
        this.writeToken(ConditionalExpression.COLON_ROLE);
        this.space(this.policy.SpaceAfterConditionalOperatorSeparator);
        node.getFalseExpression().acceptVisitor(this, ignored);
        this.endNode(node);
        return null;
    }

    @Override
    public Void visitArrayInitializerExpression(ArrayInitializerExpression node, Void ignored) {
        this.startNode(node);
        this.writeInitializerElements(node.getElements());
        this.endNode(node);
        return null;
    }

    private void writeInitializerElements(AstNodeCollection<Expression> elements) {
        if (elements.isEmpty()) {
            this.writeToken(Roles.LEFT_BRACE);
            this.writeToken(Roles.RIGHT_BRACE);
            return;
        }
        boolean wrapElements = this.policy.ArrayInitializerWrapping == Wrapping.WrapAlways;
        BraceStyle style = wrapElements ? BraceStyle.NextLine : BraceStyle.BannerStyle;
        this.openBrace(style);
        boolean isFirst = true;
        for (AstNode astNode : elements) {
            if (isFirst) {
                if (style == BraceStyle.BannerStyle) {
                    this.space();
                }
                isFirst = false;
            } else {
                this.comma(astNode, wrapElements);
                if (wrapElements) {
                    this.newLine();
                }
            }
            astNode.acceptVisitor(this, null);
        }
        this.optionalComma();
        if (wrapElements) {
            this.newLine();
        } else if (!isFirst && style == BraceStyle.BannerStyle) {
            this.space();
        }
        this.closeBrace(style);
    }

    @Override
    public Void visitObjectCreationExpression(ObjectCreationExpression node, Void ignored) {
        this.startNode(node);
        Expression target = node.getTarget();
        if (target != null && !target.isNull()) {
            target.acceptVisitor(this, ignored);
            this.writeToken(Roles.DOT);
        }
        this.writeKeyword(ObjectCreationExpression.NEW_KEYWORD_ROLE);
        node.getType().acceptVisitor(this, ignored);
        this.space(this.policy.SpaceBeforeMethodCallParentheses);
        this.writeCommaSeparatedListInParenthesis(node.getArguments(), this.policy.SpaceWithinMethodCallParentheses);
        this.endNode(node);
        return null;
    }

    @Override
    public Void visitAnonymousObjectCreationExpression(AnonymousObjectCreationExpression node, Void ignored) {
        this.startNode(node);
        Expression target = node.getTarget();
        if (target != null && !target.isNull()) {
            target.acceptVisitor(this, ignored);
            this.writeToken(Roles.DOT);
        }
        this.writeKeyword(ObjectCreationExpression.NEW_KEYWORD_ROLE);
        node.getType().acceptVisitor(this, ignored);
        this.space(this.policy.SpaceBeforeMethodCallParentheses);
        this.writeCommaSeparatedListInParenthesis(node.getArguments(), this.policy.SpaceWithinMethodCallParentheses);
        node.getTypeDeclaration().acceptVisitor(new JavaOutputVisitor(this.output, this.settings), ignored);
        this.endNode(node);
        return null;
    }

    @Override
    public Void visitWildcardType(WildcardType node, Void ignored) {
        this.startNode(node);
        this.writeToken(WildcardType.WILDCARD_TOKEN_ROLE);
        AstNodeCollection<AstType> extendsBounds = node.getExtendsBounds();
        if (!extendsBounds.isEmpty()) {
            this.space();
            this.writeKeyword(WildcardType.EXTENDS_KEYWORD_ROLE);
            this.writePipeSeparatedList(extendsBounds);
        } else {
            AstNodeCollection<AstType> superBounds = node.getSuperBounds();
            if (!superBounds.isEmpty()) {
                this.space();
                this.writeKeyword(WildcardType.SUPER_KEYWORD_ROLE);
                this.writePipeSeparatedList(superBounds);
            }
        }
        this.endNode(node);
        return null;
    }

    @Override
    public Void visitMethodGroupExpression(MethodGroupExpression node, Void ignored) {
        this.startNode(node);
        node.getTarget().acceptVisitor(this, ignored);
        this.writeToken(MethodGroupExpression.DOUBLE_COLON_ROLE);
        if (JavaOutputVisitor.isKeyword(node.getMethodName())) {
            this.writeKeyword(node.getMethodName());
        } else {
            this.writeIdentifier(node.getMethodName());
        }
        this.endNode(node);
        return null;
    }

    @Override
    public Void visitEnumValueDeclaration(EnumValueDeclaration node, Void ignored) {
        this.startNode(node);
        this.writeAnnotations(node.getAnnotations(), true);
        this.writeIdentifier(node.getName());
        AstNodeCollection<Expression> arguments = node.getArguments();
        if (!arguments.isEmpty()) {
            this.writeCommaSeparatedListInParenthesis(arguments, this.policy.SpaceWithinEnumDeclarationParentheses);
        }
        AstNodeCollection<EntityDeclaration> members = node.getMembers();
        TypeDefinition enumType = node.getUserData(Keys.TYPE_DEFINITION);
        if (enumType != null && enumType.isAnonymous() || !members.isEmpty()) {
            BraceStyle braceStyle = this.policy.AnonymousClassBraceStyle;
            this.openBrace(braceStyle);
            boolean first = true;
            EntityDeclaration lastMember = null;
            for (EntityDeclaration member : node.getMembers()) {
                if (first) {
                    first = false;
                } else {
                    int blankLines = member instanceof FieldDeclaration && lastMember instanceof FieldDeclaration ? this.policy.BlankLinesBetweenFields : this.policy.BlankLinesBetweenMembers;
                    for (int i = 0; i < blankLines; ++i) {
                        this.formatter.newLine();
                    }
                }
                member.acceptVisitor(this, ignored);
                lastMember = member;
            }
            this.closeBrace(braceStyle);
        }
        boolean isLast = true;
        for (AstNode next = node.getNextSibling(); next != null; next = next.getNextSibling()) {
            if (next.getRole() != Roles.TYPE_MEMBER) continue;
            if (!(next instanceof EnumValueDeclaration)) break;
            isLast = false;
            break;
        }
        if (isLast) {
            this.semicolon();
        } else {
            this.comma(node.getNextSibling());
        }
        this.endNode(node);
        return null;
    }

    @Override
    public Void visitAssertStatement(AssertStatement node, Void ignored) {
        this.startNode(node);
        this.writeKeyword(AssertStatement.ASSERT_KEYWORD_ROLE);
        this.space();
        node.getCondition().acceptVisitor(this, ignored);
        Expression message = node.getMessage();
        if (message != null && !message.isNull()) {
            this.space();
            this.writeToken(Roles.COLON);
            this.space();
            message.acceptVisitor(this, ignored);
        }
        this.semicolon();
        this.endNode(node);
        return null;
    }

    @Override
    public Void visitLambdaExpression(LambdaExpression node, Void ignored) {
        this.startNode(node);
        if (JavaOutputVisitor.lambdaNeedsParenthesis(node)) {
            this.writeCommaSeparatedListInParenthesis(node.getParameters(), this.policy.SpaceWithinMethodDeclarationParentheses);
        } else {
            node.getParameters().firstOrNullObject().acceptVisitor(this, ignored);
        }
        this.space();
        this.writeToken(LambdaExpression.ARROW_ROLE);
        if (!(node.getBody() instanceof BlockStatement)) {
            this.space();
        }
        node.getBody().acceptVisitor(this, ignored);
        this.endNode(node);
        return null;
    }

    private static boolean lambdaNeedsParenthesis(LambdaExpression lambda) {
        return lambda.getParameters().size() != 1 || !lambda.getParameters().firstOrNullObject().getType().isNull();
    }

    @Override
    public Void visitArrayCreationExpression(ArrayCreationExpression node, Void ignored) {
        this.startNode(node);
        boolean needType = true;
        if (node.getDimensions().isEmpty() && node.getType() != null && (node.getParent() instanceof ArrayInitializerExpression || node.getParent() instanceof VariableInitializer)) {
            needType = false;
        }
        if (needType) {
            this.writeKeyword(ArrayCreationExpression.NEW_KEYWORD_ROLE);
            node.getType().acceptVisitor(this, ignored);
            for (Expression dimension : node.getDimensions()) {
                this.writeToken(Roles.LEFT_BRACKET);
                dimension.acceptVisitor(this, ignored);
                this.writeToken(Roles.RIGHT_BRACKET);
            }
            for (ArraySpecifier specifier : node.getAdditionalArraySpecifiers()) {
                specifier.acceptVisitor(this, ignored);
            }
            if (node.getInitializer() != null && !node.getInitializer().isNull()) {
                this.space();
            }
        }
        node.getInitializer().acceptVisitor(this, ignored);
        this.endNode(node);
        return null;
    }

    @Override
    public Void visitAssignmentExpression(AssignmentExpression node, Void ignored) {
        this.startNode(node);
        node.getLeft().acceptVisitor(this, ignored);
        this.space(this.policy.SpaceAroundAssignment);
        this.writeToken(AssignmentExpression.getOperatorRole(node.getOperator()));
        this.space(this.policy.SpaceAroundAssignment);
        node.getRight().acceptVisitor(this, ignored);
        this.endNode(node);
        return null;
    }

    @Override
    public Void visitForStatement(ForStatement node, Void ignored) {
        this.startNode(node);
        this.writeKeyword(ForStatement.FOR_KEYWORD_ROLE);
        this.space(this.policy.SpaceBeforeForParentheses);
        this.leftParenthesis();
        this.space(this.policy.SpacesWithinForParentheses);
        this.writeCommaSeparatedList(node.getInitializers());
        this.space(this.policy.SpaceBeforeForSemicolon);
        this.writeToken(Roles.SEMICOLON);
        this.space(this.policy.SpaceAfterForSemicolon);
        node.getCondition().acceptVisitor(this, ignored);
        this.space(this.policy.SpaceBeforeForSemicolon);
        this.writeToken(Roles.SEMICOLON);
        if (CollectionUtilities.any(node.getIterators())) {
            this.space(this.policy.SpaceAfterForSemicolon);
            this.writeCommaSeparatedList(node.getIterators());
        }
        this.space(this.policy.SpacesWithinForParentheses);
        this.rightParenthesis();
        this.writeEmbeddedStatement(node.getEmbeddedStatement());
        this.endNode(node);
        return null;
    }

    @Override
    public Void visitForEachStatement(ForEachStatement node, Void ignored) {
        this.startNode(node);
        this.writeKeyword(ForEachStatement.FOR_KEYWORD_ROLE);
        this.space(this.policy.SpaceBeforeForeachParentheses);
        this.leftParenthesis();
        this.space(this.policy.SpacesWithinForeachParentheses);
        this.writeModifiers(node.getChildrenByRole(EntityDeclaration.MODIFIER_ROLE));
        node.getVariableType().acceptVisitor(this, ignored);
        this.space();
        node.getVariableNameToken().acceptVisitor(this, ignored);
        this.space();
        this.writeToken(ForEachStatement.COLON_ROLE);
        this.space();
        node.getInExpression().acceptVisitor(this, ignored);
        this.space(this.policy.SpacesWithinForeachParentheses);
        this.rightParenthesis();
        this.writeEmbeddedStatement(node.getEmbeddedStatement());
        this.endNode(node);
        return null;
    }

    @Override
    public Void visitTryCatchStatement(TryCatchStatement node, Void ignored) {
        this.startNode(node);
        this.writeKeyword(TryCatchStatement.TRY_KEYWORD_ROLE);
        AstNodeCollection<VariableDeclarationStatement> resources = node.getResources();
        if (!resources.isEmpty()) {
            VariableDeclarationStatement firstResource;
            this.space();
            this.leftParenthesis();
            for (VariableDeclarationStatement resource = firstResource = resources.firstOrNullObject(); resource != null; resource = resource.getNextSibling(TryCatchStatement.TRY_RESOURCE_ROLE)) {
                if (resource != firstResource) {
                    this.semicolon();
                    this.space();
                    this.space();
                    this.space();
                    this.space();
                    this.space();
                }
                this.writeVariableDeclaration(resource, false);
            }
            this.rightParenthesis();
        }
        node.getTryBlock().acceptVisitor(this, ignored);
        for (CatchClause catchClause : node.getCatchClauses()) {
            catchClause.acceptVisitor(this, ignored);
        }
        if (!node.getFinallyBlock().isNull()) {
            this.writeKeyword(TryCatchStatement.FINALLY_KEYWORD_ROLE);
            node.getFinallyBlock().acceptVisitor(this, ignored);
        }
        this.endNode(node);
        return null;
    }

    @Override
    public Void visitGotoStatement(GotoStatement node, Void ignored) {
        this.startNode(node);
        this.writeKeyword(GotoStatement.GOTO_KEYWORD_ROLE);
        this.writeIdentifier(node.getLabel(), Roles.LABEL);
        this.semicolon();
        this.endNode(node);
        return null;
    }

    @Override
    public Void visitParenthesizedExpression(ParenthesizedExpression node, Void ignored) {
        this.startNode(node);
        this.leftParenthesis();
        this.space(this.policy.SpacesWithinParentheses);
        node.getExpression().acceptVisitor(this, ignored);
        this.space(this.policy.SpacesWithinParentheses);
        this.rightParenthesis();
        this.endNode(node);
        return null;
    }

    @Override
    public Void visitSynchronizedStatement(SynchronizedStatement node, Void ignored) {
        this.startNode(node);
        this.writeKeyword(SynchronizedStatement.SYNCHRONIZED_KEYWORD_ROLE);
        this.space(this.policy.SpaceBeforeSynchronizedParentheses);
        this.leftParenthesis();
        this.space(this.policy.SpacesWithinSynchronizedParentheses);
        node.getExpression().acceptVisitor(this, ignored);
        this.space(this.policy.SpacesWithinSynchronizedParentheses);
        this.rightParenthesis();
        this.writeEmbeddedStatement(node.getEmbeddedStatement());
        this.endNode(node);
        return null;
    }

    public static String convertCharacter(char ch) {
        switch (ch) {
            case '\\': {
                return "\\\\";
            }
            case '\u0000': {
                return "\u0000";
            }
            case '\b': {
                return "\\b";
            }
            case '\f': {
                return "\\f";
            }
            case '\n': {
                return "\\n";
            }
            case '\r': {
                return "\\r";
            }
            case '\t': {
                return "\\t";
            }
            case '\"': {
                return "\\\"";
            }
        }
        if (ch >= '\u00c0' || Character.isISOControl(ch) || Character.isSurrogate(ch) || Character.isWhitespace(ch) && ch != ' ') {
            return String.format("\\u%1$04x", ch);
        }
        return String.valueOf(ch);
    }

    public static String escapeUnicode(String s) {
        StringBuilder sb = null;
        int n = s.length();
        for (int i = 0; i < n; ++i) {
            char ch = s.charAt(i);
            if (ch >= '\u00c0' || Character.isISOControl(ch) || Character.isSurrogate(ch) || Character.isWhitespace(ch) && ch != ' ') {
                if (sb == null) {
                    sb = new StringBuilder(Math.max(16, s.length()));
                    if (i > 0) {
                        sb.append(s, 0, i);
                    }
                }
                sb.append(String.format("\\u%1$04x", ch));
                continue;
            }
            if (sb == null) continue;
            sb.append(ch);
        }
        return sb != null ? sb.toString() : s;
    }

    public static boolean isKeyword(String identifier) {
        return ArrayUtilities.contains((Object[])KEYWORDS, (Object)identifier);
    }

    public static boolean isKeyword(String identifier, AstNode context) {
        return ArrayUtilities.contains((Object[])KEYWORDS, (Object)identifier);
    }

    static enum LastWritten {
        Whitespace,
        Other,
        KeywordOrIdentifier,
        Plus,
        Minus,
        Ampersand,
        QuestionMark,
        Division,
        Operator,
        Delimiter,
        LeftParenthesis;

    }
}

