/*
 * Copyright 2014 the original author or authors.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package com.koloboke.collect.set.hash;

import com.koloboke.collect.*;
import com.koloboke.collect.hash.*;
import com.koloboke.compile.CustomKeyEquivalence;
import com.koloboke.compile.KolobokeSet;
import java.util.function.Consumer;
import com.koloboke.collect.set.IntSetFactory;

import javax.annotation.Nonnull;

import java.util.Iterator;


/**
 * An immutable factory of {@code HashIntSet}s.
 *
 * @see HashIntSet
 * @see HashIntSets#getDefaultFactory()
 * @see KolobokeSet @KolobokeSet
 */
public interface HashIntSetFactory
        extends IntSetFactory<HashIntSetFactory>
        , IntHashFactory<HashIntSetFactory>
         {



    

    

    

    @Override
    @Nonnull
     HashIntSet newMutableSet();

    @Override
    @Nonnull
     HashIntSet newMutableSet(int expectedSize);

    

    @Override
    @Nonnull
     HashIntSet newMutableSet(@Nonnull Iterable<Integer> elements, int expectedSize);

    @Override
    @Nonnull
     HashIntSet newMutableSet(@Nonnull Iterable<Integer> elems1,
            @Nonnull Iterable<Integer> elems2, int expectedSize);

    @Override
    @Nonnull
     HashIntSet newMutableSet(@Nonnull Iterable<Integer> elems1,
            @Nonnull Iterable<Integer> elems2,
            @Nonnull Iterable<Integer> elems3, int expectedSize);

    @Override
    @Nonnull
     HashIntSet newMutableSet(@Nonnull Iterable<Integer> elems1,
            @Nonnull Iterable<Integer> elems2,
            @Nonnull Iterable<Integer> elems3,
            @Nonnull Iterable<Integer> elems4, int expectedSize);

    @Override
    @Nonnull
     HashIntSet newMutableSet(@Nonnull Iterable<Integer> elems1,
            @Nonnull Iterable<Integer> elems2,
            @Nonnull Iterable<Integer> elems3,
            @Nonnull Iterable<Integer> elems4,
            @Nonnull Iterable<Integer> elems5, int expectedSize);

    @Override
    @Nonnull
     HashIntSet newMutableSet(@Nonnull Iterator<Integer> elements, int expectedSize);

    @Override
    @Nonnull
     HashIntSet newMutableSet(@Nonnull
            Consumer<com.koloboke.function.IntConsumer> elementsSupplier
            , int expectedSize);

    

    @Override
    @Nonnull
     HashIntSet newMutableSet(@Nonnull int[] elements, int expectedSize);

    @Override
    @Nonnull
     HashIntSet newMutableSet(@Nonnull Integer[] elements, int expectedSize);

    

    @Override
    @Nonnull
     HashIntSet newMutableSet(@Nonnull Iterable<Integer> elements);

    @Override
    @Nonnull
     HashIntSet newMutableSet(@Nonnull Iterable<Integer> elems1,
            @Nonnull Iterable<Integer> elems2);

    @Override
    @Nonnull
     HashIntSet newMutableSet(@Nonnull Iterable<Integer> elems1,
            @Nonnull Iterable<Integer> elems2,
            @Nonnull Iterable<Integer> elems3);

    @Override
    @Nonnull
     HashIntSet newMutableSet(@Nonnull Iterable<Integer> elems1,
            @Nonnull Iterable<Integer> elems2,
            @Nonnull Iterable<Integer> elems3,
            @Nonnull Iterable<Integer> elems4);

    @Override
    @Nonnull
     HashIntSet newMutableSet(@Nonnull Iterable<Integer> elems1,
            @Nonnull Iterable<Integer> elems2,
            @Nonnull Iterable<Integer> elems3,
            @Nonnull Iterable<Integer> elems4,
            @Nonnull Iterable<Integer> elems5);

    @Override
    @Nonnull
     HashIntSet newMutableSet(@Nonnull Iterator<Integer> elements);

    @Override
    @Nonnull
     HashIntSet newMutableSet(@Nonnull
            Consumer<com.koloboke.function.IntConsumer> elementsSupplier
            );

    

    @Override
    @Nonnull
     HashIntSet newMutableSet(@Nonnull int[] elements);

    @Override
    @Nonnull
     HashIntSet newMutableSet(@Nonnull Integer[] elements);


    @Override
    @Nonnull
     HashIntSet newMutableSetOf(int e1);

    @Override
    @Nonnull
     HashIntSet newMutableSetOf(int e1, int e2);

    @Override
    @Nonnull
     HashIntSet newMutableSetOf(int e1, int e2,
            int e3);

    @Override
    @Nonnull
     HashIntSet newMutableSetOf(int e1, int e2,
            int e3, int e4);

    @Override
    @Nonnull
     HashIntSet newMutableSetOf(int e1, int e2,
            int e3, int e4, int e5,
            int... restElements);
    @Override
    @Nonnull
     HashIntSet newUpdatableSet();

    @Override
    @Nonnull
     HashIntSet newUpdatableSet(int expectedSize);

    

    @Override
    @Nonnull
     HashIntSet newUpdatableSet(@Nonnull Iterable<Integer> elements, int expectedSize);

    @Override
    @Nonnull
     HashIntSet newUpdatableSet(@Nonnull Iterable<Integer> elems1,
            @Nonnull Iterable<Integer> elems2, int expectedSize);

    @Override
    @Nonnull
     HashIntSet newUpdatableSet(@Nonnull Iterable<Integer> elems1,
            @Nonnull Iterable<Integer> elems2,
            @Nonnull Iterable<Integer> elems3, int expectedSize);

    @Override
    @Nonnull
     HashIntSet newUpdatableSet(@Nonnull Iterable<Integer> elems1,
            @Nonnull Iterable<Integer> elems2,
            @Nonnull Iterable<Integer> elems3,
            @Nonnull Iterable<Integer> elems4, int expectedSize);

    @Override
    @Nonnull
     HashIntSet newUpdatableSet(@Nonnull Iterable<Integer> elems1,
            @Nonnull Iterable<Integer> elems2,
            @Nonnull Iterable<Integer> elems3,
            @Nonnull Iterable<Integer> elems4,
            @Nonnull Iterable<Integer> elems5, int expectedSize);

    @Override
    @Nonnull
     HashIntSet newUpdatableSet(@Nonnull Iterator<Integer> elements, int expectedSize);

    @Override
    @Nonnull
     HashIntSet newUpdatableSet(@Nonnull
            Consumer<com.koloboke.function.IntConsumer> elementsSupplier
            , int expectedSize);

    

    @Override
    @Nonnull
     HashIntSet newUpdatableSet(@Nonnull int[] elements, int expectedSize);

    @Override
    @Nonnull
     HashIntSet newUpdatableSet(@Nonnull Integer[] elements, int expectedSize);

    

    @Override
    @Nonnull
     HashIntSet newUpdatableSet(@Nonnull Iterable<Integer> elements);

    @Override
    @Nonnull
     HashIntSet newUpdatableSet(@Nonnull Iterable<Integer> elems1,
            @Nonnull Iterable<Integer> elems2);

    @Override
    @Nonnull
     HashIntSet newUpdatableSet(@Nonnull Iterable<Integer> elems1,
            @Nonnull Iterable<Integer> elems2,
            @Nonnull Iterable<Integer> elems3);

    @Override
    @Nonnull
     HashIntSet newUpdatableSet(@Nonnull Iterable<Integer> elems1,
            @Nonnull Iterable<Integer> elems2,
            @Nonnull Iterable<Integer> elems3,
            @Nonnull Iterable<Integer> elems4);

    @Override
    @Nonnull
     HashIntSet newUpdatableSet(@Nonnull Iterable<Integer> elems1,
            @Nonnull Iterable<Integer> elems2,
            @Nonnull Iterable<Integer> elems3,
            @Nonnull Iterable<Integer> elems4,
            @Nonnull Iterable<Integer> elems5);

    @Override
    @Nonnull
     HashIntSet newUpdatableSet(@Nonnull Iterator<Integer> elements);

    @Override
    @Nonnull
     HashIntSet newUpdatableSet(@Nonnull
            Consumer<com.koloboke.function.IntConsumer> elementsSupplier
            );

    

    @Override
    @Nonnull
     HashIntSet newUpdatableSet(@Nonnull int[] elements);

    @Override
    @Nonnull
     HashIntSet newUpdatableSet(@Nonnull Integer[] elements);


    @Override
    @Nonnull
     HashIntSet newUpdatableSetOf(int e1);

    @Override
    @Nonnull
     HashIntSet newUpdatableSetOf(int e1, int e2);

    @Override
    @Nonnull
     HashIntSet newUpdatableSetOf(int e1, int e2,
            int e3);

    @Override
    @Nonnull
     HashIntSet newUpdatableSetOf(int e1, int e2,
            int e3, int e4);

    @Override
    @Nonnull
     HashIntSet newUpdatableSetOf(int e1, int e2,
            int e3, int e4, int e5,
            int... restElements);

    

    @Override
    @Nonnull
     HashIntSet newImmutableSet(@Nonnull Iterable<Integer> elements, int expectedSize);

    @Override
    @Nonnull
     HashIntSet newImmutableSet(@Nonnull Iterable<Integer> elems1,
            @Nonnull Iterable<Integer> elems2, int expectedSize);

    @Override
    @Nonnull
     HashIntSet newImmutableSet(@Nonnull Iterable<Integer> elems1,
            @Nonnull Iterable<Integer> elems2,
            @Nonnull Iterable<Integer> elems3, int expectedSize);

    @Override
    @Nonnull
     HashIntSet newImmutableSet(@Nonnull Iterable<Integer> elems1,
            @Nonnull Iterable<Integer> elems2,
            @Nonnull Iterable<Integer> elems3,
            @Nonnull Iterable<Integer> elems4, int expectedSize);

    @Override
    @Nonnull
     HashIntSet newImmutableSet(@Nonnull Iterable<Integer> elems1,
            @Nonnull Iterable<Integer> elems2,
            @Nonnull Iterable<Integer> elems3,
            @Nonnull Iterable<Integer> elems4,
            @Nonnull Iterable<Integer> elems5, int expectedSize);

    @Override
    @Nonnull
     HashIntSet newImmutableSet(@Nonnull Iterator<Integer> elements, int expectedSize);

    @Override
    @Nonnull
     HashIntSet newImmutableSet(@Nonnull
            Consumer<com.koloboke.function.IntConsumer> elementsSupplier
            , int expectedSize);

    

    @Override
    @Nonnull
     HashIntSet newImmutableSet(@Nonnull int[] elements, int expectedSize);

    @Override
    @Nonnull
     HashIntSet newImmutableSet(@Nonnull Integer[] elements, int expectedSize);

    

    @Override
    @Nonnull
     HashIntSet newImmutableSet(@Nonnull Iterable<Integer> elements);

    @Override
    @Nonnull
     HashIntSet newImmutableSet(@Nonnull Iterable<Integer> elems1,
            @Nonnull Iterable<Integer> elems2);

    @Override
    @Nonnull
     HashIntSet newImmutableSet(@Nonnull Iterable<Integer> elems1,
            @Nonnull Iterable<Integer> elems2,
            @Nonnull Iterable<Integer> elems3);

    @Override
    @Nonnull
     HashIntSet newImmutableSet(@Nonnull Iterable<Integer> elems1,
            @Nonnull Iterable<Integer> elems2,
            @Nonnull Iterable<Integer> elems3,
            @Nonnull Iterable<Integer> elems4);

    @Override
    @Nonnull
     HashIntSet newImmutableSet(@Nonnull Iterable<Integer> elems1,
            @Nonnull Iterable<Integer> elems2,
            @Nonnull Iterable<Integer> elems3,
            @Nonnull Iterable<Integer> elems4,
            @Nonnull Iterable<Integer> elems5);

    @Override
    @Nonnull
     HashIntSet newImmutableSet(@Nonnull Iterator<Integer> elements);

    @Override
    @Nonnull
     HashIntSet newImmutableSet(@Nonnull
            Consumer<com.koloboke.function.IntConsumer> elementsSupplier
            );

    

    @Override
    @Nonnull
     HashIntSet newImmutableSet(@Nonnull int[] elements);

    @Override
    @Nonnull
     HashIntSet newImmutableSet(@Nonnull Integer[] elements);


    @Override
    @Nonnull
     HashIntSet newImmutableSetOf(int e1);

    @Override
    @Nonnull
     HashIntSet newImmutableSetOf(int e1, int e2);

    @Override
    @Nonnull
     HashIntSet newImmutableSetOf(int e1, int e2,
            int e3);

    @Override
    @Nonnull
     HashIntSet newImmutableSetOf(int e1, int e2,
            int e3, int e4);

    @Override
    @Nonnull
     HashIntSet newImmutableSetOf(int e1, int e2,
            int e3, int e4, int e5,
            int... restElements);
}
