/*
 * Copyright 2014 the original author or authors.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package com.koloboke.collect.set.hash;

import com.koloboke.collect.*;
import com.koloboke.collect.hash.*;
import com.koloboke.compile.CustomKeyEquivalence;
import com.koloboke.compile.KolobokeSet;
import java.util.function.Consumer;
import com.koloboke.collect.set.FloatSetFactory;

import javax.annotation.Nonnull;

import java.util.Iterator;


/**
 * An immutable factory of {@code HashFloatSet}s.
 *
 * @see HashFloatSet
 * @see HashFloatSets#getDefaultFactory()
 * @see KolobokeSet @KolobokeSet
 */
public interface HashFloatSetFactory
        extends FloatSetFactory<HashFloatSetFactory>
        , HashContainerFactory<HashFloatSetFactory> {



    

    

    

    @Override
    @Nonnull
     HashFloatSet newMutableSet();

    @Override
    @Nonnull
     HashFloatSet newMutableSet(int expectedSize);

    

    @Override
    @Nonnull
     HashFloatSet newMutableSet(@Nonnull Iterable<Float> elements, int expectedSize);

    @Override
    @Nonnull
     HashFloatSet newMutableSet(@Nonnull Iterable<Float> elems1,
            @Nonnull Iterable<Float> elems2, int expectedSize);

    @Override
    @Nonnull
     HashFloatSet newMutableSet(@Nonnull Iterable<Float> elems1,
            @Nonnull Iterable<Float> elems2,
            @Nonnull Iterable<Float> elems3, int expectedSize);

    @Override
    @Nonnull
     HashFloatSet newMutableSet(@Nonnull Iterable<Float> elems1,
            @Nonnull Iterable<Float> elems2,
            @Nonnull Iterable<Float> elems3,
            @Nonnull Iterable<Float> elems4, int expectedSize);

    @Override
    @Nonnull
     HashFloatSet newMutableSet(@Nonnull Iterable<Float> elems1,
            @Nonnull Iterable<Float> elems2,
            @Nonnull Iterable<Float> elems3,
            @Nonnull Iterable<Float> elems4,
            @Nonnull Iterable<Float> elems5, int expectedSize);

    @Override
    @Nonnull
     HashFloatSet newMutableSet(@Nonnull Iterator<Float> elements, int expectedSize);

    @Override
    @Nonnull
     HashFloatSet newMutableSet(@Nonnull
            Consumer<com.koloboke.function.FloatConsumer> elementsSupplier
            , int expectedSize);

    

    @Override
    @Nonnull
     HashFloatSet newMutableSet(@Nonnull float[] elements, int expectedSize);

    @Override
    @Nonnull
     HashFloatSet newMutableSet(@Nonnull Float[] elements, int expectedSize);

    

    @Override
    @Nonnull
     HashFloatSet newMutableSet(@Nonnull Iterable<Float> elements);

    @Override
    @Nonnull
     HashFloatSet newMutableSet(@Nonnull Iterable<Float> elems1,
            @Nonnull Iterable<Float> elems2);

    @Override
    @Nonnull
     HashFloatSet newMutableSet(@Nonnull Iterable<Float> elems1,
            @Nonnull Iterable<Float> elems2,
            @Nonnull Iterable<Float> elems3);

    @Override
    @Nonnull
     HashFloatSet newMutableSet(@Nonnull Iterable<Float> elems1,
            @Nonnull Iterable<Float> elems2,
            @Nonnull Iterable<Float> elems3,
            @Nonnull Iterable<Float> elems4);

    @Override
    @Nonnull
     HashFloatSet newMutableSet(@Nonnull Iterable<Float> elems1,
            @Nonnull Iterable<Float> elems2,
            @Nonnull Iterable<Float> elems3,
            @Nonnull Iterable<Float> elems4,
            @Nonnull Iterable<Float> elems5);

    @Override
    @Nonnull
     HashFloatSet newMutableSet(@Nonnull Iterator<Float> elements);

    @Override
    @Nonnull
     HashFloatSet newMutableSet(@Nonnull
            Consumer<com.koloboke.function.FloatConsumer> elementsSupplier
            );

    

    @Override
    @Nonnull
     HashFloatSet newMutableSet(@Nonnull float[] elements);

    @Override
    @Nonnull
     HashFloatSet newMutableSet(@Nonnull Float[] elements);


    @Override
    @Nonnull
     HashFloatSet newMutableSetOf(float e1);

    @Override
    @Nonnull
     HashFloatSet newMutableSetOf(float e1, float e2);

    @Override
    @Nonnull
     HashFloatSet newMutableSetOf(float e1, float e2,
            float e3);

    @Override
    @Nonnull
     HashFloatSet newMutableSetOf(float e1, float e2,
            float e3, float e4);

    @Override
    @Nonnull
     HashFloatSet newMutableSetOf(float e1, float e2,
            float e3, float e4, float e5,
            float... restElements);
    @Override
    @Nonnull
     HashFloatSet newUpdatableSet();

    @Override
    @Nonnull
     HashFloatSet newUpdatableSet(int expectedSize);

    

    @Override
    @Nonnull
     HashFloatSet newUpdatableSet(@Nonnull Iterable<Float> elements, int expectedSize);

    @Override
    @Nonnull
     HashFloatSet newUpdatableSet(@Nonnull Iterable<Float> elems1,
            @Nonnull Iterable<Float> elems2, int expectedSize);

    @Override
    @Nonnull
     HashFloatSet newUpdatableSet(@Nonnull Iterable<Float> elems1,
            @Nonnull Iterable<Float> elems2,
            @Nonnull Iterable<Float> elems3, int expectedSize);

    @Override
    @Nonnull
     HashFloatSet newUpdatableSet(@Nonnull Iterable<Float> elems1,
            @Nonnull Iterable<Float> elems2,
            @Nonnull Iterable<Float> elems3,
            @Nonnull Iterable<Float> elems4, int expectedSize);

    @Override
    @Nonnull
     HashFloatSet newUpdatableSet(@Nonnull Iterable<Float> elems1,
            @Nonnull Iterable<Float> elems2,
            @Nonnull Iterable<Float> elems3,
            @Nonnull Iterable<Float> elems4,
            @Nonnull Iterable<Float> elems5, int expectedSize);

    @Override
    @Nonnull
     HashFloatSet newUpdatableSet(@Nonnull Iterator<Float> elements, int expectedSize);

    @Override
    @Nonnull
     HashFloatSet newUpdatableSet(@Nonnull
            Consumer<com.koloboke.function.FloatConsumer> elementsSupplier
            , int expectedSize);

    

    @Override
    @Nonnull
     HashFloatSet newUpdatableSet(@Nonnull float[] elements, int expectedSize);

    @Override
    @Nonnull
     HashFloatSet newUpdatableSet(@Nonnull Float[] elements, int expectedSize);

    

    @Override
    @Nonnull
     HashFloatSet newUpdatableSet(@Nonnull Iterable<Float> elements);

    @Override
    @Nonnull
     HashFloatSet newUpdatableSet(@Nonnull Iterable<Float> elems1,
            @Nonnull Iterable<Float> elems2);

    @Override
    @Nonnull
     HashFloatSet newUpdatableSet(@Nonnull Iterable<Float> elems1,
            @Nonnull Iterable<Float> elems2,
            @Nonnull Iterable<Float> elems3);

    @Override
    @Nonnull
     HashFloatSet newUpdatableSet(@Nonnull Iterable<Float> elems1,
            @Nonnull Iterable<Float> elems2,
            @Nonnull Iterable<Float> elems3,
            @Nonnull Iterable<Float> elems4);

    @Override
    @Nonnull
     HashFloatSet newUpdatableSet(@Nonnull Iterable<Float> elems1,
            @Nonnull Iterable<Float> elems2,
            @Nonnull Iterable<Float> elems3,
            @Nonnull Iterable<Float> elems4,
            @Nonnull Iterable<Float> elems5);

    @Override
    @Nonnull
     HashFloatSet newUpdatableSet(@Nonnull Iterator<Float> elements);

    @Override
    @Nonnull
     HashFloatSet newUpdatableSet(@Nonnull
            Consumer<com.koloboke.function.FloatConsumer> elementsSupplier
            );

    

    @Override
    @Nonnull
     HashFloatSet newUpdatableSet(@Nonnull float[] elements);

    @Override
    @Nonnull
     HashFloatSet newUpdatableSet(@Nonnull Float[] elements);


    @Override
    @Nonnull
     HashFloatSet newUpdatableSetOf(float e1);

    @Override
    @Nonnull
     HashFloatSet newUpdatableSetOf(float e1, float e2);

    @Override
    @Nonnull
     HashFloatSet newUpdatableSetOf(float e1, float e2,
            float e3);

    @Override
    @Nonnull
     HashFloatSet newUpdatableSetOf(float e1, float e2,
            float e3, float e4);

    @Override
    @Nonnull
     HashFloatSet newUpdatableSetOf(float e1, float e2,
            float e3, float e4, float e5,
            float... restElements);

    

    @Override
    @Nonnull
     HashFloatSet newImmutableSet(@Nonnull Iterable<Float> elements, int expectedSize);

    @Override
    @Nonnull
     HashFloatSet newImmutableSet(@Nonnull Iterable<Float> elems1,
            @Nonnull Iterable<Float> elems2, int expectedSize);

    @Override
    @Nonnull
     HashFloatSet newImmutableSet(@Nonnull Iterable<Float> elems1,
            @Nonnull Iterable<Float> elems2,
            @Nonnull Iterable<Float> elems3, int expectedSize);

    @Override
    @Nonnull
     HashFloatSet newImmutableSet(@Nonnull Iterable<Float> elems1,
            @Nonnull Iterable<Float> elems2,
            @Nonnull Iterable<Float> elems3,
            @Nonnull Iterable<Float> elems4, int expectedSize);

    @Override
    @Nonnull
     HashFloatSet newImmutableSet(@Nonnull Iterable<Float> elems1,
            @Nonnull Iterable<Float> elems2,
            @Nonnull Iterable<Float> elems3,
            @Nonnull Iterable<Float> elems4,
            @Nonnull Iterable<Float> elems5, int expectedSize);

    @Override
    @Nonnull
     HashFloatSet newImmutableSet(@Nonnull Iterator<Float> elements, int expectedSize);

    @Override
    @Nonnull
     HashFloatSet newImmutableSet(@Nonnull
            Consumer<com.koloboke.function.FloatConsumer> elementsSupplier
            , int expectedSize);

    

    @Override
    @Nonnull
     HashFloatSet newImmutableSet(@Nonnull float[] elements, int expectedSize);

    @Override
    @Nonnull
     HashFloatSet newImmutableSet(@Nonnull Float[] elements, int expectedSize);

    

    @Override
    @Nonnull
     HashFloatSet newImmutableSet(@Nonnull Iterable<Float> elements);

    @Override
    @Nonnull
     HashFloatSet newImmutableSet(@Nonnull Iterable<Float> elems1,
            @Nonnull Iterable<Float> elems2);

    @Override
    @Nonnull
     HashFloatSet newImmutableSet(@Nonnull Iterable<Float> elems1,
            @Nonnull Iterable<Float> elems2,
            @Nonnull Iterable<Float> elems3);

    @Override
    @Nonnull
     HashFloatSet newImmutableSet(@Nonnull Iterable<Float> elems1,
            @Nonnull Iterable<Float> elems2,
            @Nonnull Iterable<Float> elems3,
            @Nonnull Iterable<Float> elems4);

    @Override
    @Nonnull
     HashFloatSet newImmutableSet(@Nonnull Iterable<Float> elems1,
            @Nonnull Iterable<Float> elems2,
            @Nonnull Iterable<Float> elems3,
            @Nonnull Iterable<Float> elems4,
            @Nonnull Iterable<Float> elems5);

    @Override
    @Nonnull
     HashFloatSet newImmutableSet(@Nonnull Iterator<Float> elements);

    @Override
    @Nonnull
     HashFloatSet newImmutableSet(@Nonnull
            Consumer<com.koloboke.function.FloatConsumer> elementsSupplier
            );

    

    @Override
    @Nonnull
     HashFloatSet newImmutableSet(@Nonnull float[] elements);

    @Override
    @Nonnull
     HashFloatSet newImmutableSet(@Nonnull Float[] elements);


    @Override
    @Nonnull
     HashFloatSet newImmutableSetOf(float e1);

    @Override
    @Nonnull
     HashFloatSet newImmutableSetOf(float e1, float e2);

    @Override
    @Nonnull
     HashFloatSet newImmutableSetOf(float e1, float e2,
            float e3);

    @Override
    @Nonnull
     HashFloatSet newImmutableSetOf(float e1, float e2,
            float e3, float e4);

    @Override
    @Nonnull
     HashFloatSet newImmutableSetOf(float e1, float e2,
            float e3, float e4, float e5,
            float... restElements);
}
