/*
 * Copyright 2014 the original author or authors.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package com.koloboke.collect.set.hash;

import com.koloboke.collect.*;
import com.koloboke.collect.hash.*;
import com.koloboke.compile.CustomKeyEquivalence;
import com.koloboke.compile.KolobokeSet;
import java.util.function.Consumer;
import com.koloboke.collect.set.ByteSetFactory;

import javax.annotation.Nonnull;

import java.util.Iterator;


/**
 * An immutable factory of {@code HashByteSet}s.
 *
 * @see HashByteSet
 * @see HashByteSets#getDefaultFactory()
 * @see KolobokeSet @KolobokeSet
 */
public interface HashByteSetFactory
        extends ByteSetFactory<HashByteSetFactory>
        , ByteHashFactory<HashByteSetFactory>
         {



    

    

    

    @Override
    @Nonnull
     HashByteSet newMutableSet();

    @Override
    @Nonnull
     HashByteSet newMutableSet(int expectedSize);

    

    @Override
    @Nonnull
     HashByteSet newMutableSet(@Nonnull Iterable<Byte> elements, int expectedSize);

    @Override
    @Nonnull
     HashByteSet newMutableSet(@Nonnull Iterable<Byte> elems1,
            @Nonnull Iterable<Byte> elems2, int expectedSize);

    @Override
    @Nonnull
     HashByteSet newMutableSet(@Nonnull Iterable<Byte> elems1,
            @Nonnull Iterable<Byte> elems2,
            @Nonnull Iterable<Byte> elems3, int expectedSize);

    @Override
    @Nonnull
     HashByteSet newMutableSet(@Nonnull Iterable<Byte> elems1,
            @Nonnull Iterable<Byte> elems2,
            @Nonnull Iterable<Byte> elems3,
            @Nonnull Iterable<Byte> elems4, int expectedSize);

    @Override
    @Nonnull
     HashByteSet newMutableSet(@Nonnull Iterable<Byte> elems1,
            @Nonnull Iterable<Byte> elems2,
            @Nonnull Iterable<Byte> elems3,
            @Nonnull Iterable<Byte> elems4,
            @Nonnull Iterable<Byte> elems5, int expectedSize);

    @Override
    @Nonnull
     HashByteSet newMutableSet(@Nonnull Iterator<Byte> elements, int expectedSize);

    @Override
    @Nonnull
     HashByteSet newMutableSet(@Nonnull
            Consumer<com.koloboke.function.ByteConsumer> elementsSupplier
            , int expectedSize);

    

    @Override
    @Nonnull
     HashByteSet newMutableSet(@Nonnull byte[] elements, int expectedSize);

    @Override
    @Nonnull
     HashByteSet newMutableSet(@Nonnull Byte[] elements, int expectedSize);

    

    @Override
    @Nonnull
     HashByteSet newMutableSet(@Nonnull Iterable<Byte> elements);

    @Override
    @Nonnull
     HashByteSet newMutableSet(@Nonnull Iterable<Byte> elems1,
            @Nonnull Iterable<Byte> elems2);

    @Override
    @Nonnull
     HashByteSet newMutableSet(@Nonnull Iterable<Byte> elems1,
            @Nonnull Iterable<Byte> elems2,
            @Nonnull Iterable<Byte> elems3);

    @Override
    @Nonnull
     HashByteSet newMutableSet(@Nonnull Iterable<Byte> elems1,
            @Nonnull Iterable<Byte> elems2,
            @Nonnull Iterable<Byte> elems3,
            @Nonnull Iterable<Byte> elems4);

    @Override
    @Nonnull
     HashByteSet newMutableSet(@Nonnull Iterable<Byte> elems1,
            @Nonnull Iterable<Byte> elems2,
            @Nonnull Iterable<Byte> elems3,
            @Nonnull Iterable<Byte> elems4,
            @Nonnull Iterable<Byte> elems5);

    @Override
    @Nonnull
     HashByteSet newMutableSet(@Nonnull Iterator<Byte> elements);

    @Override
    @Nonnull
     HashByteSet newMutableSet(@Nonnull
            Consumer<com.koloboke.function.ByteConsumer> elementsSupplier
            );

    

    @Override
    @Nonnull
     HashByteSet newMutableSet(@Nonnull byte[] elements);

    @Override
    @Nonnull
     HashByteSet newMutableSet(@Nonnull Byte[] elements);


    @Override
    @Nonnull
     HashByteSet newMutableSetOf(byte e1);

    @Override
    @Nonnull
     HashByteSet newMutableSetOf(byte e1, byte e2);

    @Override
    @Nonnull
     HashByteSet newMutableSetOf(byte e1, byte e2,
            byte e3);

    @Override
    @Nonnull
     HashByteSet newMutableSetOf(byte e1, byte e2,
            byte e3, byte e4);

    @Override
    @Nonnull
     HashByteSet newMutableSetOf(byte e1, byte e2,
            byte e3, byte e4, byte e5,
            byte... restElements);
    @Override
    @Nonnull
     HashByteSet newUpdatableSet();

    @Override
    @Nonnull
     HashByteSet newUpdatableSet(int expectedSize);

    

    @Override
    @Nonnull
     HashByteSet newUpdatableSet(@Nonnull Iterable<Byte> elements, int expectedSize);

    @Override
    @Nonnull
     HashByteSet newUpdatableSet(@Nonnull Iterable<Byte> elems1,
            @Nonnull Iterable<Byte> elems2, int expectedSize);

    @Override
    @Nonnull
     HashByteSet newUpdatableSet(@Nonnull Iterable<Byte> elems1,
            @Nonnull Iterable<Byte> elems2,
            @Nonnull Iterable<Byte> elems3, int expectedSize);

    @Override
    @Nonnull
     HashByteSet newUpdatableSet(@Nonnull Iterable<Byte> elems1,
            @Nonnull Iterable<Byte> elems2,
            @Nonnull Iterable<Byte> elems3,
            @Nonnull Iterable<Byte> elems4, int expectedSize);

    @Override
    @Nonnull
     HashByteSet newUpdatableSet(@Nonnull Iterable<Byte> elems1,
            @Nonnull Iterable<Byte> elems2,
            @Nonnull Iterable<Byte> elems3,
            @Nonnull Iterable<Byte> elems4,
            @Nonnull Iterable<Byte> elems5, int expectedSize);

    @Override
    @Nonnull
     HashByteSet newUpdatableSet(@Nonnull Iterator<Byte> elements, int expectedSize);

    @Override
    @Nonnull
     HashByteSet newUpdatableSet(@Nonnull
            Consumer<com.koloboke.function.ByteConsumer> elementsSupplier
            , int expectedSize);

    

    @Override
    @Nonnull
     HashByteSet newUpdatableSet(@Nonnull byte[] elements, int expectedSize);

    @Override
    @Nonnull
     HashByteSet newUpdatableSet(@Nonnull Byte[] elements, int expectedSize);

    

    @Override
    @Nonnull
     HashByteSet newUpdatableSet(@Nonnull Iterable<Byte> elements);

    @Override
    @Nonnull
     HashByteSet newUpdatableSet(@Nonnull Iterable<Byte> elems1,
            @Nonnull Iterable<Byte> elems2);

    @Override
    @Nonnull
     HashByteSet newUpdatableSet(@Nonnull Iterable<Byte> elems1,
            @Nonnull Iterable<Byte> elems2,
            @Nonnull Iterable<Byte> elems3);

    @Override
    @Nonnull
     HashByteSet newUpdatableSet(@Nonnull Iterable<Byte> elems1,
            @Nonnull Iterable<Byte> elems2,
            @Nonnull Iterable<Byte> elems3,
            @Nonnull Iterable<Byte> elems4);

    @Override
    @Nonnull
     HashByteSet newUpdatableSet(@Nonnull Iterable<Byte> elems1,
            @Nonnull Iterable<Byte> elems2,
            @Nonnull Iterable<Byte> elems3,
            @Nonnull Iterable<Byte> elems4,
            @Nonnull Iterable<Byte> elems5);

    @Override
    @Nonnull
     HashByteSet newUpdatableSet(@Nonnull Iterator<Byte> elements);

    @Override
    @Nonnull
     HashByteSet newUpdatableSet(@Nonnull
            Consumer<com.koloboke.function.ByteConsumer> elementsSupplier
            );

    

    @Override
    @Nonnull
     HashByteSet newUpdatableSet(@Nonnull byte[] elements);

    @Override
    @Nonnull
     HashByteSet newUpdatableSet(@Nonnull Byte[] elements);


    @Override
    @Nonnull
     HashByteSet newUpdatableSetOf(byte e1);

    @Override
    @Nonnull
     HashByteSet newUpdatableSetOf(byte e1, byte e2);

    @Override
    @Nonnull
     HashByteSet newUpdatableSetOf(byte e1, byte e2,
            byte e3);

    @Override
    @Nonnull
     HashByteSet newUpdatableSetOf(byte e1, byte e2,
            byte e3, byte e4);

    @Override
    @Nonnull
     HashByteSet newUpdatableSetOf(byte e1, byte e2,
            byte e3, byte e4, byte e5,
            byte... restElements);

    

    @Override
    @Nonnull
     HashByteSet newImmutableSet(@Nonnull Iterable<Byte> elements, int expectedSize);

    @Override
    @Nonnull
     HashByteSet newImmutableSet(@Nonnull Iterable<Byte> elems1,
            @Nonnull Iterable<Byte> elems2, int expectedSize);

    @Override
    @Nonnull
     HashByteSet newImmutableSet(@Nonnull Iterable<Byte> elems1,
            @Nonnull Iterable<Byte> elems2,
            @Nonnull Iterable<Byte> elems3, int expectedSize);

    @Override
    @Nonnull
     HashByteSet newImmutableSet(@Nonnull Iterable<Byte> elems1,
            @Nonnull Iterable<Byte> elems2,
            @Nonnull Iterable<Byte> elems3,
            @Nonnull Iterable<Byte> elems4, int expectedSize);

    @Override
    @Nonnull
     HashByteSet newImmutableSet(@Nonnull Iterable<Byte> elems1,
            @Nonnull Iterable<Byte> elems2,
            @Nonnull Iterable<Byte> elems3,
            @Nonnull Iterable<Byte> elems4,
            @Nonnull Iterable<Byte> elems5, int expectedSize);

    @Override
    @Nonnull
     HashByteSet newImmutableSet(@Nonnull Iterator<Byte> elements, int expectedSize);

    @Override
    @Nonnull
     HashByteSet newImmutableSet(@Nonnull
            Consumer<com.koloboke.function.ByteConsumer> elementsSupplier
            , int expectedSize);

    

    @Override
    @Nonnull
     HashByteSet newImmutableSet(@Nonnull byte[] elements, int expectedSize);

    @Override
    @Nonnull
     HashByteSet newImmutableSet(@Nonnull Byte[] elements, int expectedSize);

    

    @Override
    @Nonnull
     HashByteSet newImmutableSet(@Nonnull Iterable<Byte> elements);

    @Override
    @Nonnull
     HashByteSet newImmutableSet(@Nonnull Iterable<Byte> elems1,
            @Nonnull Iterable<Byte> elems2);

    @Override
    @Nonnull
     HashByteSet newImmutableSet(@Nonnull Iterable<Byte> elems1,
            @Nonnull Iterable<Byte> elems2,
            @Nonnull Iterable<Byte> elems3);

    @Override
    @Nonnull
     HashByteSet newImmutableSet(@Nonnull Iterable<Byte> elems1,
            @Nonnull Iterable<Byte> elems2,
            @Nonnull Iterable<Byte> elems3,
            @Nonnull Iterable<Byte> elems4);

    @Override
    @Nonnull
     HashByteSet newImmutableSet(@Nonnull Iterable<Byte> elems1,
            @Nonnull Iterable<Byte> elems2,
            @Nonnull Iterable<Byte> elems3,
            @Nonnull Iterable<Byte> elems4,
            @Nonnull Iterable<Byte> elems5);

    @Override
    @Nonnull
     HashByteSet newImmutableSet(@Nonnull Iterator<Byte> elements);

    @Override
    @Nonnull
     HashByteSet newImmutableSet(@Nonnull
            Consumer<com.koloboke.function.ByteConsumer> elementsSupplier
            );

    

    @Override
    @Nonnull
     HashByteSet newImmutableSet(@Nonnull byte[] elements);

    @Override
    @Nonnull
     HashByteSet newImmutableSet(@Nonnull Byte[] elements);


    @Override
    @Nonnull
     HashByteSet newImmutableSetOf(byte e1);

    @Override
    @Nonnull
     HashByteSet newImmutableSetOf(byte e1, byte e2);

    @Override
    @Nonnull
     HashByteSet newImmutableSetOf(byte e1, byte e2,
            byte e3);

    @Override
    @Nonnull
     HashByteSet newImmutableSetOf(byte e1, byte e2,
            byte e3, byte e4);

    @Override
    @Nonnull
     HashByteSet newImmutableSetOf(byte e1, byte e2,
            byte e3, byte e4, byte e5,
            byte... restElements);
}
