/*
 * Copyright 2014 the original author or authors.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package com.koloboke.collect.map.hash;

import com.koloboke.collect.*;
import com.koloboke.collect.hash.*;
import com.koloboke.compile.CustomKeyEquivalence;
import com.koloboke.compile.KolobokeMap;
import java.util.function.Consumer;
import com.koloboke.collect.map.*;

import javax.annotation.Nonnull;

import java.util.Map;



/**
 * An immutable factory of {@code HashShortIntMap}s.
 *
 * @see HashShortIntMap
 * @see HashShortIntMaps#getDefaultFactory()
 * @see KolobokeMap @KolobokeMap
 */
public interface HashShortIntMapFactory
        extends ShortIntMapFactory<HashShortIntMapFactory>
        , ShortHashFactory<HashShortIntMapFactory>
        {


    

    

    

    

    

    
    

    
    


    @Override
    @Nonnull
     HashShortIntMap newMutableMap();

    @Override
    @Nonnull
     HashShortIntMap newMutableMap(int expectedSize);

    


    @Override
    @Nonnull
     HashShortIntMap newMutableMap(@Nonnull Map<Short, Integer> map1,
            @Nonnull Map<Short, Integer> map2, int expectedSize);

    @Override
    @Nonnull
     HashShortIntMap newMutableMap(@Nonnull Map<Short, Integer> map1,
            @Nonnull Map<Short, Integer> map2,
            @Nonnull Map<Short, Integer> map3, int expectedSize);

    @Override
    @Nonnull
     HashShortIntMap newMutableMap(@Nonnull Map<Short, Integer> map1,
            @Nonnull Map<Short, Integer> map2,
            @Nonnull Map<Short, Integer> map3,
            @Nonnull Map<Short, Integer> map4, int expectedSize);

    @Override
    @Nonnull
     HashShortIntMap newMutableMap(@Nonnull Map<Short, Integer> map1,
            @Nonnull Map<Short, Integer> map2,
            @Nonnull Map<Short, Integer> map3,
            @Nonnull Map<Short, Integer> map4,
            @Nonnull Map<Short, Integer> map5, int expectedSize);



    @Override
    @Nonnull
     HashShortIntMap newMutableMap(@Nonnull
            Consumer<com.koloboke.function.ShortIntConsumer> entriesSupplier
            , int expectedSize);

    @Override
    @Nonnull
     HashShortIntMap newMutableMap(
            @Nonnull short[] keys, @Nonnull int[] values, int expectedSize);

    @Override
    @Nonnull
     HashShortIntMap newMutableMap(
            @Nonnull Short[] keys, @Nonnull Integer[] values, int expectedSize);

    @Override
    @Nonnull
     HashShortIntMap newMutableMap(@Nonnull Iterable<Short> keys,
            @Nonnull Iterable<Integer> values, int expectedSize);

    

    @Override
    @Nonnull
     HashShortIntMap newMutableMap(
            @Nonnull Map<Short, Integer> map);

    @Override
    @Nonnull
     HashShortIntMap newMutableMap(@Nonnull Map<Short, Integer> map1,
            @Nonnull Map<Short, Integer> map2);

    @Override
    @Nonnull
     HashShortIntMap newMutableMap(@Nonnull Map<Short, Integer> map1,
            @Nonnull Map<Short, Integer> map2,
            @Nonnull Map<Short, Integer> map3);

    @Override
    @Nonnull
     HashShortIntMap newMutableMap(@Nonnull Map<Short, Integer> map1,
            @Nonnull Map<Short, Integer> map2,
            @Nonnull Map<Short, Integer> map3,
            @Nonnull Map<Short, Integer> map4);

    @Override
    @Nonnull
     HashShortIntMap newMutableMap(@Nonnull Map<Short, Integer> map1,
            @Nonnull Map<Short, Integer> map2,
            @Nonnull Map<Short, Integer> map3,
            @Nonnull Map<Short, Integer> map4,
            @Nonnull Map<Short, Integer> map5);



    @Override
    @Nonnull
     HashShortIntMap newMutableMap(@Nonnull
            Consumer<com.koloboke.function.ShortIntConsumer> entriesSupplier
            );

    @Override
    @Nonnull
     HashShortIntMap newMutableMap(
            @Nonnull short[] keys, @Nonnull int[] values);

    @Override
    @Nonnull
     HashShortIntMap newMutableMap(
            @Nonnull Short[] keys, @Nonnull Integer[] values);

    @Override
    @Nonnull
     HashShortIntMap newMutableMap(@Nonnull Iterable<Short> keys,
            @Nonnull Iterable<Integer> values);


    @Override
    @Nonnull
     HashShortIntMap newMutableMapOf(short k1, int v1);

    @Override
    @Nonnull
     HashShortIntMap newMutableMapOf(short k1, int v1,
            short k2, int v2);

    @Override
    @Nonnull
     HashShortIntMap newMutableMapOf(short k1, int v1,
            short k2, int v2, short k3, int v3);

    @Override
    @Nonnull
     HashShortIntMap newMutableMapOf(short k1, int v1,
            short k2, int v2, short k3, int v3,
            short k4, int v4);

    @Override
    @Nonnull
     HashShortIntMap newMutableMapOf(short k1, int v1,
            short k2, int v2, short k3, int v3,
            short k4, int v4, short k5, int v5);
    @Override
    @Nonnull
     HashShortIntMap newUpdatableMap();

    @Override
    @Nonnull
     HashShortIntMap newUpdatableMap(int expectedSize);

    


    @Override
    @Nonnull
     HashShortIntMap newUpdatableMap(@Nonnull Map<Short, Integer> map1,
            @Nonnull Map<Short, Integer> map2, int expectedSize);

    @Override
    @Nonnull
     HashShortIntMap newUpdatableMap(@Nonnull Map<Short, Integer> map1,
            @Nonnull Map<Short, Integer> map2,
            @Nonnull Map<Short, Integer> map3, int expectedSize);

    @Override
    @Nonnull
     HashShortIntMap newUpdatableMap(@Nonnull Map<Short, Integer> map1,
            @Nonnull Map<Short, Integer> map2,
            @Nonnull Map<Short, Integer> map3,
            @Nonnull Map<Short, Integer> map4, int expectedSize);

    @Override
    @Nonnull
     HashShortIntMap newUpdatableMap(@Nonnull Map<Short, Integer> map1,
            @Nonnull Map<Short, Integer> map2,
            @Nonnull Map<Short, Integer> map3,
            @Nonnull Map<Short, Integer> map4,
            @Nonnull Map<Short, Integer> map5, int expectedSize);



    @Override
    @Nonnull
     HashShortIntMap newUpdatableMap(@Nonnull
            Consumer<com.koloboke.function.ShortIntConsumer> entriesSupplier
            , int expectedSize);

    @Override
    @Nonnull
     HashShortIntMap newUpdatableMap(
            @Nonnull short[] keys, @Nonnull int[] values, int expectedSize);

    @Override
    @Nonnull
     HashShortIntMap newUpdatableMap(
            @Nonnull Short[] keys, @Nonnull Integer[] values, int expectedSize);

    @Override
    @Nonnull
     HashShortIntMap newUpdatableMap(@Nonnull Iterable<Short> keys,
            @Nonnull Iterable<Integer> values, int expectedSize);

    

    @Override
    @Nonnull
     HashShortIntMap newUpdatableMap(
            @Nonnull Map<Short, Integer> map);

    @Override
    @Nonnull
     HashShortIntMap newUpdatableMap(@Nonnull Map<Short, Integer> map1,
            @Nonnull Map<Short, Integer> map2);

    @Override
    @Nonnull
     HashShortIntMap newUpdatableMap(@Nonnull Map<Short, Integer> map1,
            @Nonnull Map<Short, Integer> map2,
            @Nonnull Map<Short, Integer> map3);

    @Override
    @Nonnull
     HashShortIntMap newUpdatableMap(@Nonnull Map<Short, Integer> map1,
            @Nonnull Map<Short, Integer> map2,
            @Nonnull Map<Short, Integer> map3,
            @Nonnull Map<Short, Integer> map4);

    @Override
    @Nonnull
     HashShortIntMap newUpdatableMap(@Nonnull Map<Short, Integer> map1,
            @Nonnull Map<Short, Integer> map2,
            @Nonnull Map<Short, Integer> map3,
            @Nonnull Map<Short, Integer> map4,
            @Nonnull Map<Short, Integer> map5);



    @Override
    @Nonnull
     HashShortIntMap newUpdatableMap(@Nonnull
            Consumer<com.koloboke.function.ShortIntConsumer> entriesSupplier
            );

    @Override
    @Nonnull
     HashShortIntMap newUpdatableMap(
            @Nonnull short[] keys, @Nonnull int[] values);

    @Override
    @Nonnull
     HashShortIntMap newUpdatableMap(
            @Nonnull Short[] keys, @Nonnull Integer[] values);

    @Override
    @Nonnull
     HashShortIntMap newUpdatableMap(@Nonnull Iterable<Short> keys,
            @Nonnull Iterable<Integer> values);


    @Override
    @Nonnull
     HashShortIntMap newUpdatableMapOf(short k1, int v1);

    @Override
    @Nonnull
     HashShortIntMap newUpdatableMapOf(short k1, int v1,
            short k2, int v2);

    @Override
    @Nonnull
     HashShortIntMap newUpdatableMapOf(short k1, int v1,
            short k2, int v2, short k3, int v3);

    @Override
    @Nonnull
     HashShortIntMap newUpdatableMapOf(short k1, int v1,
            short k2, int v2, short k3, int v3,
            short k4, int v4);

    @Override
    @Nonnull
     HashShortIntMap newUpdatableMapOf(short k1, int v1,
            short k2, int v2, short k3, int v3,
            short k4, int v4, short k5, int v5);

    


    @Override
    @Nonnull
     HashShortIntMap newImmutableMap(@Nonnull Map<Short, Integer> map1,
            @Nonnull Map<Short, Integer> map2, int expectedSize);

    @Override
    @Nonnull
     HashShortIntMap newImmutableMap(@Nonnull Map<Short, Integer> map1,
            @Nonnull Map<Short, Integer> map2,
            @Nonnull Map<Short, Integer> map3, int expectedSize);

    @Override
    @Nonnull
     HashShortIntMap newImmutableMap(@Nonnull Map<Short, Integer> map1,
            @Nonnull Map<Short, Integer> map2,
            @Nonnull Map<Short, Integer> map3,
            @Nonnull Map<Short, Integer> map4, int expectedSize);

    @Override
    @Nonnull
     HashShortIntMap newImmutableMap(@Nonnull Map<Short, Integer> map1,
            @Nonnull Map<Short, Integer> map2,
            @Nonnull Map<Short, Integer> map3,
            @Nonnull Map<Short, Integer> map4,
            @Nonnull Map<Short, Integer> map5, int expectedSize);



    @Override
    @Nonnull
     HashShortIntMap newImmutableMap(@Nonnull
            Consumer<com.koloboke.function.ShortIntConsumer> entriesSupplier
            , int expectedSize);

    @Override
    @Nonnull
     HashShortIntMap newImmutableMap(
            @Nonnull short[] keys, @Nonnull int[] values, int expectedSize);

    @Override
    @Nonnull
     HashShortIntMap newImmutableMap(
            @Nonnull Short[] keys, @Nonnull Integer[] values, int expectedSize);

    @Override
    @Nonnull
     HashShortIntMap newImmutableMap(@Nonnull Iterable<Short> keys,
            @Nonnull Iterable<Integer> values, int expectedSize);

    

    @Override
    @Nonnull
     HashShortIntMap newImmutableMap(
            @Nonnull Map<Short, Integer> map);

    @Override
    @Nonnull
     HashShortIntMap newImmutableMap(@Nonnull Map<Short, Integer> map1,
            @Nonnull Map<Short, Integer> map2);

    @Override
    @Nonnull
     HashShortIntMap newImmutableMap(@Nonnull Map<Short, Integer> map1,
            @Nonnull Map<Short, Integer> map2,
            @Nonnull Map<Short, Integer> map3);

    @Override
    @Nonnull
     HashShortIntMap newImmutableMap(@Nonnull Map<Short, Integer> map1,
            @Nonnull Map<Short, Integer> map2,
            @Nonnull Map<Short, Integer> map3,
            @Nonnull Map<Short, Integer> map4);

    @Override
    @Nonnull
     HashShortIntMap newImmutableMap(@Nonnull Map<Short, Integer> map1,
            @Nonnull Map<Short, Integer> map2,
            @Nonnull Map<Short, Integer> map3,
            @Nonnull Map<Short, Integer> map4,
            @Nonnull Map<Short, Integer> map5);



    @Override
    @Nonnull
     HashShortIntMap newImmutableMap(@Nonnull
            Consumer<com.koloboke.function.ShortIntConsumer> entriesSupplier
            );

    @Override
    @Nonnull
     HashShortIntMap newImmutableMap(
            @Nonnull short[] keys, @Nonnull int[] values);

    @Override
    @Nonnull
     HashShortIntMap newImmutableMap(
            @Nonnull Short[] keys, @Nonnull Integer[] values);

    @Override
    @Nonnull
     HashShortIntMap newImmutableMap(@Nonnull Iterable<Short> keys,
            @Nonnull Iterable<Integer> values);


    @Override
    @Nonnull
     HashShortIntMap newImmutableMapOf(short k1, int v1);

    @Override
    @Nonnull
     HashShortIntMap newImmutableMapOf(short k1, int v1,
            short k2, int v2);

    @Override
    @Nonnull
     HashShortIntMap newImmutableMapOf(short k1, int v1,
            short k2, int v2, short k3, int v3);

    @Override
    @Nonnull
     HashShortIntMap newImmutableMapOf(short k1, int v1,
            short k2, int v2, short k3, int v3,
            short k4, int v4);

    @Override
    @Nonnull
     HashShortIntMap newImmutableMapOf(short k1, int v1,
            short k2, int v2, short k3, int v3,
            short k4, int v4, short k5, int v5);
}
