/*
 * Copyright 2014 the original author or authors.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package com.koloboke.collect.map.hash;

import com.koloboke.collect.*;
import com.koloboke.collect.hash.*;
import com.koloboke.compile.CustomKeyEquivalence;
import com.koloboke.compile.KolobokeMap;
import java.util.function.Consumer;
import com.koloboke.collect.map.*;

import javax.annotation.Nonnull;

import java.util.Map;



/**
 * An immutable factory of {@code HashShortCharMap}s.
 *
 * @see HashShortCharMap
 * @see HashShortCharMaps#getDefaultFactory()
 * @see KolobokeMap @KolobokeMap
 */
public interface HashShortCharMapFactory
        extends ShortCharMapFactory<HashShortCharMapFactory>
        , ShortHashFactory<HashShortCharMapFactory>
        {


    

    

    

    

    

    
    

    
    


    @Override
    @Nonnull
     HashShortCharMap newMutableMap();

    @Override
    @Nonnull
     HashShortCharMap newMutableMap(int expectedSize);

    


    @Override
    @Nonnull
     HashShortCharMap newMutableMap(@Nonnull Map<Short, Character> map1,
            @Nonnull Map<Short, Character> map2, int expectedSize);

    @Override
    @Nonnull
     HashShortCharMap newMutableMap(@Nonnull Map<Short, Character> map1,
            @Nonnull Map<Short, Character> map2,
            @Nonnull Map<Short, Character> map3, int expectedSize);

    @Override
    @Nonnull
     HashShortCharMap newMutableMap(@Nonnull Map<Short, Character> map1,
            @Nonnull Map<Short, Character> map2,
            @Nonnull Map<Short, Character> map3,
            @Nonnull Map<Short, Character> map4, int expectedSize);

    @Override
    @Nonnull
     HashShortCharMap newMutableMap(@Nonnull Map<Short, Character> map1,
            @Nonnull Map<Short, Character> map2,
            @Nonnull Map<Short, Character> map3,
            @Nonnull Map<Short, Character> map4,
            @Nonnull Map<Short, Character> map5, int expectedSize);



    @Override
    @Nonnull
     HashShortCharMap newMutableMap(@Nonnull
            Consumer<com.koloboke.function.ShortCharConsumer> entriesSupplier
            , int expectedSize);

    @Override
    @Nonnull
     HashShortCharMap newMutableMap(
            @Nonnull short[] keys, @Nonnull char[] values, int expectedSize);

    @Override
    @Nonnull
     HashShortCharMap newMutableMap(
            @Nonnull Short[] keys, @Nonnull Character[] values, int expectedSize);

    @Override
    @Nonnull
     HashShortCharMap newMutableMap(@Nonnull Iterable<Short> keys,
            @Nonnull Iterable<Character> values, int expectedSize);

    

    @Override
    @Nonnull
     HashShortCharMap newMutableMap(
            @Nonnull Map<Short, Character> map);

    @Override
    @Nonnull
     HashShortCharMap newMutableMap(@Nonnull Map<Short, Character> map1,
            @Nonnull Map<Short, Character> map2);

    @Override
    @Nonnull
     HashShortCharMap newMutableMap(@Nonnull Map<Short, Character> map1,
            @Nonnull Map<Short, Character> map2,
            @Nonnull Map<Short, Character> map3);

    @Override
    @Nonnull
     HashShortCharMap newMutableMap(@Nonnull Map<Short, Character> map1,
            @Nonnull Map<Short, Character> map2,
            @Nonnull Map<Short, Character> map3,
            @Nonnull Map<Short, Character> map4);

    @Override
    @Nonnull
     HashShortCharMap newMutableMap(@Nonnull Map<Short, Character> map1,
            @Nonnull Map<Short, Character> map2,
            @Nonnull Map<Short, Character> map3,
            @Nonnull Map<Short, Character> map4,
            @Nonnull Map<Short, Character> map5);



    @Override
    @Nonnull
     HashShortCharMap newMutableMap(@Nonnull
            Consumer<com.koloboke.function.ShortCharConsumer> entriesSupplier
            );

    @Override
    @Nonnull
     HashShortCharMap newMutableMap(
            @Nonnull short[] keys, @Nonnull char[] values);

    @Override
    @Nonnull
     HashShortCharMap newMutableMap(
            @Nonnull Short[] keys, @Nonnull Character[] values);

    @Override
    @Nonnull
     HashShortCharMap newMutableMap(@Nonnull Iterable<Short> keys,
            @Nonnull Iterable<Character> values);


    @Override
    @Nonnull
     HashShortCharMap newMutableMapOf(short k1, char v1);

    @Override
    @Nonnull
     HashShortCharMap newMutableMapOf(short k1, char v1,
            short k2, char v2);

    @Override
    @Nonnull
     HashShortCharMap newMutableMapOf(short k1, char v1,
            short k2, char v2, short k3, char v3);

    @Override
    @Nonnull
     HashShortCharMap newMutableMapOf(short k1, char v1,
            short k2, char v2, short k3, char v3,
            short k4, char v4);

    @Override
    @Nonnull
     HashShortCharMap newMutableMapOf(short k1, char v1,
            short k2, char v2, short k3, char v3,
            short k4, char v4, short k5, char v5);
    @Override
    @Nonnull
     HashShortCharMap newUpdatableMap();

    @Override
    @Nonnull
     HashShortCharMap newUpdatableMap(int expectedSize);

    


    @Override
    @Nonnull
     HashShortCharMap newUpdatableMap(@Nonnull Map<Short, Character> map1,
            @Nonnull Map<Short, Character> map2, int expectedSize);

    @Override
    @Nonnull
     HashShortCharMap newUpdatableMap(@Nonnull Map<Short, Character> map1,
            @Nonnull Map<Short, Character> map2,
            @Nonnull Map<Short, Character> map3, int expectedSize);

    @Override
    @Nonnull
     HashShortCharMap newUpdatableMap(@Nonnull Map<Short, Character> map1,
            @Nonnull Map<Short, Character> map2,
            @Nonnull Map<Short, Character> map3,
            @Nonnull Map<Short, Character> map4, int expectedSize);

    @Override
    @Nonnull
     HashShortCharMap newUpdatableMap(@Nonnull Map<Short, Character> map1,
            @Nonnull Map<Short, Character> map2,
            @Nonnull Map<Short, Character> map3,
            @Nonnull Map<Short, Character> map4,
            @Nonnull Map<Short, Character> map5, int expectedSize);



    @Override
    @Nonnull
     HashShortCharMap newUpdatableMap(@Nonnull
            Consumer<com.koloboke.function.ShortCharConsumer> entriesSupplier
            , int expectedSize);

    @Override
    @Nonnull
     HashShortCharMap newUpdatableMap(
            @Nonnull short[] keys, @Nonnull char[] values, int expectedSize);

    @Override
    @Nonnull
     HashShortCharMap newUpdatableMap(
            @Nonnull Short[] keys, @Nonnull Character[] values, int expectedSize);

    @Override
    @Nonnull
     HashShortCharMap newUpdatableMap(@Nonnull Iterable<Short> keys,
            @Nonnull Iterable<Character> values, int expectedSize);

    

    @Override
    @Nonnull
     HashShortCharMap newUpdatableMap(
            @Nonnull Map<Short, Character> map);

    @Override
    @Nonnull
     HashShortCharMap newUpdatableMap(@Nonnull Map<Short, Character> map1,
            @Nonnull Map<Short, Character> map2);

    @Override
    @Nonnull
     HashShortCharMap newUpdatableMap(@Nonnull Map<Short, Character> map1,
            @Nonnull Map<Short, Character> map2,
            @Nonnull Map<Short, Character> map3);

    @Override
    @Nonnull
     HashShortCharMap newUpdatableMap(@Nonnull Map<Short, Character> map1,
            @Nonnull Map<Short, Character> map2,
            @Nonnull Map<Short, Character> map3,
            @Nonnull Map<Short, Character> map4);

    @Override
    @Nonnull
     HashShortCharMap newUpdatableMap(@Nonnull Map<Short, Character> map1,
            @Nonnull Map<Short, Character> map2,
            @Nonnull Map<Short, Character> map3,
            @Nonnull Map<Short, Character> map4,
            @Nonnull Map<Short, Character> map5);



    @Override
    @Nonnull
     HashShortCharMap newUpdatableMap(@Nonnull
            Consumer<com.koloboke.function.ShortCharConsumer> entriesSupplier
            );

    @Override
    @Nonnull
     HashShortCharMap newUpdatableMap(
            @Nonnull short[] keys, @Nonnull char[] values);

    @Override
    @Nonnull
     HashShortCharMap newUpdatableMap(
            @Nonnull Short[] keys, @Nonnull Character[] values);

    @Override
    @Nonnull
     HashShortCharMap newUpdatableMap(@Nonnull Iterable<Short> keys,
            @Nonnull Iterable<Character> values);


    @Override
    @Nonnull
     HashShortCharMap newUpdatableMapOf(short k1, char v1);

    @Override
    @Nonnull
     HashShortCharMap newUpdatableMapOf(short k1, char v1,
            short k2, char v2);

    @Override
    @Nonnull
     HashShortCharMap newUpdatableMapOf(short k1, char v1,
            short k2, char v2, short k3, char v3);

    @Override
    @Nonnull
     HashShortCharMap newUpdatableMapOf(short k1, char v1,
            short k2, char v2, short k3, char v3,
            short k4, char v4);

    @Override
    @Nonnull
     HashShortCharMap newUpdatableMapOf(short k1, char v1,
            short k2, char v2, short k3, char v3,
            short k4, char v4, short k5, char v5);

    


    @Override
    @Nonnull
     HashShortCharMap newImmutableMap(@Nonnull Map<Short, Character> map1,
            @Nonnull Map<Short, Character> map2, int expectedSize);

    @Override
    @Nonnull
     HashShortCharMap newImmutableMap(@Nonnull Map<Short, Character> map1,
            @Nonnull Map<Short, Character> map2,
            @Nonnull Map<Short, Character> map3, int expectedSize);

    @Override
    @Nonnull
     HashShortCharMap newImmutableMap(@Nonnull Map<Short, Character> map1,
            @Nonnull Map<Short, Character> map2,
            @Nonnull Map<Short, Character> map3,
            @Nonnull Map<Short, Character> map4, int expectedSize);

    @Override
    @Nonnull
     HashShortCharMap newImmutableMap(@Nonnull Map<Short, Character> map1,
            @Nonnull Map<Short, Character> map2,
            @Nonnull Map<Short, Character> map3,
            @Nonnull Map<Short, Character> map4,
            @Nonnull Map<Short, Character> map5, int expectedSize);



    @Override
    @Nonnull
     HashShortCharMap newImmutableMap(@Nonnull
            Consumer<com.koloboke.function.ShortCharConsumer> entriesSupplier
            , int expectedSize);

    @Override
    @Nonnull
     HashShortCharMap newImmutableMap(
            @Nonnull short[] keys, @Nonnull char[] values, int expectedSize);

    @Override
    @Nonnull
     HashShortCharMap newImmutableMap(
            @Nonnull Short[] keys, @Nonnull Character[] values, int expectedSize);

    @Override
    @Nonnull
     HashShortCharMap newImmutableMap(@Nonnull Iterable<Short> keys,
            @Nonnull Iterable<Character> values, int expectedSize);

    

    @Override
    @Nonnull
     HashShortCharMap newImmutableMap(
            @Nonnull Map<Short, Character> map);

    @Override
    @Nonnull
     HashShortCharMap newImmutableMap(@Nonnull Map<Short, Character> map1,
            @Nonnull Map<Short, Character> map2);

    @Override
    @Nonnull
     HashShortCharMap newImmutableMap(@Nonnull Map<Short, Character> map1,
            @Nonnull Map<Short, Character> map2,
            @Nonnull Map<Short, Character> map3);

    @Override
    @Nonnull
     HashShortCharMap newImmutableMap(@Nonnull Map<Short, Character> map1,
            @Nonnull Map<Short, Character> map2,
            @Nonnull Map<Short, Character> map3,
            @Nonnull Map<Short, Character> map4);

    @Override
    @Nonnull
     HashShortCharMap newImmutableMap(@Nonnull Map<Short, Character> map1,
            @Nonnull Map<Short, Character> map2,
            @Nonnull Map<Short, Character> map3,
            @Nonnull Map<Short, Character> map4,
            @Nonnull Map<Short, Character> map5);



    @Override
    @Nonnull
     HashShortCharMap newImmutableMap(@Nonnull
            Consumer<com.koloboke.function.ShortCharConsumer> entriesSupplier
            );

    @Override
    @Nonnull
     HashShortCharMap newImmutableMap(
            @Nonnull short[] keys, @Nonnull char[] values);

    @Override
    @Nonnull
     HashShortCharMap newImmutableMap(
            @Nonnull Short[] keys, @Nonnull Character[] values);

    @Override
    @Nonnull
     HashShortCharMap newImmutableMap(@Nonnull Iterable<Short> keys,
            @Nonnull Iterable<Character> values);


    @Override
    @Nonnull
     HashShortCharMap newImmutableMapOf(short k1, char v1);

    @Override
    @Nonnull
     HashShortCharMap newImmutableMapOf(short k1, char v1,
            short k2, char v2);

    @Override
    @Nonnull
     HashShortCharMap newImmutableMapOf(short k1, char v1,
            short k2, char v2, short k3, char v3);

    @Override
    @Nonnull
     HashShortCharMap newImmutableMapOf(short k1, char v1,
            short k2, char v2, short k3, char v3,
            short k4, char v4);

    @Override
    @Nonnull
     HashShortCharMap newImmutableMapOf(short k1, char v1,
            short k2, char v2, short k3, char v3,
            short k4, char v4, short k5, char v5);
}
